/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.data;

import java.nio.charset.Charset;
import org.openmuc.framework.data.TypeConversionException;
import org.openmuc.framework.data.Value;
import org.openmuc.framework.data.ValueType;

public class StringValue
implements Value {
    private final String value;
    private static final Charset charset = Charset.forName("US-ASCII");

    public StringValue(String value) {
        this.value = value;
    }

    @Override
    public double asDouble() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            throw new TypeConversionException();
        }
    }

    @Override
    public float asFloat() {
        try {
            return Float.parseFloat(this.value);
        }
        catch (NumberFormatException e) {
            throw new TypeConversionException();
        }
    }

    @Override
    public long asLong() {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException e) {
            throw new TypeConversionException();
        }
    }

    @Override
    public int asInt() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e) {
            throw new TypeConversionException();
        }
    }

    @Override
    public short asShort() {
        try {
            return Short.parseShort(this.value);
        }
        catch (NumberFormatException e) {
            throw new TypeConversionException();
        }
    }

    @Override
    public byte asByte() {
        try {
            return Byte.parseByte(this.value);
        }
        catch (NumberFormatException e) {
            throw new TypeConversionException();
        }
    }

    @Override
    public boolean asBoolean() {
        return Boolean.parseBoolean(this.value);
    }

    @Override
    public byte[] asByteArray() {
        return this.value.getBytes(charset);
    }

    public String toString() {
        return this.value;
    }

    @Override
    public String asString() {
        return this.toString();
    }

    @Override
    public ValueType getValueType() {
        return ValueType.STRING;
    }
}

