/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.dataaccess;

import java.io.IOException;
import java.util.List;
import org.openmuc.framework.data.Flag;
import org.openmuc.framework.data.FutureValue;
import org.openmuc.framework.data.Record;
import org.openmuc.framework.data.Value;
import org.openmuc.framework.data.ValueType;
import org.openmuc.framework.dataaccess.ChannelState;
import org.openmuc.framework.dataaccess.DataLoggerNotAvailableException;
import org.openmuc.framework.dataaccess.DeviceState;
import org.openmuc.framework.dataaccess.ReadRecordContainer;
import org.openmuc.framework.dataaccess.RecordListener;
import org.openmuc.framework.dataaccess.WriteValueContainer;

public interface Channel {
    public String getId();

    public String getChannelAddress();

    public String getDescription();

    public String getSettings();

    public String getLoggingSettings();

    public String getUnit();

    public ValueType getValueType();

    public double getScalingFactor();

    public int getSamplingInterval();

    public int getSamplingTimeOffset();

    public int getSamplingTimeout();

    public int getLoggingInterval();

    public int getLoggingTimeOffset();

    public String getDriverName();

    public String getDeviceAddress();

    public String getDeviceName();

    public String getDeviceDescription();

    public ChannelState getChannelState();

    public DeviceState getDeviceState();

    public void addListener(RecordListener var1);

    public void removeListener(RecordListener var1);

    public boolean isConnected();

    public Record getLatestRecord();

    public void setLatestRecord(Record var1);

    public Flag write(Value var1);

    public void writeFuture(List<FutureValue> var1);

    public WriteValueContainer getWriteContainer();

    public Record read();

    public ReadRecordContainer getReadContainer();

    public Record getLoggedRecord(long var1) throws DataLoggerNotAvailableException, IOException;

    public List<Record> getLoggedRecords(long var1) throws DataLoggerNotAvailableException, IOException;

    public List<Record> getLoggedRecords(long var1, long var3) throws DataLoggerNotAvailableException, IOException;
}

