/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.elasticsearch.plugin.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public abstract class MultiValuesSource<VS extends ValuesSource> {
    protected Map<String, VS> values;

    public boolean needsScores() {
        return this.values.values().stream().anyMatch(ValuesSource::needsScores);
    }

    public String[] fieldNames() {
        return this.values.keySet().toArray(new String[0]);
    }

    public boolean areValuesSourcesEmpty() {
        return this.values.values().stream().allMatch(Objects::isNull);
    }

    public static class NumericMultiValuesSource
    extends MultiValuesSource<ValuesSource.Numeric> {
        public NumericMultiValuesSource(Map<String, ValuesSourceConfig> valuesSourceConfigs) {
            this.values = new HashMap(valuesSourceConfigs.size());
            for (Map.Entry<String, ValuesSourceConfig> entry : valuesSourceConfigs.entrySet()) {
                this.values.put(entry.getKey(), (ValuesSource.Numeric)entry.getValue().getValuesSource());
            }
        }

        public SortedNumericDoubleValues getField(String fieldName, LeafReaderContext ctx) throws IOException {
            ValuesSource.Numeric value = (ValuesSource.Numeric)this.values.get(fieldName);
            if (value == null) {
                throw new IllegalArgumentException("Could not find field name [" + fieldName + "] in multiValuesSource");
            }
            return value.doubleValues(ctx);
        }
    }
}

