/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.elasticsearch.plugin.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.rounding.DateTimeUnit;
import org.elasticsearch.common.rounding.Rounding;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.LongBounds;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceFieldConfig;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceParseHelper;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.joda.time.DateTimeZone;
import org.opennms.elasticsearch.plugin.aggregations.bucket.histogram.ProportionalSumAggregatorFactory;

public class ProportionalSumAggregationBuilder
extends MultiValuesSourceAggregationBuilder<ProportionalSumAggregationBuilder> {
    public static final String NAME = "proportional_sum";
    private static DateMathParser EPOCH_MILLIS_PARSER = Joda.forPattern((String)"epoch_millis").toDateMathParser();
    private static ParseField START_FIELD = new ParseField("start", new String[0]);
    private static ParseField END_FIELD = new ParseField("end", new String[0]);
    private static ParseField FIELDS_FIELD = new ParseField("fields", new String[0]);
    public static final Map<String, DateTimeUnit> DATE_FIELD_UNITS;
    private static final ObjectParser<ProportionalSumAggregationBuilder, Void> PARSER;
    private long interval;
    private DateHistogramInterval dateHistogramInterval;
    private long offset = 0L;
    private LongBounds extendedBounds;
    private BucketOrder order = BucketOrder.key((boolean)true);
    private boolean keyed = false;
    private long minDocCount = 0L;
    private Long start;
    private Long end;
    private String[] fieldNames;

    public static ProportionalSumAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        return (ProportionalSumAggregationBuilder)((Object)PARSER.parse(parser, (Object)new ProportionalSumAggregationBuilder(aggregationName), null));
    }

    public ProportionalSumAggregationBuilder(String name) {
        super(name);
    }

    protected ProportionalSumAggregationBuilder(ProportionalSumAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super((MultiValuesSourceAggregationBuilder)clone, factoriesBuilder, metaData);
        this.interval = clone.interval;
        this.dateHistogramInterval = clone.dateHistogramInterval;
        this.offset = clone.offset;
        this.extendedBounds = clone.extendedBounds;
        this.order = clone.order;
        this.keyed = clone.keyed;
        this.minDocCount = clone.minDocCount;
        this.start = clone.start;
        this.end = clone.end;
        this.fieldNames = clone.fieldNames;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new ProportionalSumAggregationBuilder(this, factoriesBuilder, metaData);
    }

    public ProportionalSumAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.order = InternalOrder.Streams.readHistogramOrder((StreamInput)in, (boolean)true);
        this.keyed = in.readBoolean();
        this.minDocCount = in.readVLong();
        this.interval = in.readLong();
        this.dateHistogramInterval = (DateHistogramInterval)in.readOptionalWriteable(DateHistogramInterval::new);
        this.offset = in.readLong();
        this.extendedBounds = (LongBounds)in.readOptionalWriteable(LongBounds::new);
        this.start = in.readOptionalLong();
        this.end = in.readOptionalLong();
        this.fieldNames = in.readOptionalStringArray();
    }

    protected void innerWriteTo(StreamOutput out) throws IOException {
        InternalOrder.Streams.writeHistogramOrder((BucketOrder)this.order, (StreamOutput)out, (boolean)true);
        out.writeBoolean(this.keyed);
        out.writeVLong(this.minDocCount);
        out.writeLong(this.interval);
        out.writeOptionalWriteable((Writeable)this.dateHistogramInterval);
        out.writeLong(this.offset);
        out.writeOptionalWriteable((Writeable)this.extendedBounds);
        out.writeOptionalLong(this.start);
        out.writeOptionalLong(this.end);
        out.writeOptionalStringArray(this.fieldNames);
    }

    public ProportionalSumAggregationBuilder fields(List<String> fields) {
        for (String field : fields) {
            MultiValuesSourceFieldConfig config = new MultiValuesSourceFieldConfig.Builder().setFieldName(field).build();
            this.field(field, config);
        }
        this.fieldNames = fields.toArray(new String[0]);
        return this;
    }

    public Long start() {
        return this.start;
    }

    public ProportionalSumAggregationBuilder start(Long start) {
        this.start = start;
        return this;
    }

    public Long end() {
        return this.start;
    }

    public ProportionalSumAggregationBuilder end(Long end) {
        this.end = end;
        return this;
    }

    public long interval() {
        return this.interval;
    }

    public ProportionalSumAggregationBuilder interval(long interval) {
        if (interval < 1L) {
            throw new IllegalArgumentException("[interval] must be 1 or greater for histogram aggregation [" + this.name + "]");
        }
        this.interval = interval;
        return this;
    }

    public DateHistogramInterval dateHistogramInterval() {
        return this.dateHistogramInterval;
    }

    public ProportionalSumAggregationBuilder dateHistogramInterval(DateHistogramInterval dateHistogramInterval) {
        if (dateHistogramInterval == null) {
            throw new IllegalArgumentException("[dateHistogramInterval] must not be null: [" + this.name + "]");
        }
        this.dateHistogramInterval = dateHistogramInterval;
        return this;
    }

    public long offset() {
        return this.offset;
    }

    public ProportionalSumAggregationBuilder offset(long offset) {
        this.offset = offset;
        return this;
    }

    public ProportionalSumAggregationBuilder offset(String offset) {
        if (offset == null) {
            throw new IllegalArgumentException("[offset] must not be null: [" + this.name + "]");
        }
        return this.offset(ProportionalSumAggregationBuilder.parseStringOffset(offset));
    }

    static long parseStringOffset(String offset) {
        if (offset.charAt(0) == '-') {
            return -TimeValue.parseTimeValue((String)offset.substring(1), null, (String)(ProportionalSumAggregationBuilder.class.getSimpleName() + ".parseOffset")).millis();
        }
        int beginIndex = offset.charAt(0) == '+' ? 1 : 0;
        return TimeValue.parseTimeValue((String)offset.substring(beginIndex), null, (String)(ProportionalSumAggregationBuilder.class.getSimpleName() + ".parseOffset")).millis();
    }

    public LongBounds extendedBounds() {
        return this.extendedBounds;
    }

    public ProportionalSumAggregationBuilder extendedBounds(LongBounds extendedBounds) {
        if (extendedBounds == null) {
            throw new IllegalArgumentException("[extendedBounds] must not be null: [" + this.name + "]");
        }
        this.extendedBounds = extendedBounds;
        return this;
    }

    public BucketOrder order() {
        return this.order;
    }

    public ProportionalSumAggregationBuilder order(BucketOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("[order] must not be null: [" + this.name + "]");
        }
        this.order = order instanceof InternalOrder.CompoundOrder || InternalOrder.isKeyOrder((BucketOrder)order) ? order : BucketOrder.compound((BucketOrder[])new BucketOrder[]{order});
        return this;
    }

    public ProportionalSumAggregationBuilder order(List<BucketOrder> orders) {
        if (orders == null) {
            throw new IllegalArgumentException("[orders] must not be null: [" + this.name + "]");
        }
        this.order(orders.size() > 1 ? BucketOrder.compound(orders) : orders.get(0));
        return this;
    }

    public boolean keyed() {
        return this.keyed;
    }

    public ProportionalSumAggregationBuilder keyed(boolean keyed) {
        this.keyed = keyed;
        return this;
    }

    public long minDocCount() {
        return this.minDocCount;
    }

    public ProportionalSumAggregationBuilder minDocCount(long minDocCount) {
        if (minDocCount < 0L) {
            throw new IllegalArgumentException("[minDocCount] must be greater than or equal to 0. Found [" + minDocCount + "] in [" + this.name + "]");
        }
        this.minDocCount = minDocCount;
        return this;
    }

    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.dateHistogramInterval == null) {
            builder.field(Histogram.INTERVAL_FIELD.getPreferredName(), this.interval);
        } else {
            builder.field(Histogram.INTERVAL_FIELD.getPreferredName(), this.dateHistogramInterval.toString());
        }
        builder.field(Histogram.OFFSET_FIELD.getPreferredName(), this.offset);
        if (this.order != null) {
            builder.field(Histogram.ORDER_FIELD.getPreferredName());
            this.order.toXContent(builder, params);
        }
        builder.field(Histogram.KEYED_FIELD.getPreferredName(), this.keyed);
        builder.field(Histogram.MIN_DOC_COUNT_FIELD.getPreferredName(), this.minDocCount);
        if (this.extendedBounds != null) {
            this.extendedBounds.toXContent(builder, params);
        }
        if (this.start != null) {
            builder.field(START_FIELD.getPreferredName(), this.start);
        }
        if (this.end != null) {
            builder.field(END_FIELD.getPreferredName(), this.end);
        }
        return builder;
    }

    public String getType() {
        return NAME;
    }

    DateTimeZone rewriteTimeZone(AggregationContext context) throws IOException {
        DateTimeZone tz = null;
        return tz;
    }

    protected MultiValuesSourceAggregatorFactory innerBuild(AggregationContext context, Map<String, ValuesSourceConfig> configs, Map<String, QueryBuilder> filters, DocValueFormat format, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        DateTimeZone tz = null;
        Rounding rounding = this.createRounding(tz);
        DateTimeZone rewrittenTimeZone = this.rewriteTimeZone(context);
        Rounding shardRounding = tz == rewrittenTimeZone ? rounding : this.createRounding(rewrittenTimeZone);
        LongBounds roundedBounds = null;
        if (this.extendedBounds != null) {
            // empty if block
        }
        return new ProportionalSumAggregatorFactory(this.name, configs, this.offset, this.order, this.keyed, this.minDocCount, rounding, shardRounding, roundedBounds, format, context, parent, subFactoriesBuilder, this.metadata, this.start, this.end, this.fieldNames);
    }

    private DateTimeUnit getIntervalAsDateTimeUnit() {
        if (this.dateHistogramInterval != null) {
            return DATE_FIELD_UNITS.get(this.dateHistogramInterval.toString());
        }
        return null;
    }

    private TimeValue getIntervalAsTimeValue() {
        if (this.dateHistogramInterval != null) {
            return TimeValue.parseTimeValue((String)this.dateHistogramInterval.toString(), null, (String)(((Object)((Object)this)).getClass().getSimpleName() + ".interval"));
        }
        return TimeValue.timeValueMillis((long)this.interval);
    }

    private Rounding createRounding(DateTimeZone timeZone) {
        DateTimeUnit intervalAsUnit = this.getIntervalAsDateTimeUnit();
        Rounding.Builder tzRoundingBuilder = intervalAsUnit != null ? Rounding.builder((DateTimeUnit)intervalAsUnit) : Rounding.builder((TimeValue)this.getIntervalAsTimeValue());
        if (timeZone != null) {
            tzRoundingBuilder.timeZone(timeZone);
        }
        Rounding rounding = tzRoundingBuilder.build();
        return rounding;
    }

    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.NUMERIC;
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.MANY;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.order, this.keyed, this.minDocCount, this.interval, this.dateHistogramInterval, this.minDocCount, this.extendedBounds, this.start, this.end);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ProportionalSumAggregationBuilder other = (ProportionalSumAggregationBuilder)((Object)obj);
        return Objects.equals(this.order, other.order) && Objects.equals(this.keyed, other.keyed) && Objects.equals(this.minDocCount, other.minDocCount) && Objects.equals(this.interval, other.interval) && Objects.equals(this.dateHistogramInterval, other.dateHistogramInterval) && Objects.equals(this.offset, other.offset) && Objects.equals(this.extendedBounds, other.extendedBounds) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end);
    }

    static {
        HashMap<String, DateTimeUnit> dateFieldUnits = new HashMap<String, DateTimeUnit>();
        dateFieldUnits.put("year", DateTimeUnit.YEAR_OF_CENTURY);
        dateFieldUnits.put("1y", DateTimeUnit.YEAR_OF_CENTURY);
        dateFieldUnits.put("quarter", DateTimeUnit.QUARTER);
        dateFieldUnits.put("1q", DateTimeUnit.QUARTER);
        dateFieldUnits.put("month", DateTimeUnit.MONTH_OF_YEAR);
        dateFieldUnits.put("1M", DateTimeUnit.MONTH_OF_YEAR);
        dateFieldUnits.put("week", DateTimeUnit.WEEK_OF_WEEKYEAR);
        dateFieldUnits.put("1w", DateTimeUnit.WEEK_OF_WEEKYEAR);
        dateFieldUnits.put("day", DateTimeUnit.DAY_OF_MONTH);
        dateFieldUnits.put("1d", DateTimeUnit.DAY_OF_MONTH);
        dateFieldUnits.put("hour", DateTimeUnit.HOUR_OF_DAY);
        dateFieldUnits.put("1h", DateTimeUnit.HOUR_OF_DAY);
        dateFieldUnits.put("minute", DateTimeUnit.MINUTES_OF_HOUR);
        dateFieldUnits.put("1m", DateTimeUnit.MINUTES_OF_HOUR);
        dateFieldUnits.put("second", DateTimeUnit.SECOND_OF_MINUTE);
        dateFieldUnits.put("1s", DateTimeUnit.SECOND_OF_MINUTE);
        DATE_FIELD_UNITS = Collections.unmodifiableMap(dateFieldUnits);
        PARSER = new ObjectParser(NAME);
        MultiValuesSourceParseHelper.declareCommon(PARSER, (boolean)true, (ValueType)ValueType.NUMERIC);
        PARSER.declareField((histogram, interval) -> {
            if (interval instanceof Long) {
                histogram.interval((Long)interval);
            } else {
                histogram.dateHistogramInterval((DateHistogramInterval)interval);
            }
        }, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return p.longValue();
            }
            return new DateHistogramInterval(p.text());
        }, Histogram.INTERVAL_FIELD, ObjectParser.ValueType.LONG);
        PARSER.declareField(ProportionalSumAggregationBuilder::offset, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return p.longValue();
            }
            return ProportionalSumAggregationBuilder.parseStringOffset(p.text());
        }, Histogram.OFFSET_FIELD, ObjectParser.ValueType.LONG);
        PARSER.declareBoolean(ProportionalSumAggregationBuilder::keyed, Histogram.KEYED_FIELD);
        PARSER.declareLong(ProportionalSumAggregationBuilder::minDocCount, Histogram.MIN_DOC_COUNT_FIELD);
        PARSER.declareField(ProportionalSumAggregationBuilder::extendedBounds, parser -> (LongBounds)LongBounds.PARSER.apply(parser, null), new ParseField("extended_bounds", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareObjectArray(ProportionalSumAggregationBuilder::order, (p, c) -> InternalOrder.Parser.parseOrderParam((XContentParser)p), Histogram.ORDER_FIELD);
        PARSER.declareStringArray(ProportionalSumAggregationBuilder::fields, FIELDS_FIELD);
        PARSER.declareLong(ProportionalSumAggregationBuilder::start, START_FIELD);
        PARSER.declareLong(ProportionalSumAggregationBuilder::end, END_FIELD);
    }
}

