/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.elasticsearch.plugin.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.rounding.Rounding;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.LongBounds;
import org.elasticsearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.opennms.elasticsearch.plugin.aggregations.bucket.histogram.InternalProportionalSumHistogram;
import org.opennms.elasticsearch.plugin.aggregations.bucket.histogram.MultiValuesSource;
import org.opennms.elasticsearch.plugin.aggregations.bucket.histogram.OrderedValueReferences;

public class ProportionalSumAggregator
extends BucketsAggregator {
    private final MultiValuesSource.NumericMultiValuesSource valuesSources;
    private final DocValueFormat formatter;
    private final Rounding rounding;
    private final BucketOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final LongBounds extendedBounds;
    private final LongKeyedBucketOrds bucketOrds;
    private final long offset;
    private DoubleArray sums;
    private final Long start;
    private final Long end;
    private final String[] fieldNames;
    private final AggregationContext context;

    ProportionalSumAggregator(String name, AggregatorFactories factories, Rounding rounding, long offset, BucketOrder order, boolean keyed, long minDocCount, LongBounds extendedBounds, Map<String, ValuesSourceConfig> valuesSourceConfigs, DocValueFormat formatter, AggregationContext context, Aggregator parent, CardinalityUpperBound bucketCardinality, Map<String, Object> metaData, Long start, Long end, String[] fieldNames) throws IOException {
        super(name, factories, context, parent, bucketCardinality, metaData);
        this.rounding = rounding;
        this.offset = offset;
        this.order = order;
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.extendedBounds = extendedBounds;
        this.formatter = formatter;
        this.start = start != null ? start : Long.MIN_VALUE;
        this.end = end != null ? end : Long.MAX_VALUE;
        this.fieldNames = fieldNames;
        this.context = context;
        this.valuesSources = valuesSourceConfigs != null && !valuesSourceConfigs.isEmpty() ? new MultiValuesSource.NumericMultiValuesSource(valuesSourceConfigs) : null;
        this.bucketOrds = LongKeyedBucketOrds.build((BigArrays)context.bigArrays(), (CardinalityUpperBound)bucketCardinality);
        this.sums = context.bigArrays().newDoubleArray(1L, true);
        order.validate((Aggregator)this);
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (this.valuesSources == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final OrderedValueReferences orderedValueReferences = new OrderedValueReferences(ctx, this.valuesSources, this.fieldNames);
        SortedNumericDoubleValues[] values = orderedValueReferences.getValuesArray();
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long owningBucketOrd) throws IOException {
                Double samplingValue;
                SortedNumericDoubleValues samplingDoubleValues;
                SortedNumericDoubleValues rangeStartDoubleValues = orderedValueReferences.getRangeStarts();
                long rangeStartVal = 0L;
                if (rangeStartDoubleValues.advanceExact(doc)) {
                    rangeStartVal = Double.valueOf(rangeStartDoubleValues.nextValue()).longValue();
                }
                if (rangeStartVal < 0L) {
                    throw new IllegalArgumentException("Invalid range start: " + rangeStartVal);
                }
                SortedNumericDoubleValues rangeEndDoubleValues = orderedValueReferences.getRangeEnds();
                long rangeEndVal = 0L;
                if (rangeEndDoubleValues.advanceExact(doc)) {
                    rangeEndVal = Double.valueOf(rangeEndDoubleValues.nextValue()).longValue();
                }
                if (rangeEndVal < 0L) {
                    throw new IllegalArgumentException("Invalid range end: " + rangeEndVal);
                }
                if (rangeEndVal < rangeStartVal) {
                    throw new IllegalArgumentException("Start cannot be after end! start: " + rangeStartVal + " end: " + rangeEndVal);
                }
                Long rangeDuration = rangeEndVal - rangeStartVal;
                SortedNumericDoubleValues valueDoubleValues = orderedValueReferences.getValues();
                double valueVal = Double.NaN;
                if (valueDoubleValues.advanceExact(doc)) {
                    valueVal = valueDoubleValues.nextValue();
                }
                if ((samplingDoubleValues = (SortedNumericDoubleValues)orderedValueReferences.getSamplings().orElse(null)) != null && samplingDoubleValues.advanceExact(doc) && Double.isFinite(samplingValue = Double.valueOf(samplingDoubleValues.nextValue())) && samplingValue != 0.0) {
                    valueVal *= samplingValue.doubleValue();
                }
                long startRounded = ProportionalSumAggregator.this.rounding.round(Math.max(rangeStartVal, ProportionalSumAggregator.this.start) - ProportionalSumAggregator.this.offset) + ProportionalSumAggregator.this.offset;
                long lastRounded = ProportionalSumAggregator.this.rounding.round(Math.min(rangeEndVal, ProportionalSumAggregator.this.end) - ProportionalSumAggregator.this.offset) + ProportionalSumAggregator.this.offset;
                long bucketStart = startRounded;
                while (bucketStart <= lastRounded) {
                    double bucketRatio;
                    long nextBucketStart = ProportionalSumAggregator.this.rounding.nextRoundingValue(bucketStart);
                    if (rangeDuration != 0L) {
                        long timeInBucket = ProportionalSumAggregator.getTimeInWindow(bucketStart, nextBucketStart, rangeStartVal, rangeEndVal);
                        bucketRatio = (double)timeInBucket / rangeDuration.doubleValue();
                    } else {
                        bucketRatio = 1.0;
                    }
                    double proportionalValue = valueVal * bucketRatio;
                    long bucketOrd = ProportionalSumAggregator.this.bucketOrds.add(owningBucketOrd, bucketStart);
                    if (bucketOrd < 0L) {
                        bucketOrd = -1L - bucketOrd;
                        ProportionalSumAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
                    } else {
                        ProportionalSumAggregator.this.collectBucket(sub, doc, bucketOrd);
                        ProportionalSumAggregator.this.sums = bigArrays.grow(ProportionalSumAggregator.this.sums, bucketOrd + 1L);
                    }
                    ProportionalSumAggregator.this.sums.increment(bucketOrd, proportionalValue);
                    bucketStart = nextBucketStart;
                }
            }
        };
    }

    public static long getTimeInWindow(long windowStart, long windowEnd, long rangeStart, long rangeEnd) {
        if (rangeStart > windowEnd || rangeEnd < windowStart) {
            return 0L;
        }
        return Math.min(windowEnd, rangeEnd) - Math.max(windowStart, rangeStart);
    }

    protected final <B> InternalAggregation[] buildAggregationsForVariableBuckets(long[] owningBucketOrds, BucketBuilderForVariableWithOwningBucket<B> bucketBuilder, BucketsAggregator.ResultBuilderForVariable<B> resultBuilder) throws IOException {
        long totalOrdsToCollect = 0L;
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            totalOrdsToCollect += this.bucketOrds.bucketsInOrd(owningBucketOrds[ordIdx]);
        }
        if (totalOrdsToCollect > Integer.MAX_VALUE) {
            throw new AggregationExecutionException("Can't collect more than [2147483647] buckets but attempted [" + totalOrdsToCollect + "]");
        }
        long[] bucketOrdsToCollect = new long[(int)totalOrdsToCollect];
        int b = 0;
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            LongKeyedBucketOrds.BucketOrdsEnum ordsEnum = this.bucketOrds.ordsEnum(owningBucketOrds[ordIdx]);
            while (ordsEnum.next()) {
                bucketOrdsToCollect[b++] = ordsEnum.ord();
            }
        }
        InternalAggregations[] subAggregationResults = this.buildSubAggsForBuckets(bucketOrdsToCollect);
        InternalAggregation[] results = new InternalAggregation[owningBucketOrds.length];
        b = 0;
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            ArrayList<B> buckets = new ArrayList<B>((int)this.bucketOrds.size());
            LongKeyedBucketOrds.BucketOrdsEnum ordsEnum = this.bucketOrds.ordsEnum(owningBucketOrds[ordIdx]);
            while (ordsEnum.next()) {
                if (bucketOrdsToCollect[b] != ordsEnum.ord()) {
                    throw new AggregationExecutionException("Iteration order of [" + this.bucketOrds + "] changed without mutating. [" + ordsEnum.ord() + "] should have been [" + bucketOrdsToCollect[b] + "]");
                }
                buckets.add(bucketBuilder.build(owningBucketOrds[ordIdx], ordsEnum.value(), this.bucketDocCount(ordsEnum.ord()), subAggregationResults[b++]));
            }
            results[ordIdx] = resultBuilder.build(owningBucketOrds[ordIdx], buckets);
        }
        return results;
    }

    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForVariableBuckets(owningBucketOrds, (owningBucketOrd, bucketValue, docCount, subAggregationResults) -> {
            long idx = this.bucketOrds.find(owningBucketOrd, bucketValue);
            return new InternalProportionalSumHistogram.Bucket(bucketValue, docCount, this.sums.get(idx), this.keyed, this.formatter, subAggregationResults);
        }, (owningBucketOrd, buckets) -> {
            CollectionUtil.introSort((List)buckets, (Comparator)BucketOrder.key((boolean)true).comparator());
            InternalProportionalSumHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalProportionalSumHistogram.EmptyBucketInfo(this.rounding, this.buildEmptySubAggregations(), this.extendedBounds) : null;
            return new InternalProportionalSumHistogram(this.name, buckets, this.order, this.minDocCount, this.offset, emptyBucketInfo, this.formatter, this.keyed, this.metadata());
        });
    }

    public InternalAggregation buildEmptyAggregation() {
        InternalProportionalSumHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalProportionalSumHistogram.EmptyBucketInfo(this.rounding, this.buildEmptySubAggregations(), this.extendedBounds) : null;
        return new InternalProportionalSumHistogram(this.name, Collections.emptyList(), this.order, this.minDocCount, this.offset, emptyBucketInfo, this.formatter, this.keyed, this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
        Releasables.close((Releasable)this.sums);
    }

    @FunctionalInterface
    protected static interface BucketBuilderForVariableWithOwningBucket<B> {
        public B build(long var1, long var3, long var5, InternalAggregations var7);
    }
}

