/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.elasticsearch.plugin.aggregations.bucket.histogram;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Map;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.rounding.Rounding;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.bucket.histogram.LongBounds;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.opennms.elasticsearch.plugin.aggregations.bucket.histogram.ProportionalSumAggregator;

public class ProportionalSumAggregatorFactory
extends MultiValuesSourceAggregatorFactory {
    private final Map<String, ValuesSourceConfig> configs;
    private final long offset;
    private final BucketOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final LongBounds extendedBounds;
    protected final DocValueFormat format;
    private Rounding rounding;
    private final Long start;
    private final Long end;
    private final String[] fieldNames;

    public ProportionalSumAggregatorFactory(String name, Map<String, ValuesSourceConfig> configs, long offset, BucketOrder order, boolean keyed, long minDocCount, Rounding rounding, Rounding shardRounding, LongBounds extendedBounds, DocValueFormat format, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData, long start, long end, String[] fieldNames) throws IOException {
        super(name, configs, format, context, parent, subFactoriesBuilder, metaData);
        this.configs = configs;
        this.offset = offset;
        this.order = order;
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.extendedBounds = extendedBounds;
        this.format = format;
        this.rounding = rounding;
        this.start = start;
        this.end = end;
        this.fieldNames = fieldNames;
    }

    protected Aggregator doCreateInternal(Map<String, ValuesSourceConfig> configs, DocValueFormat format, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return this.createAggregator(format, parent, cardinality, metadata);
    }

    private Aggregator createAggregator(DocValueFormat format, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metaData) throws IOException {
        long delta;
        long effectiveOffset = this.offset;
        if (this.start != null && effectiveOffset == 0L && (delta = this.start - this.rounding.round(this.start.longValue())) > 0L) {
            effectiveOffset = delta;
        }
        DocValueFormat effectiveFormat = format;
        if (format == null || format == DocValueFormat.RAW) {
            effectiveFormat = new DocValueFormat.DateTime(Joda.getStrictStandardDateFormatter(), ZoneId.of("UTC"), DateFieldMapper.Resolution.MILLISECONDS);
        }
        return new ProportionalSumAggregator(this.name, this.factories, this.rounding, effectiveOffset, this.order, this.keyed, this.minDocCount, this.extendedBounds, this.configs, effectiveFormat, this.context, parent, cardinality, metaData, this.start, this.end, this.fieldNames);
    }

    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metadata) throws IOException {
        return this.createAggregator(null, parent, CardinalityUpperBound.NONE, metadata);
    }
}

