/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.elasticsearch.plugin.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.rounding.Rounding;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.KeyComparable;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramFactory;
import org.elasticsearch.search.aggregations.bucket.histogram.LongBounds;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opennms.elasticsearch.plugin.aggregations.bucket.histogram.HistogramBucketWithValue;

public final class InternalProportionalSumHistogram
extends InternalMultiBucketAggregation<InternalProportionalSumHistogram, Bucket>
implements Histogram,
HistogramFactory {
    private final List<Bucket> buckets;
    private final BucketOrder order;
    private final DocValueFormat format;
    private final boolean keyed;
    private final long minDocCount;
    private final long offset;
    private final EmptyBucketInfo emptyBucketInfo;

    InternalProportionalSumHistogram(String name, List<Bucket> buckets, BucketOrder order, long minDocCount, long offset, EmptyBucketInfo emptyBucketInfo, DocValueFormat formatter, boolean keyed, Map<String, Object> metaData) {
        super(name, metaData);
        this.buckets = buckets;
        this.order = order;
        this.offset = offset;
        assert (minDocCount == 0L == (emptyBucketInfo != null));
        this.minDocCount = minDocCount;
        this.emptyBucketInfo = emptyBucketInfo;
        this.format = formatter;
        this.keyed = keyed;
    }

    public InternalProportionalSumHistogram(StreamInput in) throws IOException {
        super(in);
        this.order = InternalOrder.Streams.readHistogramOrder((StreamInput)in, (boolean)false);
        this.minDocCount = in.readVLong();
        this.emptyBucketInfo = this.minDocCount == 0L ? new EmptyBucketInfo(in) : null;
        this.offset = in.readLong();
        this.format = (DocValueFormat)in.readNamedWriteable(DocValueFormat.class);
        this.keyed = in.readBoolean();
        this.buckets = in.readList(stream -> new Bucket(stream, this.keyed, this.format));
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        InternalOrder.Streams.writeHistogramOrder((BucketOrder)this.order, (StreamOutput)out, (boolean)false);
        out.writeVLong(this.minDocCount);
        if (this.minDocCount == 0L) {
            this.emptyBucketInfo.writeTo(out);
        }
        out.writeLong(this.offset);
        out.writeNamedWriteable((NamedWriteable)this.format);
        out.writeBoolean(this.keyed);
        out.writeList(this.buckets);
    }

    public String getWriteableName() {
        return "proportional_sum";
    }

    public List<Bucket> getBuckets() {
        return Collections.unmodifiableList(this.buckets);
    }

    DocValueFormat getFormatter() {
        return this.format;
    }

    long getMinDocCount() {
        return this.minDocCount;
    }

    long getOffset() {
        return this.offset;
    }

    BucketOrder getOrder() {
        return this.order;
    }

    public InternalProportionalSumHistogram create(List<Bucket> buckets) {
        return new InternalProportionalSumHistogram(this.name, buckets, this.order, this.minDocCount, this.offset, this.emptyBucketInfo, this.format, this.keyed, this.metadata);
    }

    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.key, prototype.docCount, prototype.value, prototype.keyed, prototype.format, aggregations);
    }

    protected Bucket reduceBucket(List<Bucket> buckets, InternalAggregation.ReduceContext context) {
        ArrayList<InternalAggregations> aggregations = new ArrayList<InternalAggregations>(buckets.size());
        long docCount = 0L;
        double value = 0.0;
        for (Bucket bucket : buckets) {
            docCount += bucket.docCount;
            if (!Double.isNaN(bucket.value)) {
                value += bucket.value;
            }
            aggregations.add((InternalAggregations)bucket.getAggregations());
        }
        InternalAggregations aggs = InternalAggregations.reduce(aggregations, (InternalAggregation.ReduceContext)context);
        return new Bucket(buckets.get((int)0).key, docCount, value, this.keyed, this.format, aggs);
    }

    private List<Bucket> reduceBuckets(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        PriorityQueue<IteratorAndCurrent> pq = new PriorityQueue<IteratorAndCurrent>(aggregations.size()){

            protected boolean lessThan(IteratorAndCurrent a, IteratorAndCurrent b) {
                return ((IteratorAndCurrent)a).current.key < ((IteratorAndCurrent)b).current.key;
            }
        };
        for (InternalAggregation aggregation : aggregations) {
            InternalProportionalSumHistogram histogram = (InternalProportionalSumHistogram)aggregation;
            if (histogram.buckets.isEmpty()) continue;
            pq.add((Object)new IteratorAndCurrent(histogram.buckets.iterator()));
        }
        ArrayList<Bucket> reducedBuckets = new ArrayList<Bucket>();
        if (pq.size() > 0) {
            ArrayList<Bucket> currentBuckets = new ArrayList<Bucket>();
            double key = ((IteratorAndCurrent)((IteratorAndCurrent)pq.top())).current.key;
            do {
                IteratorAndCurrent top = (IteratorAndCurrent)pq.top();
                if ((double)((IteratorAndCurrent)top).current.key != key) {
                    Bucket reduced = ((Bucket)currentBuckets.get(0)).reduce(currentBuckets, reduceContext);
                    if (reduced.getDocCount() >= this.minDocCount || !reduceContext.isFinalReduce()) {
                        reduceContext.consumeBucketsAndMaybeBreak(1);
                        reducedBuckets.add(reduced);
                    } else {
                        reduceContext.consumeBucketsAndMaybeBreak(-InternalProportionalSumHistogram.countInnerBucket((InternalMultiBucketAggregation.InternalBucket)reduced));
                    }
                    currentBuckets.clear();
                    key = ((IteratorAndCurrent)top).current.key;
                }
                currentBuckets.add(top.current);
                if (top.iterator.hasNext()) {
                    Bucket next = (Bucket)top.iterator.next();
                    assert (next.key > ((IteratorAndCurrent)top).current.key) : "shards must return data sorted by key";
                    top.current = next;
                    pq.updateTop();
                    continue;
                }
                pq.pop();
            } while (pq.size() > 0);
            if (!currentBuckets.isEmpty()) {
                Bucket reduced = ((Bucket)currentBuckets.get(0)).reduce(currentBuckets, reduceContext);
                if (reduced.getDocCount() >= this.minDocCount || !reduceContext.isFinalReduce()) {
                    reduceContext.consumeBucketsAndMaybeBreak(1);
                    reducedBuckets.add(reduced);
                } else {
                    reduceContext.consumeBucketsAndMaybeBreak(-InternalProportionalSumHistogram.countInnerBucket((InternalMultiBucketAggregation.InternalBucket)reduced));
                }
            }
        }
        return reducedBuckets;
    }

    private void addEmptyBuckets(List<Bucket> list, InternalAggregation.ReduceContext reduceContext) {
        long key;
        Bucket lastBucket = null;
        LongBounds bounds = this.emptyBucketInfo.bounds;
        ListIterator<Bucket> iter = list.listIterator();
        InternalAggregations reducedEmptySubAggs = InternalAggregations.reduce(Collections.singletonList(this.emptyBucketInfo.subAggregations), (InternalAggregation.ReduceContext)reduceContext);
        if (bounds != null) {
            Bucket firstBucket;
            Bucket bucket = firstBucket = iter.hasNext() ? list.get(iter.nextIndex()) : null;
            if (firstBucket == null) {
                if (bounds.getMin() != null && bounds.getMax() != null) {
                    key = bounds.getMin() + this.offset;
                    long max = bounds.getMax() + this.offset;
                    while (key <= max) {
                        reduceContext.consumeBucketsAndMaybeBreak(1);
                        iter.add(new Bucket(key, 0L, 0.0, this.keyed, this.format, reducedEmptySubAggs));
                        key = this.nextKey(key).longValue();
                    }
                }
            } else if (bounds.getMin() != null && (key = bounds.getMin() + this.offset) < firstBucket.key) {
                while (key < firstBucket.key) {
                    reduceContext.consumeBucketsAndMaybeBreak(1);
                    iter.add(new Bucket(key, 0L, 0.0, this.keyed, this.format, reducedEmptySubAggs));
                    key = this.nextKey(key).longValue();
                }
            }
        }
        while (iter.hasNext()) {
            Bucket nextBucket = list.get(iter.nextIndex());
            if (lastBucket != null) {
                key = this.nextKey(lastBucket.key).longValue();
                while (key < nextBucket.key) {
                    reduceContext.consumeBucketsAndMaybeBreak(1);
                    iter.add(new Bucket(key, 0L, 0.0, this.keyed, this.format, reducedEmptySubAggs));
                    key = this.nextKey(key).longValue();
                }
                assert (key == nextBucket.key) : "key: " + key + ", nextBucket.key: " + nextBucket.key;
            }
            lastBucket = iter.next();
        }
        if (bounds != null && lastBucket != null && bounds.getMax() != null && bounds.getMax() + this.offset > lastBucket.key) {
            long key2 = this.nextKey(lastBucket.key).longValue();
            long max = bounds.getMax() + this.offset;
            while (key2 <= max) {
                reduceContext.consumeBucketsAndMaybeBreak(1);
                iter.add(new Bucket(key2, 0L, 0.0, this.keyed, this.format, reducedEmptySubAggs));
                key2 = this.nextKey(key2).longValue();
            }
        }
    }

    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        List<Bucket> reducedBuckets = this.reduceBuckets(aggregations, reduceContext);
        if (this.minDocCount == 0L) {
            this.addEmptyBuckets(reducedBuckets, reduceContext);
        }
        if (!InternalOrder.isKeyAsc((BucketOrder)this.order) && reduceContext.isFinalReduce()) {
            if (InternalOrder.isKeyDesc((BucketOrder)this.order)) {
                ArrayList<Bucket> reverse = new ArrayList<Bucket>(reducedBuckets);
                Collections.reverse(reverse);
                reducedBuckets = reverse;
            } else {
                CollectionUtil.introSort(reducedBuckets, (Comparator)this.order.comparator());
            }
        }
        return new InternalProportionalSumHistogram(this.getName(), reducedBuckets, this.order, this.minDocCount, this.offset, this.emptyBucketInfo, this.format, this.keyed, this.getMetadata());
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject(Aggregation.CommonFields.BUCKETS.getPreferredName());
        } else {
            builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        }
        for (Bucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        if (this.keyed) {
            builder.endObject();
        } else {
            builder.endArray();
        }
        return builder;
    }

    public Number getKey(MultiBucketsAggregation.Bucket bucket) {
        return ((Bucket)bucket).key;
    }

    public Number nextKey(Number key) {
        return this.emptyBucketInfo.rounding.nextRoundingValue(key.longValue() - this.offset) + this.offset;
    }

    public InternalAggregation createAggregation(List<MultiBucketsAggregation.Bucket> buckets) {
        List<Bucket> buckets2 = new ArrayList(buckets.size());
        for (MultiBucketsAggregation.Bucket b : buckets) {
            buckets2.add((Bucket)b);
        }
        buckets2 = Collections.unmodifiableList(buckets2);
        return new InternalProportionalSumHistogram(this.name, buckets2, this.order, this.minDocCount, this.offset, this.emptyBucketInfo, this.format, this.keyed, this.getMetadata());
    }

    public Bucket createBucket(Number key, long docCount, InternalAggregations aggregations) {
        return new Bucket(key.longValue(), docCount, 0.0, this.keyed, this.format, aggregations);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalProportionalSumHistogram that = (InternalProportionalSumHistogram)((Object)obj);
        return Objects.equals(this.buckets, that.buckets) && Objects.equals(this.order, that.order) && Objects.equals(this.format, that.format) && Objects.equals(this.keyed, that.keyed) && Objects.equals(this.minDocCount, that.minDocCount) && Objects.equals(this.offset, that.offset) && Objects.equals(this.emptyBucketInfo, that.emptyBucketInfo);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buckets, this.order, this.format, this.keyed, this.minDocCount, this.offset, this.emptyBucketInfo);
    }

    private static class IteratorAndCurrent {
        private final Iterator<Bucket> iterator;
        private Bucket current;

        IteratorAndCurrent(Iterator<Bucket> iterator) {
            this.iterator = iterator;
            this.current = iterator.next();
        }
    }

    static class EmptyBucketInfo {
        final Rounding rounding;
        final InternalAggregations subAggregations;
        final LongBounds bounds;

        EmptyBucketInfo(Rounding rounding, InternalAggregations subAggregations) {
            this(rounding, subAggregations, null);
        }

        EmptyBucketInfo(Rounding rounding, InternalAggregations subAggregations, LongBounds bounds) {
            this.rounding = rounding;
            this.subAggregations = subAggregations;
            this.bounds = bounds;
        }

        EmptyBucketInfo(StreamInput in) throws IOException {
            this.rounding = Rounding.Streams.read((StreamInput)in);
            this.subAggregations = InternalAggregations.readFrom((StreamInput)in);
            this.bounds = (LongBounds)in.readOptionalWriteable(LongBounds::new);
        }

        void writeTo(StreamOutput out) throws IOException {
            Rounding.Streams.write((Rounding)this.rounding, (StreamOutput)out);
            this.subAggregations.writeTo(out);
            out.writeOptionalWriteable((Writeable)this.bounds);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EmptyBucketInfo that = (EmptyBucketInfo)obj;
            return Objects.equals(this.rounding, that.rounding) && Objects.equals(this.bounds, that.bounds) && Objects.equals(this.subAggregations, that.subAggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.rounding, this.bounds, this.subAggregations);
        }
    }

    public static class Bucket
    extends InternalMultiBucketAggregation.InternalBucket
    implements Histogram.Bucket,
    HistogramBucketWithValue,
    KeyComparable<Bucket> {
        final long key;
        final long docCount;
        final double value;
        final InternalAggregations aggregations;
        private final transient boolean keyed;
        protected final transient DocValueFormat format;

        public Bucket(long key, long docCount, double value, boolean keyed, DocValueFormat format, InternalAggregations aggregations) {
            this.format = format;
            this.value = value;
            this.keyed = keyed;
            this.key = key;
            this.docCount = docCount;
            this.aggregations = aggregations;
        }

        public Bucket(StreamInput in, boolean keyed, DocValueFormat format) throws IOException {
            this.format = format;
            this.keyed = keyed;
            this.key = in.readLong();
            this.docCount = in.readVLong();
            this.value = in.readDouble();
            this.aggregations = InternalAggregations.readFrom((StreamInput)in);
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != Bucket.class) {
                return false;
            }
            Bucket that = (Bucket)obj;
            return this.key == that.key && this.docCount == that.docCount && this.value == that.value && Objects.equals(this.aggregations, that.aggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.key, this.docCount, this.aggregations, this.value);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.key);
            out.writeVLong(this.docCount);
            out.writeDouble(this.value);
            this.aggregations.writeTo(out);
        }

        public String getKeyAsString() {
            return this.format.format(this.key).toString();
        }

        public Object getKey() {
            return new DateTime(this.key, DateTimeZone.UTC);
        }

        public long getDocCount() {
            return this.docCount;
        }

        public Aggregations getAggregations() {
            return this.aggregations;
        }

        Bucket reduce(List<Bucket> buckets, InternalAggregation.ReduceContext context) {
            ArrayList<InternalAggregations> aggregations = new ArrayList<InternalAggregations>(buckets.size());
            long docCount = 0L;
            double value = 0.0;
            for (Bucket bucket : buckets) {
                docCount += bucket.docCount;
                if (!Double.isNaN(bucket.value)) {
                    value += bucket.value;
                }
                aggregations.add((InternalAggregations)bucket.getAggregations());
            }
            InternalAggregations aggs = InternalAggregations.reduce(aggregations, (InternalAggregation.ReduceContext)context);
            return new Bucket(this.key, docCount, value, this.keyed, this.format, aggs);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            String keyAsString = this.format.format(this.key).toString();
            if (this.keyed) {
                builder.startObject(keyAsString);
            } else {
                builder.startObject();
            }
            if (this.format != DocValueFormat.RAW) {
                builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), keyAsString);
            }
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.key);
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
            builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.value);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        public int compareKey(Bucket other) {
            return Long.compare(this.key, other.key);
        }

        public DocValueFormat getFormatter() {
            return this.format;
        }

        public boolean getKeyed() {
            return this.keyed;
        }

        @Override
        public double getValue() {
            return this.value;
        }
    }
}

