/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.elasticsearch.plugin.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Optional;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.opennms.elasticsearch.plugin.aggregations.bucket.histogram.MultiValuesSource;

public class OrderedValueReferences {
    private final SortedNumericDoubleValues[] valuesArray;
    private final SortedNumericDoubleValues rangeStarts;
    private final SortedNumericDoubleValues rangeEnds;
    private final SortedNumericDoubleValues values;
    private final SortedNumericDoubleValues samplings;

    public OrderedValueReferences(LeafReaderContext ctx, MultiValuesSource.NumericMultiValuesSource valuesSources, String[] orderedFieldNames) throws IOException {
        int i;
        int rangeStartIndex = -1;
        int rangeEndIndex = -1;
        int valueIndex = -1;
        int samplingIndex = -1;
        String[] fieldNames = valuesSources.fieldNames();
        if (fieldNames.length < 3 || fieldNames.length > 4) {
            throw new IllegalStateException("Invalid number of fields specified. Need 3 or 4, got " + fieldNames.length);
        }
        if (orderedFieldNames.length != fieldNames.length) {
            throw new IllegalStateException("Ordered list of field names does not have the same number of fields! This shouldn't happen.");
        }
        for (i = 0; i < fieldNames.length; ++i) {
            if (orderedFieldNames[0].equals(fieldNames[i])) {
                rangeStartIndex = i;
                continue;
            }
            if (orderedFieldNames[1].equals(fieldNames[i])) {
                rangeEndIndex = i;
                continue;
            }
            if (orderedFieldNames[2].equals(fieldNames[i])) {
                valueIndex = i;
                continue;
            }
            if (orderedFieldNames.length <= 3 || !orderedFieldNames[3].equals(fieldNames[i])) continue;
            samplingIndex = i;
        }
        this.valuesArray = new SortedNumericDoubleValues[fieldNames.length];
        if (rangeStartIndex >= 0 && rangeEndIndex >= 0 && valueIndex >= 0 && (fieldNames.length == 3 || samplingIndex >= 0)) {
            this.valuesArray[0] = valuesSources.getField(fieldNames[rangeStartIndex], ctx);
            this.valuesArray[1] = valuesSources.getField(fieldNames[rangeEndIndex], ctx);
            this.valuesArray[2] = valuesSources.getField(fieldNames[valueIndex], ctx);
            if (fieldNames.length == 4) {
                this.valuesArray[3] = valuesSources.getField(fieldNames[samplingIndex], ctx);
            }
        } else {
            for (i = 0; i < this.valuesArray.length; ++i) {
                this.valuesArray[i] = valuesSources.getField(fieldNames[i], ctx);
            }
        }
        this.rangeStarts = this.valuesArray[0];
        this.rangeEnds = this.valuesArray[1];
        this.values = this.valuesArray[2];
        this.samplings = this.valuesArray.length > 3 ? this.valuesArray[3] : null;
    }

    public SortedNumericDoubleValues[] getValuesArray() {
        return this.valuesArray;
    }

    public SortedNumericDoubleValues getRangeStarts() {
        return this.rangeStarts;
    }

    public SortedNumericDoubleValues getRangeEnds() {
        return this.rangeEnds;
    }

    public SortedNumericDoubleValues getValues() {
        return this.values;
    }

    public Optional<SortedNumericDoubleValues> getSamplings() {
        return Optional.ofNullable(this.samplings);
    }
}

