/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.model;

import java.util.List;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;

public class NodeListModel {
    private List<NodeModel> m_nodes;
    private int m_interfaceCount;

    public NodeListModel(List<NodeModel> nodes, int interfaceCount) {
        this.m_nodes = nodes;
        this.m_interfaceCount = interfaceCount;
    }

    public List<NodeModel> getNodes() {
        return this.m_nodes;
    }

    public List<NodeModel> getNodesLeft() {
        return this.m_nodes.subList(0, this.getLastInLeftColumn());
    }

    public List<NodeModel> getNodesRight() {
        return this.m_nodes.subList(this.getLastInLeftColumn(), this.m_nodes.size());
    }

    public int getLastInLeftColumn() {
        return (int)Math.ceil((double)this.m_nodes.size() / 2.0);
    }

    public int getNodeCount() {
        return this.m_nodes.size();
    }

    public int getInterfaceCount() {
        return this.m_interfaceCount;
    }

    public static class NodeModel {
        private OnmsNode m_node;
        private List<OnmsIpInterface> m_interfaces;
        private List<OnmsSnmpInterface> m_snmpinterfaces;

        public NodeModel(OnmsNode node, List<OnmsIpInterface> interfaces, List<OnmsSnmpInterface> snmpinterfaces) {
            this.m_node = node;
            this.m_interfaces = interfaces;
            this.m_snmpinterfaces = snmpinterfaces;
        }

        public OnmsNode getNode() {
            return this.m_node;
        }

        public List<OnmsIpInterface> getInterfaces() {
            return this.m_interfaces;
        }

        public List<OnmsSnmpInterface> getSnmpInterfaces() {
            return this.m_snmpinterfaces;
        }
    }
}

