/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import java.util.List;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.SESAME;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.parser.sparql.ast.ASTDatasetClause;
import org.openrdf.query.parser.sparql.ast.ASTIRI;
import org.openrdf.query.parser.sparql.ast.ASTModify;
import org.openrdf.query.parser.sparql.ast.ASTOperation;
import org.openrdf.query.parser.sparql.ast.ASTOperationContainer;

public class DatasetDeclProcessor {
    public static Dataset process(ASTOperationContainer qc) throws MalformedQueryException {
        List<ASTDatasetClause> datasetClauses;
        DatasetImpl dataset = null;
        ASTOperation op = qc.getOperation();
        if (op != null && !(datasetClauses = op.getDatasetClauseList()).isEmpty()) {
            dataset = new DatasetImpl();
            for (ASTDatasetClause dc : datasetClauses) {
                ASTIRI astIri = dc.jjtGetChild(ASTIRI.class);
                try {
                    URI uri = SESAME.NIL;
                    if (astIri != null) {
                        uri = new URIImpl(astIri.getValue());
                    }
                    boolean withClause = false;
                    if (op instanceof ASTModify && dc.equals(((ASTModify)op).getWithClause())) {
                        withClause = true;
                        dataset.setDefaultInsertGraph(uri);
                        dataset.addDefaultRemoveGraph(uri);
                    }
                    if (withClause && datasetClauses.size() != 1) continue;
                    if (dc.isNamed()) {
                        dataset.addNamedGraph(uri);
                        continue;
                    }
                    dataset.addDefaultGraph(uri);
                }
                catch (IllegalArgumentException e) {
                    throw new MalformedQueryException(e.getMessage(), (Throwable)e);
                }
            }
        }
        return dataset;
    }
}

