/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.security;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.util.ChangeStringLiteral;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class UseHttpsForRepositories
extends Recipe {
    private static final MethodMatcher REPO_URL = new MethodMatcher("MavenArtifactRepositorySpec url(..)");

    public String getDisplayName() {
        return "Use HTTPS for repositories";
    }

    public String getDescription() {
        return "Use HTTPS for repository urls";
    }

    public Set<String> getTags() {
        return Collections.singleton("security");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(REPO_URL);
    }

    public GroovyVisitor<ExecutionContext> getVisitor() {
        return new GroovyVisitor<ExecutionContext>(){

            private J.Literal fixupLiteralIfNeeded(J.Literal arg) {
                String url = (String)arg.getValue();
                if (url != null && url.startsWith("http://")) {
                    String newUrl = url.replaceAll("^http://(.*)", "https://$1");
                    return ChangeStringLiteral.withStringValue(arg, newUrl);
                }
                return arg;
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (REPO_URL.matches(method)) {
                    m = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> {
                        if (arg instanceof J.Literal) {
                            return this.fixupLiteralIfNeeded((J.Literal)arg);
                        }
                        if (arg instanceof G.GString) {
                            G.GString garg = (G.GString)arg;
                            return garg.withStrings(ListUtils.mapFirst((List)garg.getStrings(), lit -> lit instanceof J.Literal ? this.fixupLiteralIfNeeded((J.Literal)lit) : lit));
                        }
                        return arg;
                    }));
                }
                return m;
            }
        };
    }
}

