/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.cleanup.NoValueOfOnStringType;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\b\u0010\r\u001a\u00020\u0003H\u0017J\b\u0010\u000e\u001a\u00020\u0003H\u0017J\b\u0010\u000f\u001a\u00020\u0003H\u0017\u00a8\u0006\u0010"}, d2={"Lorg/openrewrite/java/cleanup/NoValueOfOnStringTypeTest;", "Lorg/openrewrite/test/RewriteTest;", "concatenationResultingInNonString", "", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "doNotChangeOnObject", "isMethodInvocationSelect", "valueOfIsMethodInvocationPartOfBinary", "valueOfOnIntWithinBinaryComparison", "valueOfOnLiterals", "valueOfOnMethodInvocation", "valueOfOnNonStringPrimitiveWithinBinaryConcatenation", "valueOfOnNonStringPrimitiveWithinBinaryNotAString", "valueOfOnStandaloneNonStringPrimitive", "rewrite-java-tck"})
public interface NoValueOfOnStringTypeTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void doNotChangeOnObject();

    @Test
    public void isMethodInvocationSelect();

    @Test
    public void valueOfOnLiterals();

    @Test
    public void valueOfOnNonStringPrimitiveWithinBinaryConcatenation();

    @Test
    public void valueOfOnNonStringPrimitiveWithinBinaryNotAString();

    @Test
    public void valueOfIsMethodInvocationPartOfBinary();

    @Test
    public void valueOfOnStandaloneNonStringPrimitive();

    @Test
    public void concatenationResultingInNonString();

    @Test
    public void valueOfOnIntWithinBinaryComparison();

    @Test
    public void valueOfOnMethodInvocation();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull NoValueOfOnStringTypeTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new NoValueOfOnStringType());
            spec.parser((Parser.Builder)JavaParser.fromJavaVersion().logCompilationWarningsAndErrors(true));
        }

        @Test
        public static void doNotChangeOnObject(@NotNull NoValueOfOnStringTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                static String method(Object obj) {\n                    return String.valueOf(obj);\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void isMethodInvocationSelect(@NotNull NoValueOfOnStringTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                String trimPropertyName(String propertyName) {\n                    return String.valueOf(propertyName).trim();\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void valueOfOnLiterals(@NotNull NoValueOfOnStringTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                static void method(char[] data) {\n                    String str = String.valueOf(\"changeMe\");\n                    str = String.valueOf(0);\n                    str = \"changeMe\" + String.valueOf(0);\n                    str = String.valueOf(data);\n                    str = \"changeMe\" + String.valueOf(data);\n                    str = String.valueOf(data, 0, 0);\n                    str = \"doNotChangeMe\" + String.valueOf(data, 0, 0);\n                }\n            }\n        ", (String)"\n            class Test {\n                static void method(char[] data) {\n                    String str = \"changeMe\";\n                    str = String.valueOf(0);\n                    str = \"changeMe\" + 0;\n                    str = String.valueOf(data);\n                    str = \"changeMe\" + String.valueOf(data);\n                    str = String.valueOf(data, 0, 0);\n                    str = \"doNotChangeMe\" + String.valueOf(data, 0, 0);\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void valueOfOnNonStringPrimitiveWithinBinaryConcatenation(@NotNull NoValueOfOnStringTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                static void count(int i) {\n                    System.out.println(\"Count: \" + String.valueOf(i));\n                }\n            }\n        ", (String)"\n            class Test {\n                static void count(int i) {\n                    System.out.println(\"Count: \" + i);\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void valueOfOnNonStringPrimitiveWithinBinaryNotAString(@NotNull NoValueOfOnStringTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                static void count(int i) {\n                    String fred = String.valueOf(i) + i;\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void valueOfIsMethodInvocationPartOfBinary(@NotNull NoValueOfOnStringTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                static String method(Long id) {\n                    return \"example\" + Test.method(String.valueOf(id));\n                }\n\n                static String method(String str) {\n                    return str;\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void valueOfOnStandaloneNonStringPrimitive(@NotNull NoValueOfOnStringTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                static void method(int i) {\n                    String str = String.valueOf(i) + \"example\";\n                }\n            }\n        ", (String)"\n            class Test {\n                static void method(int i) {\n                    String str = i + \"example\";\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void concatenationResultingInNonString(@NotNull NoValueOfOnStringTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                static void method(int i) {\n                    String str = i + String.valueOf(i);\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void valueOfOnIntWithinBinaryComparison(@NotNull NoValueOfOnStringTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                static void method(String str, int i) {\n                    if (str.indexOf(String.valueOf(i)) >= 0) {\n                        // do nothing\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void valueOfOnMethodInvocation(@NotNull NoValueOfOnStringTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                static void method1() {\n                    String a = String.valueOf(method2());\n                }\n\n                static String method2() {\n                    return \"\";\n                }\n            }\n        ", (String)"\n            class Test {\n                static void method1() {\n                    String a = method2();\n                }\n\n                static String method2() {\n                    return \"\";\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }
    }
}

