/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.format;

import java.util.List;
import org.openrewrite.Incubating;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.javascript.JavaScriptIsoVisitor;
import org.openrewrite.javascript.style.SpacesStyle;

@Incubating(since="1.x")
public class SpacesVisitor<P>
extends JavaScriptIsoVisitor<P> {
    private final SpacesStyle style;

    public SpacesVisitor(SpacesStyle style) {
        this.style = style;
    }

    <T extends J> T spaceBefore(T j, boolean spaceBefore) {
        if (!j.getComments().isEmpty()) {
            return j;
        }
        if (spaceBefore && SpacesVisitor.notSingleSpace(j.getPrefix().getWhitespace())) {
            return (T)j.withPrefix(j.getPrefix().withWhitespace(" "));
        }
        if (!spaceBefore && SpacesVisitor.onlySpacesAndNotEmpty(j.getPrefix().getWhitespace())) {
            return (T)j.withPrefix(j.getPrefix().withWhitespace(""));
        }
        return j;
    }

    <T> JContainer<T> spaceBefore(JContainer<T> container, boolean spaceBefore) {
        if (!container.getBefore().getComments().isEmpty()) {
            List<Comment> comments = SpacesVisitor.spaceLastCommentSuffix(container.getBefore().getComments(), spaceBefore);
            return container.withBefore(container.getBefore().withComments(comments));
        }
        if (spaceBefore && SpacesVisitor.notSingleSpace(container.getBefore().getWhitespace())) {
            return container.withBefore(container.getBefore().withWhitespace(" "));
        }
        if (!spaceBefore && SpacesVisitor.onlySpacesAndNotEmpty(container.getBefore().getWhitespace())) {
            return container.withBefore(container.getBefore().withWhitespace(""));
        }
        return container;
    }

    <T extends J> JLeftPadded<T> spaceBefore(JLeftPadded<T> container, boolean spaceBefore) {
        if (!container.getBefore().getComments().isEmpty()) {
            return container;
        }
        if (spaceBefore && SpacesVisitor.notSingleSpace(container.getBefore().getWhitespace())) {
            return container.withBefore(container.getBefore().withWhitespace(" "));
        }
        if (!spaceBefore && SpacesVisitor.onlySpacesAndNotEmpty(container.getBefore().getWhitespace())) {
            return container.withBefore(container.getBefore().withWhitespace(""));
        }
        return container;
    }

    <T extends J> JLeftPadded<T> spaceBeforeLeftPaddedElement(JLeftPadded<T> container, boolean spaceBefore) {
        return container.withElement((Object)this.spaceBefore((J)container.getElement(), spaceBefore));
    }

    <T extends J> JRightPadded<T> spaceBeforeRightPaddedElement(JRightPadded<T> container, boolean spaceBefore) {
        return container.withElement((Object)this.spaceBefore((J)container.getElement(), spaceBefore));
    }

    <T extends J> JRightPadded<T> spaceAfter(JRightPadded<T> container, boolean spaceAfter) {
        if (!container.getAfter().getComments().isEmpty()) {
            List<Comment> comments = SpacesVisitor.spaceLastCommentSuffix(container.getAfter().getComments(), spaceAfter);
            return container.withAfter(container.getAfter().withComments(comments));
        }
        if (spaceAfter && SpacesVisitor.notSingleSpace(container.getAfter().getWhitespace())) {
            return container.withAfter(container.getAfter().withWhitespace(" "));
        }
        if (!spaceAfter && SpacesVisitor.onlySpacesAndNotEmpty(container.getAfter().getWhitespace())) {
            return container.withAfter(container.getAfter().withWhitespace(""));
        }
        return container;
    }

    private static List<Comment> spaceLastCommentSuffix(List<Comment> comments, boolean spaceSuffix) {
        return ListUtils.mapLast(comments, comment -> SpacesVisitor.spaceSuffix(comment, spaceSuffix));
    }

    private static Comment spaceSuffix(Comment comment, boolean spaceSuffix) {
        if (spaceSuffix && SpacesVisitor.notSingleSpace(comment.getSuffix())) {
            return comment.withSuffix(" ");
        }
        if (!spaceSuffix && SpacesVisitor.onlySpacesAndNotEmpty(comment.getSuffix())) {
            return comment.withSuffix("");
        }
        return comment;
    }

    private static boolean onlySpaces(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return true;
    }

    private static boolean onlySpacesAndNotEmpty(String s) {
        return !StringUtils.isNullOrEmpty((String)s) && SpacesVisitor.onlySpaces(s);
    }

    private static boolean notSingleSpace(String str) {
        return SpacesVisitor.onlySpaces(str) && !" ".equals(str);
    }

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        J.MethodDeclaration m = super.visitMethodDeclaration(method, p);
        if (m.getReturnTypeExpression() != null) {
            boolean useSpaceAfter = this.style.getOther().getAfterTypeReferenceColon();
            m = m.withReturnTypeExpression(this.spaceBefore(m.getReturnTypeExpression(), useSpaceAfter));
        }
        if ((m = m.getPadding().withParameters(this.spaceBefore(m.getPadding().getParameters(), (boolean)this.style.getBeforeParentheses().getFunctionDeclarationParentheses()))).getBody() != null) {
            m = m.withBody(this.spaceBefore(m.getBody(), (boolean)this.style.getBeforeLeftBrace().getFunctionLeftBrace()));
        }
        if (!m.getParameters().isEmpty() && !(m.getParameters().iterator().next() instanceof J.Empty)) {
            int paramsSize = m.getParameters().size();
            boolean useSpace = this.style.getWithin().getFunctionDeclarationParentheses();
            m = m.getPadding().withParameters(m.getPadding().getParameters().getPadding().withElements(ListUtils.map((List)m.getPadding().getParameters().getPadding().getElements(), (index, param) -> {
                param = index == 0 ? param.withElement((Object)this.spaceBefore((Statement)param.getElement(), useSpace)) : param.withElement((Object)this.spaceBefore((Statement)param.getElement(), (boolean)this.style.getOther().getAfterComma()));
                param = index == paramsSize - 1 ? this.spaceAfter((JRightPadded)param, useSpace) : this.spaceAfter((JRightPadded)param, this.style.getOther().getBeforeComma());
                return param;
            })));
        }
        return m;
    }

    @Override
    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, P p) {
        J.MethodInvocation m = super.visitMethodInvocation(method, p);
        if (!(m = m.getPadding().withArguments(this.spaceBefore(m.getPadding().getArguments(), (boolean)this.style.getBeforeParentheses().getFunctionCallParentheses()))).getArguments().isEmpty() && !(m.getArguments().iterator().next() instanceof J.Empty)) {
            int argsSize = m.getArguments().size();
            boolean useSpace = this.style.getWithin().getFunctionCallParentheses();
            m = m.getPadding().withArguments(m.getPadding().getArguments().getPadding().withElements(ListUtils.map((List)m.getPadding().getArguments().getPadding().getElements(), (index, arg) -> {
                arg = index == 0 ? arg.withElement((Object)this.spaceBefore((Expression)arg.getElement(), useSpace)) : arg.withElement((Object)this.spaceBefore((Expression)arg.getElement(), (boolean)this.style.getOther().getAfterComma()));
                arg = index == argsSize - 1 ? this.spaceAfter((JRightPadded)arg, useSpace) : this.spaceAfter((JRightPadded)arg, this.style.getOther().getBeforeComma());
                return arg;
            })));
        }
        return m;
    }

    @Override
    public J.NewClass visitNewClass(J.NewClass newClass, P p) {
        J.NewClass nc = super.visitNewClass(newClass, p);
        if (nc.getPadding().getArguments() != null) {
            nc = nc.getPadding().withArguments(this.spaceBefore(nc.getPadding().getArguments(), (boolean)this.style.getBeforeParentheses().getFunctionCallParentheses()));
            int argsSize = nc.getPadding().getArguments().getElements().size();
            nc = nc.getPadding().withArguments(nc.getPadding().getArguments().getPadding().withElements(ListUtils.map((List)nc.getPadding().getArguments().getPadding().getElements(), (index, elemContainer) -> {
                if (index != 0) {
                    elemContainer = elemContainer.withElement((Object)this.spaceBefore((Expression)elemContainer.getElement(), (boolean)this.style.getOther().getAfterComma()));
                }
                if (index != argsSize - 1) {
                    elemContainer = this.spaceAfter((JRightPadded)elemContainer, this.style.getOther().getBeforeComma());
                }
                return elemContainer;
            })));
        }
        return nc;
    }

    @Override
    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
        J.VariableDeclarations m = super.visitVariableDeclarations(multiVariable, p);
        if (m.getTypeExpression() != null) {
            boolean useSpaceAfter = this.style.getOther().getAfterPropertyNameValueSeparator();
            m = m.withTypeExpression(this.spaceBefore(m.getTypeExpression(), useSpaceAfter));
        }
        return m;
    }
}

