/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.format;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.javascript.JavaScriptIsoVisitor;
import org.openrewrite.javascript.format.JavaScriptSpacesVisitor;
import org.openrewrite.javascript.style.IntelliJ;
import org.openrewrite.javascript.style.SpacesStyle;
import org.openrewrite.javascript.tree.JS;

@Incubating(since="1.x")
public class JavaScriptSpaces
extends Recipe {
    public String getDisplayName() {
        return "JavaScript and TypeScript Spaces";
    }

    public String getDescription() {
        return "Format whitespace in Java/Type Script code.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new SpacesFromCompilationUnitStyle();
    }

    private static class SpacesFromCompilationUnitStyle
    extends JavaScriptIsoVisitor<ExecutionContext> {
        private SpacesFromCompilationUnitStyle() {
        }

        public J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof JS.CompilationUnit) {
                JS.CompilationUnit cu = (JS.CompilationUnit)Objects.requireNonNull(tree);
                SpacesStyle style = (SpacesStyle)cu.getStyle(SpacesStyle.class);
                if (style == null) {
                    style = IntelliJ.TypeScript.spaces();
                }
                this.doAfterVisit((TreeVisitor)new JavaScriptSpacesVisitor(style));
            }
            return (J)super.visit(tree, (Object)ctx);
        }
    }
}

