/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Comparator;
import java.util.Optional;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.maven.MavenRefactorVisitor;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.xml.AddToTag;
import org.openrewrite.xml.ChangeTagValue;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public class AddPlugin
extends MavenRefactorVisitor {
    private static final XPathMatcher BUILD_MATCHER = new XPathMatcher("/project/build");
    private String groupId;
    private String artifactId;
    private String version;

    public AddPlugin() {
        this.setCursoringOn();
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public Maven visitMaven(Maven maven) {
        Xml.Tag root = maven.getRoot();
        if (!root.getChild("build").isPresent()) {
            this.andThen((RefactorVisitor)new AddToTag.Scoped(root, Xml.Tag.build((String)"<build/>"), (Comparator)new MavenTagInsertionComparator(root.getChildren())));
        }
        return super.visitMaven(maven);
    }

    public Xml visitTag(Xml.Tag tag) {
        if (BUILD_MATCHER.matches(this.getCursor())) {
            Optional maybePlugins = tag.getChild("plugins");
            if (!maybePlugins.isPresent()) {
                this.andThen((RefactorVisitor)new AddToTag.Scoped(tag, Xml.Tag.build((String)"<plugins/>")));
            } else {
                Xml.Tag plugins = (Xml.Tag)maybePlugins.get();
                Optional<Xml.Tag> maybePlugin = plugins.getChildren().stream().filter(plugin -> plugin.getName().equals("plugin") && this.groupId.equals(plugin.getChildValue("groupId").orElse(null)) && this.artifactId.equals(plugin.getChildValue("artifactId").orElse(null))).findAny();
                if (maybePlugin.isPresent()) {
                    Xml.Tag plugin2 = maybePlugin.get();
                    if (!this.version.equals(plugin2.getChildValue("version").orElse(null))) {
                        this.andThen((RefactorVisitor)new ChangeTagValue.Scoped((Xml.Tag)plugin2.getChild("version").get(), this.version));
                    }
                } else {
                    this.andThen((RefactorVisitor)new AddToTag.Scoped(plugins, Xml.Tag.build((String)("<plugin>\n<groupId>" + this.groupId + "</groupId>\n<artifactId>" + this.artifactId + "</artifactId>\n<version>" + this.version + "</version>\n</plugin>"))));
                }
            }
            return tag;
        }
        return super.visitTag(tag);
    }
}

