/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.maven.MavenRefactorVisitor;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.xml.RemoveContent;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public class RemoveDependency
extends MavenRefactorVisitor {
    private String groupId;
    private String artifactId;

    public RemoveDependency() {
        this.setCursoringOn();
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public Xml visitTag(Xml.Tag tag) {
        if (this.isDependencyTag(this.groupId, this.artifactId)) {
            this.andThen((RefactorVisitor)new RemoveContent.Scoped((Content)tag, true));
        }
        return super.visitTag(tag);
    }

    @Override
    public Maven visitMaven(Maven maven) {
        this.model = maven.getModel();
        if (this.findDependencies(this.groupId, this.artifactId).size() == 0) {
            return maven;
        }
        Maven m = super.visitMaven(maven);
        List<Pom.Dependency> dependencies = this.model.getDependencies().stream().filter(dep -> !dep.getArtifactId().equals(this.artifactId) || !dep.getGroupId().equals(this.groupId)).collect(Collectors.toList());
        return m.withModel(this.model.withDependencies(dependencies));
    }
}

