/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;

public class JacksonMapdbSerializer<T>
implements Serializer<T> {
    private static final ObjectMapper mapper;
    private final Class<T> tClass;

    public JacksonMapdbSerializer(Class<T> tClass) {
        this.tClass = tClass;
    }

    public void serialize(@NotNull DataOutput2 out, @NotNull T value) throws IOException {
        byte[] bytes = mapper.writeValueAsBytes(value);
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    public T deserialize(@NotNull DataInput2 input, int available) throws IOException {
        byte[] bytes = new byte[input.readInt()];
        input.readFully(bytes);
        return (T)mapper.readValue(bytes, this.tClass);
    }

    static {
        SmileFactory f = new SmileFactory();
        f.configure(SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES, true);
        ObjectMapper m = new ObjectMapper((JsonFactory)f).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper = m.setVisibility(m.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
    }
}

