/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.tree.DependencyDescriptor;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.Scope;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@c")
@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public interface DependencyManagementDependency {
    public List<DependencyDescriptor> getDependencies();

    public Map<String, String> getProperties();

    public String getGroupId();

    public String getArtifactId();

    public String getVersion();

    public <D extends DependencyManagementDependency> D withVersion(String var1);

    public String getRequestedVersion();

    public static class Imported
    implements DependencyManagementDependency {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String requestedVersion;
        private final Pom maven;

        @Override
        public List<DependencyDescriptor> getDependencies() {
            return this.maven.getEffectiveDependencyManagement().getDependencies().stream().flatMap(dep -> dep.getDependencies().stream()).collect(Collectors.toList());
        }

        @Override
        public Map<String, String> getProperties() {
            return this.maven.getProperties();
        }

        public Imported(String groupId, String artifactId, String version, String requestedVersion, Pom maven) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.requestedVersion = requestedVersion;
            this.maven = maven;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public String getArtifactId() {
            return this.artifactId;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getRequestedVersion() {
            return this.requestedVersion;
        }

        public Pom getMaven() {
            return this.maven;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Imported)) {
                return false;
            }
            Imported other = (Imported)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$requestedVersion = this.getRequestedVersion();
            String other$requestedVersion = other.getRequestedVersion();
            if (this$requestedVersion == null ? other$requestedVersion != null : !this$requestedVersion.equals(other$requestedVersion)) {
                return false;
            }
            Pom this$maven = this.getMaven();
            Pom other$maven = other.getMaven();
            return !(this$maven == null ? other$maven != null : !((Object)this$maven).equals(other$maven));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Imported;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $requestedVersion = this.getRequestedVersion();
            result = result * 59 + ($requestedVersion == null ? 43 : $requestedVersion.hashCode());
            Pom $maven = this.getMaven();
            result = result * 59 + ($maven == null ? 43 : ((Object)$maven).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "DependencyManagementDependency.Imported(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", requestedVersion=" + this.getRequestedVersion() + ", maven=" + this.getMaven() + ")";
        }

        @NonNull
        public Imported withVersion(String version) {
            return this.version == version ? this : new Imported(this.groupId, this.artifactId, version, this.requestedVersion, this.maven);
        }
    }

    public static class Defined
    implements DependencyManagementDependency,
    DependencyDescriptor {
        private final String groupId;
        private final String artifactId;
        @Nullable
        private final String version;
        private final String requestedVersion;
        @Nullable
        private final Scope scope;
        @Nullable
        private final String classifier;
        private final Set<GroupArtifact> exclusions;

        @Override
        public List<DependencyDescriptor> getDependencies() {
            return Collections.singletonList(this);
        }

        @Override
        public Map<String, String> getProperties() {
            return Collections.emptyMap();
        }

        public Defined(String groupId, String artifactId, @Nullable String version, String requestedVersion, @Nullable Scope scope, @Nullable String classifier, Set<GroupArtifact> exclusions) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.requestedVersion = requestedVersion;
            this.scope = scope;
            this.classifier = classifier;
            this.exclusions = exclusions;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public String getArtifactId() {
            return this.artifactId;
        }

        @Override
        @Nullable
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getRequestedVersion() {
            return this.requestedVersion;
        }

        @Override
        @Nullable
        public Scope getScope() {
            return this.scope;
        }

        @Override
        @Nullable
        public String getClassifier() {
            return this.classifier;
        }

        @Override
        public Set<GroupArtifact> getExclusions() {
            return this.exclusions;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Defined)) {
                return false;
            }
            Defined other = (Defined)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$requestedVersion = this.getRequestedVersion();
            String other$requestedVersion = other.getRequestedVersion();
            if (this$requestedVersion == null ? other$requestedVersion != null : !this$requestedVersion.equals(other$requestedVersion)) {
                return false;
            }
            Scope this$scope = this.getScope();
            Scope other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope)) {
                return false;
            }
            String this$classifier = this.getClassifier();
            String other$classifier = other.getClassifier();
            if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
                return false;
            }
            Set<GroupArtifact> this$exclusions = this.getExclusions();
            Set<GroupArtifact> other$exclusions = other.getExclusions();
            return !(this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Defined;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $requestedVersion = this.getRequestedVersion();
            result = result * 59 + ($requestedVersion == null ? 43 : $requestedVersion.hashCode());
            Scope $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : ((Object)((Object)$scope)).hashCode());
            String $classifier = this.getClassifier();
            result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
            Set<GroupArtifact> $exclusions = this.getExclusions();
            result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "DependencyManagementDependency.Defined(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", requestedVersion=" + this.getRequestedVersion() + ", scope=" + (Object)((Object)this.getScope()) + ", classifier=" + this.getClassifier() + ", exclusions=" + this.getExclusions() + ")";
        }

        @NonNull
        public Defined withVersion(@Nullable String version) {
            return this.version == version ? this : new Defined(this.groupId, this.artifactId, version, this.requestedVersion, this.scope, this.classifier, this.exclusions);
        }
    }
}

