/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.tree.MavenRepository;

public class MavenRepositoryMirror {
    private final String id;
    private final String url;
    private final String mirrorOf;

    public static MavenRepository apply(Collection<MavenRepositoryMirror> mirrors, MavenRepository repo) {
        MavenRepository mapped = repo;
        MavenRepository next = null;
        while (next != mapped) {
            next = mapped;
            for (MavenRepositoryMirror mirror : mirrors) {
                mapped = mirror.apply(mapped);
            }
        }
        return mapped;
    }

    public MavenRepository apply(MavenRepository repo) {
        URI uri = URI.create(this.url);
        if (!(!this.matches(repo) || repo.getUri().equals(uri) && repo.getId().equals(this.id))) {
            return repo.withUri(uri).withId(this.id);
        }
        return repo;
    }

    public boolean matches(MavenRepository repository) {
        if (this.mirrorOf == null) {
            return false;
        }
        if (this.mirrorOf.equals("*")) {
            return true;
        }
        int colonIndex = this.mirrorOf.indexOf(58);
        String mirrorOfWithoutExternal = this.mirrorOf;
        boolean externalOnly = false;
        if (colonIndex != -1) {
            externalOnly = true;
            mirrorOfWithoutExternal = this.mirrorOf.substring(colonIndex + 1);
        }
        List mirrorsOf = Arrays.stream(mirrorOfWithoutExternal.split(",")).collect(Collectors.toList());
        HashSet<String> excludedRepos = new HashSet<String>();
        HashSet<String> includedRepos = new HashSet<String>();
        for (String mirror : mirrorsOf) {
            if (mirror.startsWith("!")) {
                excludedRepos.add(mirror.substring(1));
                continue;
            }
            includedRepos.add(mirror);
        }
        if (externalOnly && this.isInternal(repository)) {
            return false;
        }
        if (excludedRepos.stream().anyMatch(it -> it.equals("*"))) {
            return includedRepos.contains(repository.getId());
        }
        if (includedRepos.stream().anyMatch(it -> it.equals("*"))) {
            return !excludedRepos.contains(repository.getId());
        }
        return !excludedRepos.contains(repository.getId()) && includedRepos.contains(repository.getId());
    }

    private boolean isInternal(MavenRepository repo) {
        if (repo.getUri().getScheme().startsWith("file")) {
            return true;
        }
        return repo.getUri().getHost().equals("localhost") || repo.getUri().getHost().equals("127.0.0.1");
    }

    public MavenRepositoryMirror(String id, String url, String mirrorOf) {
        this.id = id;
        this.url = url;
        this.mirrorOf = mirrorOf;
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMirrorOf() {
        return this.mirrorOf;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenRepositoryMirror)) {
            return false;
        }
        MavenRepositoryMirror other = (MavenRepositoryMirror)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$mirrorOf = this.getMirrorOf();
        String other$mirrorOf = other.getMirrorOf();
        return !(this$mirrorOf == null ? other$mirrorOf != null : !this$mirrorOf.equals(other$mirrorOf));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MavenRepositoryMirror;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $mirrorOf = this.getMirrorOf();
        result = result * 59 + ($mirrorOf == null ? 43 : $mirrorOf.hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "MavenRepositoryMirror(id=" + this.getId() + ", url=" + this.getUrl() + ", mirrorOf=" + this.getMirrorOf() + ")";
    }
}

