/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import io.vavr.CheckedFunction1;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HttpSenderExecutionContextView;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.MavenClientSideException;
import org.openrewrite.maven.internal.MavenDownloadingException;
import org.openrewrite.maven.internal.RawPom;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenRepositoryCredentials;
import org.openrewrite.maven.tree.MavenRepositoryMirror;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedPom;

public class MavenPomDownloader {
    private static final RetryConfig retryConfig = RetryConfig.custom().retryOnException(throwable -> throwable instanceof SocketTimeoutException || throwable instanceof TimeoutException).build();
    private static final RetryRegistry retryRegistry = RetryRegistry.of((RetryConfig)retryConfig);
    private static final Retry mavenDownloaderRetry = retryRegistry.retry("MavenDownloader");
    private final MavenPomCache mavenCache;
    private final Map<Path, Pom> projectPoms;
    private final MavenExecutionContextView ctx;
    private final HttpSender httpSender;
    private final CheckedFunction1<HttpSender.Request, byte[]> sendRequest;

    public MavenPomDownloader(Map<Path, Pom> projectPoms, ExecutionContext ctx) {
        this(projectPoms, HttpSenderExecutionContextView.view((ExecutionContext)ctx).getHttpSender(), ctx);
    }

    @Deprecated
    public MavenPomDownloader(Map<Path, Pom> projectPoms, HttpSender httpSender, ExecutionContext ctx) {
        this.projectPoms = projectPoms;
        this.httpSender = httpSender;
        this.sendRequest = Retry.decorateCheckedFunction((Retry)mavenDownloaderRetry, (CheckedFunction1 & Serializable)request -> {
            try (HttpSender.Response response = httpSender.send(request);){
                if (response.isSuccessful()) {
                    byte[] byArray = response.getBodyAsBytes();
                    return byArray;
                }
                if (response.getCode() >= 400 && response.getCode() <= 404) {
                    throw new MavenClientSideException("Failed to download " + request.getUrl(), response.getCode());
                }
                throw new MavenDownloadingException("Failed to download " + request.getUrl() + ": " + response.getCode());
            }
        });
        this.ctx = MavenExecutionContextView.view(ctx);
        this.mavenCache = this.ctx.getPomCache();
    }

    public MavenMetadata downloadMetadata(GroupArtifact groupArtifact, @Nullable ResolvedPom containingPom, List<MavenRepository> repositories) {
        return this.downloadMetadata(new GroupArtifactVersion(groupArtifact.getGroupId(), groupArtifact.getArtifactId(), null), containingPom, repositories);
    }

    public MavenMetadata downloadMetadata(GroupArtifactVersion gav, @Nullable ResolvedPom containingPom, List<MavenRepository> repositories) {
        if (gav.getGroupId() == null) {
            throw new MavenDownloadingException("Unable to download maven metadata because of a missing groupId.");
        }
        Timer.Sample sample = Timer.start();
        Timer.Builder timer = Timer.builder((String)"rewrite.maven.download").tag("group.id", gav.getGroupId()).tag("artifact.id", gav.getArtifactId()).tag("type", "metadata");
        MavenMetadata mavenMetadata = null;
        Collection<MavenRepository> normalizedRepos = this.distinctNormalizedRepositories(repositories, containingPom, null);
        ArrayList<MavenDownloadingException> webRequestFailures = null;
        for (MavenRepository repo : normalizedRepos) {
            Optional<MavenMetadata> result;
            boolean repoFailure;
            block21: {
                String version = gav.getVersion();
                if (version != null && (version.endsWith("-SNAPSHOT") && !repo.isSnapshots() || "RELEASE".equals(version) && !repo.isReleases())) continue;
                repoFailure = false;
                result = null;
                try {
                    result = this.mavenCache.getMavenMetadata(URI.create(repo.getUri()), gav);
                    if (result == null) {
                        String scheme = URI.create(repo.getUri()).getScheme();
                        String uri = repo.getUri() + (repo.getUri().endsWith("/") ? "" : "/") + gav.getGroupId().replace('.', '/') + '/' + gav.getArtifactId() + '/' + (gav.getVersion() == null ? "" : gav.getVersion() + '/') + "maven-metadata.xml";
                        if ("file".equals(scheme)) {
                            Path path = Paths.get(URI.create(uri));
                            if (Files.exists(path, new LinkOption[0])) {
                                result = Optional.of(MavenMetadata.parse(Files.readAllBytes(path)));
                            }
                        } else {
                            byte[] responseBody = this.requestAsAuthenticatedOrAnonymous(repo, uri);
                            result = Optional.of(MavenMetadata.parse(responseBody));
                        }
                    }
                }
                catch (Throwable exception) {
                    if (exception instanceof MavenClientSideException) break block21;
                    if (webRequestFailures == null) {
                        webRequestFailures = new ArrayList<MavenDownloadingException>();
                    }
                    repoFailure = true;
                    webRequestFailures.add(new MavenDownloadingException("Unable to retrieve metadata from [" + repo.getUri() + "]. " + exception.getMessage()));
                }
            }
            if (!(result != null && result.isPresent() || gav.getVersion() != null)) {
                try {
                    result = this.deriveMetadata(gav, repo);
                    if (result.isPresent()) {
                        repo.setDeriveMetadataIfMissing(true);
                        Counter.builder((String)"rewrite.maven.derived.metatdata").tag("repositoryUri", repo.getUri()).tag("group", gav.getGroupId()).tag("artifact", gav.getArtifactId()).register((MeterRegistry)Metrics.globalRegistry);
                    }
                }
                catch (MavenClientSideException exception) {
                    if (exception.getResponseCode() != null && exception.getResponseCode() != 404) {
                        repo.setDeriveMetadataIfMissing(false);
                    }
                }
                catch (Throwable exception) {
                    if (webRequestFailures == null) {
                        webRequestFailures = new ArrayList();
                    }
                    repoFailure = true;
                    webRequestFailures.add(new MavenDownloadingException("Unable to retrieve metadata from [" + repo.getUri() + "]. " + exception.getMessage()));
                }
            }
            if (result != null && result.isPresent()) {
                mavenMetadata = mavenMetadata == null ? result.get() : this.mergeMetadata(mavenMetadata, result.get());
                this.mavenCache.putMavenMetadata(URI.create(repo.getUri()), gav, result.get());
                continue;
            }
            if (repoFailure) continue;
            this.mavenCache.putMavenMetadata(URI.create(repo.getUri()), gav, null);
        }
        if (mavenMetadata == null) {
            sample.stop(timer.tags(new String[]{"outcome", "unavailable"}).register((MeterRegistry)Metrics.globalRegistry));
            StringBuilder message = new StringBuilder("Unable to Download metadata for [").append(gav).append("] from the following repositories :");
            for (MavenRepository repository : normalizedRepos) {
                message.append("\n  ").append(repository.getUri());
            }
            if (webRequestFailures != null) {
                message.append("\nMetadata download failures:");
                for (MavenDownloadingException e : webRequestFailures) {
                    message.append("\n  ").append(e.getMessage());
                }
            }
            throw new MavenDownloadingException(message.toString());
        }
        sample.stop(timer.tags(new String[]{"outcome", "success"}).register((MeterRegistry)Metrics.globalRegistry));
        return mavenMetadata;
    }

    private Optional<MavenMetadata> deriveMetadata(GroupArtifactVersion gav, MavenRepository repo) throws Throwable {
        if (repo.getDeriveMetadataIfMissing() != null && !repo.getDeriveMetadataIfMissing().booleanValue() || gav.getVersion() != null) {
            return Optional.empty();
        }
        String scheme = URI.create(repo.getUri()).getScheme();
        String uri = repo.getUri() + (repo.getUri().endsWith("/") ? "" : "/") + gav.getGroupId().replace('.', '/') + '/' + gav.getArtifactId();
        MavenMetadata.Versioning versioning = null;
        if (!"file".equals(scheme)) {
            String responseBody = new String(this.requestAsAuthenticatedOrAnonymous(repo, uri));
            versioning = this.htmlIndexToVersioning(responseBody, uri);
        }
        if (versioning == null) {
            return Optional.empty();
        }
        return Optional.of(new MavenMetadata(versioning));
    }

    @Nullable
    private MavenMetadata.Versioning htmlIndexToVersioning(String responseBody, String uri) {
        int end;
        ArrayList<String> versions = new ArrayList<String>();
        int start = responseBody.indexOf("<a href=\"");
        while (start > 0 && (end = responseBody.indexOf("\">", start += 9)) >= 0) {
            String href = responseBody.substring(start, end).trim();
            if (href.endsWith("/")) {
                versions.add(this.hrefToVersion(href, uri));
            }
            start = responseBody.indexOf("<a href=\"", end);
        }
        if (versions.isEmpty()) {
            return null;
        }
        return new MavenMetadata.Versioning(versions, null, null);
    }

    String hrefToVersion(String href, String rootUri) {
        String version = href.startsWith(rootUri) ? href.substring(rootUri.length()) : href;
        if (version.endsWith("/")) {
            return version.substring(0, version.length() - 1);
        }
        return version;
    }

    @NonNull
    private MavenMetadata mergeMetadata(MavenMetadata m1, MavenMetadata m2) {
        return new MavenMetadata(new MavenMetadata.Versioning(Stream.concat(m1.getVersioning().getVersions().stream(), m2.getVersioning().getVersions().stream()).collect(Collectors.toList()), Stream.concat(m1.getVersioning().getSnapshotVersions() == null ? Stream.empty() : m1.getVersioning().getSnapshotVersions().stream(), m2.getVersioning().getSnapshotVersions() == null ? Stream.empty() : m2.getVersioning().getSnapshotVersions().stream()).collect(Collectors.toList()), null));
    }

    public Pom download(GroupArtifactVersion gav, @Nullable String relativePath, @Nullable ResolvedPom containingPom, List<MavenRepository> repositories) throws MavenDownloadingException {
        Pom maybeLocalPom;
        Path folderContainingPom;
        if (gav.getGroupId() == null || gav.getArtifactId() == null || gav.getVersion() == null) {
            String errorText = "Unable to download dependency " + gav;
            if (containingPom != null) {
                this.ctx.getResolutionListener().downloadError(gav, containingPom.getRequested());
            }
            throw new MavenDownloadingException(errorText);
        }
        for (Pom projectPom : this.projectPoms.values()) {
            if (!gav.getGroupId().equals(projectPom.getGroupId()) || !gav.getArtifactId().equals(projectPom.getArtifactId()) || !Objects.equals(projectPom.getValue(projectPom.getVersion()), projectPom.getValue(gav.getVersion()))) continue;
            return projectPom;
        }
        if (containingPom != null && containingPom.getRequested().getSourcePath() != null && !StringUtils.isBlank((String)relativePath) && (folderContainingPom = containingPom.getRequested().getSourcePath().getParent()) != null && (maybeLocalPom = this.projectPoms.get(folderContainingPom.resolve(Paths.get(relativePath, "pom.xml")).normalize())) != null && gav.getGroupId().equals(maybeLocalPom.getGroupId()) && gav.getArtifactId().equals(maybeLocalPom.getArtifactId()) && gav.getVersion().equals(maybeLocalPom.getVersion())) {
            return maybeLocalPom;
        }
        Collection<MavenRepository> normalizedRepos = this.distinctNormalizedRepositories(repositories, containingPom, gav.getVersion());
        Timer.Sample sample = Timer.start();
        Timer.Builder timer = Timer.builder((String)"rewrite.maven.download").tag("group.id", gav.getGroupId()).tag("artifact.id", gav.getArtifactId()).tag("type", "pom");
        String versionMaybeDatedSnapshot = this.datedSnapshotVersion(gav, containingPom, repositories, (ExecutionContext)this.ctx);
        for (MavenRepository repo : normalizedRepos) {
            ResolvedGroupArtifactVersion resolvedGav = new ResolvedGroupArtifactVersion(repo.getUri(), gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), versionMaybeDatedSnapshot);
            Optional<Pom> result = this.mavenCache.getPom(resolvedGav);
            if (result == null) {
                URI uri = URI.create(repo.getUri() + (repo.getUri().endsWith("/") ? "" : "/") + gav.getGroupId().replace('.', '/') + '/' + gav.getArtifactId() + '/' + gav.getVersion() + '/' + gav.getArtifactId() + '-' + versionMaybeDatedSnapshot + ".pom");
                if ("file".equals(uri.getScheme())) {
                    Pom pom;
                    Path inputPath = Paths.get(gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
                    File f = new File(uri);
                    if (!f.exists()) continue;
                    FileInputStream fis = new FileInputStream(f);
                    try {
                        RawPom rawPom = RawPom.parse(fis, Objects.equals(versionMaybeDatedSnapshot, gav.getVersion()) ? null : versionMaybeDatedSnapshot);
                        Pom pom2 = rawPom.toPom(inputPath, repo).withGav(resolvedGav);
                        pom2 = pom2.withRepository(MavenRepository.MAVEN_LOCAL_USER_NEUTRAL);
                        if (!Objects.equals(versionMaybeDatedSnapshot, pom2.getVersion())) {
                            pom2 = pom2.withGav(pom2.getGav().withDatedSnapshotVersion(versionMaybeDatedSnapshot));
                        }
                        this.mavenCache.putPom(resolvedGav, pom2);
                        sample.stop(timer.tags(new String[]{"outcome", "from maven local"}).register((MeterRegistry)Metrics.globalRegistry));
                        pom = pom2;
                    }
                    catch (Throwable rawPom) {
                        try {
                            try {
                                fis.close();
                            }
                            catch (Throwable throwable) {
                                rawPom.addSuppressed(throwable);
                            }
                            throw rawPom;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    fis.close();
                    return pom;
                }
                try {
                    byte[] responseBody = this.requestAsAuthenticatedOrAnonymous(repo, uri.toString());
                    Path inputPath = Paths.get(gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
                    RawPom rawPom = RawPom.parse(new ByteArrayInputStream(responseBody), Objects.equals(versionMaybeDatedSnapshot, gav.getVersion()) ? null : versionMaybeDatedSnapshot);
                    Pom pom = rawPom.toPom(inputPath, repo).withGav(resolvedGav);
                    if (!Objects.equals(versionMaybeDatedSnapshot, pom.getVersion())) {
                        pom = pom.withGav(pom.getGav().withDatedSnapshotVersion(versionMaybeDatedSnapshot));
                    }
                    this.mavenCache.putPom(resolvedGav, pom);
                    sample.stop(timer.tags(new String[]{"outcome", "downloaded"}).register((MeterRegistry)Metrics.globalRegistry));
                    return pom;
                }
                catch (MavenClientSideException exception) {
                    this.mavenCache.putPom(resolvedGav, null);
                }
                finally {
                    continue;
                }
            }
            if (!result.isPresent()) continue;
            sample.stop(timer.tags(new String[]{"outcome", "cached"}).register((MeterRegistry)Metrics.globalRegistry));
            return result.get();
        }
        sample.stop(timer.tags(new String[]{"outcome", "unavailable"}).register((MeterRegistry)Metrics.globalRegistry));
        if (containingPom != null) {
            this.ctx.getResolutionListener().downloadError(gav, containingPom.getRequested());
        }
        throw new MavenDownloadingException("Unable to download dependency [" + gav + "] from the following repositories :\n  - " + normalizedRepos.stream().map(MavenRepository::getUri).collect(Collectors.joining("\n  - ")));
    }

    @Nullable
    private String datedSnapshotVersion(GroupArtifactVersion gav, @Nullable ResolvedPom containingPom, List<MavenRepository> repositories, ExecutionContext ctx) {
        if (gav.getVersion() != null && gav.getVersion().endsWith("-SNAPSHOT")) {
            MavenMetadata mavenMetadata;
            for (ResolvedGroupArtifactVersion pinnedSnapshotVersion : new MavenExecutionContextView(ctx).getPinnedSnapshotVersions()) {
                if (pinnedSnapshotVersion.getDatedSnapshotVersion() == null || !pinnedSnapshotVersion.getGroupId().equals(gav.getGroupId()) || !pinnedSnapshotVersion.getArtifactId().equals(gav.getArtifactId()) || !pinnedSnapshotVersion.getVersion().equals(gav.getVersion())) continue;
                return pinnedSnapshotVersion.getDatedSnapshotVersion();
            }
            try {
                mavenMetadata = this.downloadMetadata(gav, containingPom, repositories);
            }
            catch (MavenDownloadingException e) {
                return gav.getVersion();
            }
            MavenMetadata.Snapshot snapshot = mavenMetadata.getVersioning().getSnapshot();
            if (snapshot != null) {
                return gav.getVersion().replaceFirst("SNAPSHOT$", snapshot.getTimestamp() + "-" + snapshot.getBuildNumber());
            }
        }
        return gav.getVersion();
    }

    private Collection<MavenRepository> distinctNormalizedRepositories(List<MavenRepository> repositories, @Nullable ResolvedPom containingPom, @Nullable String acceptsVersion) {
        MavenRepository normalizedRepo;
        LinkedHashSet<MavenRepository> normalizedRepositories = new LinkedHashSet<MavenRepository>();
        normalizedRepositories.add(this.ctx.getLocalRepository());
        for (MavenRepository repo : repositories) {
            normalizedRepo = this.normalizeRepository(repo, containingPom);
            if (normalizedRepo == null || acceptsVersion != null && !normalizedRepo.acceptsVersion(acceptsVersion)) continue;
            normalizedRepositories.add(normalizedRepo);
        }
        for (MavenRepository repo : this.ctx.getRepositories()) {
            normalizedRepo = this.normalizeRepository(repo, containingPom);
            if (normalizedRepo == null || acceptsVersion != null && !normalizedRepo.acceptsVersion(acceptsVersion)) continue;
            normalizedRepositories.add(normalizedRepo);
        }
        normalizedRepositories.add(this.normalizeRepository(MavenRepository.MAVEN_CENTRAL, containingPom));
        return normalizedRepositories;
    }

    @Nullable
    protected MavenRepository normalizeRepository(MavenRepository originalRepository, @Nullable ResolvedPom containingPom) {
        Optional<MavenRepository> result;
        block12: {
            result = null;
            MavenRepository repository = this.applyAuthenticationToRepository(this.applyMirrors(originalRepository));
            if (containingPom != null) {
                repository = repository.withUri(containingPom.getValue(repository.getUri()));
            }
            try {
                MavenRepository normalized;
                block13: {
                    if (repository.isKnownToExist()) {
                        return repository;
                    }
                    String originalUrl = repository.getUri();
                    if ("file".equals(URI.create(originalUrl).getScheme())) {
                        return repository;
                    }
                    result = this.mavenCache.getNormalizedRepository(repository);
                    if (result != null) break block12;
                    if (!repository.getUri().toLowerCase().startsWith("http")) {
                        return null;
                    }
                    String httpsUri = repository.getUri().toLowerCase().startsWith("http:") ? repository.getUri().replaceFirst("[hH][tT][tT][pP]://", "https://") : repository.getUri();
                    HttpSender.Request.Builder request = this.applyAuthenticationToRequest(repository, this.httpSender.get(httpsUri));
                    normalized = null;
                    try {
                        this.sendRequest.apply((Object)request.build());
                        normalized = repository.withUri(httpsUri);
                    }
                    catch (MavenDownloadingException exception) {
                        normalized = repository.withUri(httpsUri);
                    }
                    catch (Throwable t) {
                        if (httpsUri.equals(originalUrl)) break block13;
                        try {
                            this.sendRequest.apply((Object)request.url(originalUrl).build());
                            normalized = new MavenRepository(repository.getId(), originalUrl, repository.isReleases(), repository.isSnapshots(), repository.getUsername(), repository.getPassword());
                        }
                        catch (MavenDownloadingException exception) {
                            normalized = new MavenRepository(repository.getId(), originalUrl, repository.isReleases(), repository.isSnapshots(), repository.getUsername(), repository.getPassword());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                this.mavenCache.putNormalizedRepository(repository, normalized);
                result = Optional.ofNullable(normalized);
            }
            catch (Exception e) {
                this.ctx.getOnError().accept(e);
                this.mavenCache.putNormalizedRepository(repository, null);
            }
        }
        return result == null || !result.isPresent() ? null : this.applyAuthenticationToRepository(result.get());
    }

    private byte[] requestAsAuthenticatedOrAnonymous(MavenRepository repo, String uriString) throws Throwable {
        try {
            return (byte[])this.sendRequest.apply((Object)this.applyAuthenticationToRequest(repo, this.httpSender.get(uriString)).build());
        }
        catch (MavenClientSideException e) {
            return (byte[])this.sendRequest.apply((Object)this.httpSender.get(uriString).build());
        }
    }

    private MavenRepository applyAuthenticationToRepository(MavenRepository repository) {
        return MavenRepositoryCredentials.apply(this.ctx.getCredentials(), repository);
    }

    private HttpSender.Request.Builder applyAuthenticationToRequest(MavenRepository repository, HttpSender.Request.Builder request) {
        if (repository.getUsername() != null && repository.getPassword() != null) {
            return request.withBasicAuthentication(repository.getUsername(), repository.getPassword());
        }
        return request;
    }

    private MavenRepository applyMirrors(MavenRepository repository) {
        return MavenRepositoryMirror.apply(this.ctx.getMirrors(), repository);
    }
}

