/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.utilities;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.openrewrite.Checksum;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.remote.Remote;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class MavenWrapper {
    public static final String ASF_LICENSE_HEADER = "# Licensed to the Apache Software Foundation (ASF) under one\n# or more contributor license agreements.  See the NOTICE file\n# distributed with this work for additional information\n# regarding copyright ownership.  The ASF licenses this file\n# to you under the Apache License, Version 2.0 (the\n# \"License\"); you may not use this file except in compliance\n# with the License.  You may obtain a copy of the License at\n# \n#   http://www.apache.org/licenses/LICENSE-2.0\n# \n# Unless required by applicable law or agreed to in writing,\n# software distributed under the License is distributed on an\n# \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n# KIND, either express or implied.  See the License for the\n# specific language governing permissions and limitations\n# under the License.\n";
    public static final String WRAPPER_DOWNLOADER_LOCATION_RELATIVE_PATH = ".mvn/wrapper/MavenWrapperDownloader.java";
    public static final String WRAPPER_JAR_LOCATION_RELATIVE_PATH = ".mvn/wrapper/maven-wrapper.jar";
    public static final String WRAPPER_PROPERTIES_LOCATION_RELATIVE_PATH = ".mvn/wrapper/maven-wrapper.properties";
    public static final String WRAPPER_SCRIPT_LOCATION_RELATIVE_PATH = "mvnw";
    public static final String WRAPPER_BATCH_LOCATION_RELATIVE_PATH = "mvnw.cmd";
    public static final Path WRAPPER_DOWNLOADER_LOCATION = Paths.get(".mvn/wrapper/MavenWrapperDownloader.java", new String[0]);
    public static final Path WRAPPER_JAR_LOCATION = Paths.get(".mvn/wrapper/maven-wrapper.jar", new String[0]);
    public static final Path WRAPPER_PROPERTIES_LOCATION = Paths.get(".mvn/wrapper/maven-wrapper.properties", new String[0]);
    public static final Path WRAPPER_SCRIPT_LOCATION = Paths.get("mvnw", new String[0]);
    public static final Path WRAPPER_BATCH_LOCATION = Paths.get("mvnw.cmd", new String[0]);
    private final String wrapperVersion;
    private final String wrapperUri;
    private final Checksum wrapperChecksum;
    private final String wrapperDistributionUri;
    private final DistributionType wrapperDistributionType;
    private final String distributionVersion;
    private final String distributionUri;
    private final Checksum distributionChecksum;

    public static MavenWrapper create(@Nullable String wrapperVersion, @Nullable String wrapperDistributionTypeName, @Nullable String distributionVersion, @Nullable String repositoryUrl, ExecutionContext ctx) {
        DistributionType wrapperDistributionType = Arrays.stream(DistributionType.values()).filter(dt -> ((DistributionType)dt).classifier.equalsIgnoreCase(wrapperDistributionTypeName)).findAny().orElse(DistributionType.Bin);
        MavenPomDownloader pomDownloader = new MavenPomDownloader(Collections.emptyMap(), ctx, null, null);
        LatestRelease wrapperVersionComparator = StringUtils.isBlank((String)wrapperVersion) ? new LatestRelease(null) : Objects.requireNonNull((VersionComparator)Semver.validate((String)wrapperVersion, null).getValue());
        LatestRelease distributionVersionComparator = StringUtils.isBlank((String)distributionVersion) ? new LatestRelease(null) : Objects.requireNonNull((VersionComparator)Semver.validate((String)distributionVersion, null).getValue());
        MavenRepository repository = StringUtils.isBlank((String)repositoryUrl) ? MavenRepository.MAVEN_CENTRAL : MavenRepository.builder().uri(repositoryUrl).releases(true).snapshots(true).build();
        List<MavenRepository> repositories = Collections.singletonList(repository);
        try {
            GroupArtifact wrapperDistributionGroupArtifact = new GroupArtifact("org.apache.maven.wrapper", "maven-wrapper-distribution");
            MavenMetadata wrapperMetadata = pomDownloader.downloadMetadata(wrapperDistributionGroupArtifact, null, repositories);
            String resolvedWrapperVersion = wrapperMetadata.getVersioning().getVersions().stream().filter(arg_0 -> MavenWrapper.lambda$create$1((VersionComparator)wrapperVersionComparator, arg_0)).max((arg_0, arg_1) -> MavenWrapper.lambda$create$2((VersionComparator)wrapperVersionComparator, arg_0, arg_1)).orElseThrow(() -> new IllegalStateException("Expected to find at least one Maven wrapper version to select from."));
            String resolvedWrapperUri = MavenWrapper.getDownloadUriFor(repository, new GroupArtifact("org.apache.maven.wrapper", "maven-wrapper"), resolvedWrapperVersion, null, "jar");
            String resolvedWrapperDistributionUri = MavenWrapper.getDownloadUriFor(repository, wrapperDistributionGroupArtifact, resolvedWrapperVersion, wrapperDistributionType.classifier, "zip");
            GroupArtifact distributionGroupArtifact = new GroupArtifact("org.apache.maven", "apache-maven");
            MavenMetadata distributionMetadata = pomDownloader.downloadMetadata(distributionGroupArtifact, null, repositories);
            String resolvedDistributionVersion = distributionMetadata.getVersioning().getVersions().stream().filter(arg_0 -> MavenWrapper.lambda$create$4((VersionComparator)distributionVersionComparator, arg_0)).max((arg_0, arg_1) -> MavenWrapper.lambda$create$5((VersionComparator)distributionVersionComparator, arg_0, arg_1)).orElseThrow(() -> new IllegalStateException("Expected to find at least one Maven distribution version to select from."));
            String resolvedDistributionUri = MavenWrapper.getDownloadUriFor(repository, distributionGroupArtifact, resolvedDistributionVersion, "bin", "zip");
            Remote wrapperJar = (Remote)Checksum.sha256((SourceFile)Remote.builder((Path)WRAPPER_JAR_LOCATION, (URI)URI.create(resolvedWrapperUri)).build(), (ExecutionContext)ctx);
            Remote mavenDistribution = (Remote)Checksum.sha256((SourceFile)Remote.builder((Path)Paths.get("", new String[0]), (URI)URI.create(resolvedDistributionUri)).build(), (ExecutionContext)ctx);
            return new MavenWrapper(resolvedWrapperVersion, resolvedWrapperUri, wrapperJar.getChecksum(), resolvedWrapperDistributionUri, wrapperDistributionType, resolvedDistributionVersion, resolvedDistributionUri, mavenDistribution.getChecksum());
        }
        catch (MavenDownloadingException e) {
            throw new RuntimeException("Could not get Maven versions at: " + repository.getUri(), e);
        }
    }

    public String getWrapperUrl() {
        return this.wrapperUri;
    }

    public String getDistributionUrl() {
        return this.distributionUri;
    }

    public Remote wrapperJar() {
        return Remote.builder((Path)WRAPPER_JAR_LOCATION, (URI)URI.create(this.wrapperUri)).build();
    }

    public Remote wrapperJar(SourceFile previous) {
        return Remote.builder((SourceFile)previous, (URI)URI.create(this.wrapperUri)).build();
    }

    public Remote wrapperDownloader() {
        return Remote.builder((Path)WRAPPER_DOWNLOADER_LOCATION, (URI)URI.create(this.wrapperDistributionUri)).build(new String[]{WRAPPER_DOWNLOADER_LOCATION_RELATIVE_PATH});
    }

    public Remote wrapperDownloader(SourceFile previous) {
        return Remote.builder((SourceFile)previous, (URI)URI.create(this.wrapperDistributionUri)).build(new String[]{WRAPPER_DOWNLOADER_LOCATION_RELATIVE_PATH});
    }

    public Remote mvnw() {
        return Remote.builder((Path)WRAPPER_SCRIPT_LOCATION, (URI)URI.create(this.wrapperDistributionUri)).build(new String[]{WRAPPER_SCRIPT_LOCATION_RELATIVE_PATH});
    }

    public Remote mvnwCmd() {
        return Remote.builder((Path)WRAPPER_BATCH_LOCATION, (URI)URI.create(this.wrapperDistributionUri)).build(new String[]{WRAPPER_BATCH_LOCATION_RELATIVE_PATH});
    }

    private static String getDownloadUriFor(MavenRepository repository, GroupArtifact ga, String version, @Nullable String classifier, String extension) {
        return repository.getUri() + "/" + ga.getGroupId().replace(".", "/") + "/" + ga.getArtifactId() + "/" + version + "/" + ga.getArtifactId() + "-" + version + (classifier == null ? "" : "-" + classifier) + "." + extension;
    }

    @Generated
    public MavenWrapper(String wrapperVersion, String wrapperUri, Checksum wrapperChecksum, String wrapperDistributionUri, DistributionType wrapperDistributionType, String distributionVersion, String distributionUri, Checksum distributionChecksum) {
        this.wrapperVersion = wrapperVersion;
        this.wrapperUri = wrapperUri;
        this.wrapperChecksum = wrapperChecksum;
        this.wrapperDistributionUri = wrapperDistributionUri;
        this.wrapperDistributionType = wrapperDistributionType;
        this.distributionVersion = distributionVersion;
        this.distributionUri = distributionUri;
        this.distributionChecksum = distributionChecksum;
    }

    @Generated
    public String getWrapperVersion() {
        return this.wrapperVersion;
    }

    @Generated
    public String getWrapperUri() {
        return this.wrapperUri;
    }

    @Generated
    public Checksum getWrapperChecksum() {
        return this.wrapperChecksum;
    }

    @Generated
    public String getWrapperDistributionUri() {
        return this.wrapperDistributionUri;
    }

    @Generated
    public DistributionType getWrapperDistributionType() {
        return this.wrapperDistributionType;
    }

    @Generated
    public String getDistributionVersion() {
        return this.distributionVersion;
    }

    @Generated
    public String getDistributionUri() {
        return this.distributionUri;
    }

    @Generated
    public Checksum getDistributionChecksum() {
        return this.distributionChecksum;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenWrapper)) {
            return false;
        }
        MavenWrapper other = (MavenWrapper)o;
        String this$wrapperVersion = this.getWrapperVersion();
        String other$wrapperVersion = other.getWrapperVersion();
        if (this$wrapperVersion == null ? other$wrapperVersion != null : !this$wrapperVersion.equals(other$wrapperVersion)) {
            return false;
        }
        String this$wrapperUri = this.getWrapperUri();
        String other$wrapperUri = other.getWrapperUri();
        if (this$wrapperUri == null ? other$wrapperUri != null : !this$wrapperUri.equals(other$wrapperUri)) {
            return false;
        }
        Checksum this$wrapperChecksum = this.getWrapperChecksum();
        Checksum other$wrapperChecksum = other.getWrapperChecksum();
        if (this$wrapperChecksum == null ? other$wrapperChecksum != null : !this$wrapperChecksum.equals(other$wrapperChecksum)) {
            return false;
        }
        String this$wrapperDistributionUri = this.getWrapperDistributionUri();
        String other$wrapperDistributionUri = other.getWrapperDistributionUri();
        if (this$wrapperDistributionUri == null ? other$wrapperDistributionUri != null : !this$wrapperDistributionUri.equals(other$wrapperDistributionUri)) {
            return false;
        }
        DistributionType this$wrapperDistributionType = this.getWrapperDistributionType();
        DistributionType other$wrapperDistributionType = other.getWrapperDistributionType();
        if (this$wrapperDistributionType == null ? other$wrapperDistributionType != null : !((Object)((Object)this$wrapperDistributionType)).equals((Object)other$wrapperDistributionType)) {
            return false;
        }
        String this$distributionVersion = this.getDistributionVersion();
        String other$distributionVersion = other.getDistributionVersion();
        if (this$distributionVersion == null ? other$distributionVersion != null : !this$distributionVersion.equals(other$distributionVersion)) {
            return false;
        }
        String this$distributionUri = this.getDistributionUri();
        String other$distributionUri = other.getDistributionUri();
        if (this$distributionUri == null ? other$distributionUri != null : !this$distributionUri.equals(other$distributionUri)) {
            return false;
        }
        Checksum this$distributionChecksum = this.getDistributionChecksum();
        Checksum other$distributionChecksum = other.getDistributionChecksum();
        return !(this$distributionChecksum == null ? other$distributionChecksum != null : !this$distributionChecksum.equals(other$distributionChecksum));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $wrapperVersion = this.getWrapperVersion();
        result = result * 59 + ($wrapperVersion == null ? 43 : $wrapperVersion.hashCode());
        String $wrapperUri = this.getWrapperUri();
        result = result * 59 + ($wrapperUri == null ? 43 : $wrapperUri.hashCode());
        Checksum $wrapperChecksum = this.getWrapperChecksum();
        result = result * 59 + ($wrapperChecksum == null ? 43 : $wrapperChecksum.hashCode());
        String $wrapperDistributionUri = this.getWrapperDistributionUri();
        result = result * 59 + ($wrapperDistributionUri == null ? 43 : $wrapperDistributionUri.hashCode());
        DistributionType $wrapperDistributionType = this.getWrapperDistributionType();
        result = result * 59 + ($wrapperDistributionType == null ? 43 : ((Object)((Object)$wrapperDistributionType)).hashCode());
        String $distributionVersion = this.getDistributionVersion();
        result = result * 59 + ($distributionVersion == null ? 43 : $distributionVersion.hashCode());
        String $distributionUri = this.getDistributionUri();
        result = result * 59 + ($distributionUri == null ? 43 : $distributionUri.hashCode());
        Checksum $distributionChecksum = this.getDistributionChecksum();
        result = result * 59 + ($distributionChecksum == null ? 43 : $distributionChecksum.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "MavenWrapper(wrapperVersion=" + this.getWrapperVersion() + ", wrapperUri=" + this.getWrapperUri() + ", wrapperChecksum=" + this.getWrapperChecksum() + ", wrapperDistributionUri=" + this.getWrapperDistributionUri() + ", wrapperDistributionType=" + (Object)((Object)this.getWrapperDistributionType()) + ", distributionVersion=" + this.getDistributionVersion() + ", distributionUri=" + this.getDistributionUri() + ", distributionChecksum=" + this.getDistributionChecksum() + ")";
    }

    private static /* synthetic */ int lambda$create$5(VersionComparator distributionVersionComparator, String v1, String v2) {
        return distributionVersionComparator.compare(null, v1, v2);
    }

    private static /* synthetic */ boolean lambda$create$4(VersionComparator distributionVersionComparator, String v) {
        return distributionVersionComparator.isValid(null, v);
    }

    private static /* synthetic */ int lambda$create$2(VersionComparator wrapperVersionComparator, String v1, String v2) {
        return wrapperVersionComparator.compare(null, v1, v2);
    }

    private static /* synthetic */ boolean lambda$create$1(VersionComparator wrapperVersionComparator, String v) {
        return wrapperVersionComparator.isValid(null, v);
    }

    public static enum DistributionType {
        Bin("bin"),
        OnlyScript("only-script"),
        Script("script"),
        Source("source");

        private final String classifier;

        private DistributionType(String classifier) {
            this.classifier = classifier;
        }
    }
}

