/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.python.PythonIsoVisitor;

public final class ChangeMethodName
extends Recipe {
    @Option(displayName="Old method name", description="The method name that will replace the existing name.", example="any")
    private final String oldMethodName;
    @Option(displayName="New method name", description="The method name that will replace the existing name.", example="any")
    private final String newMethodName;
    @Option(displayName="Ignore type definition", description="When set to `true` the definition of the old type will be left untouched. This is useful when you're replacing usage of a class but don't want to rename it.", required=false)
    private final @Nullable Boolean ignoreDefinition;

    public String getDisplayName() {
        return "Change method name";
    }

    public String getDescription() {
        return "Renames a method.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new PythonIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, ctx);
                if (!Boolean.TRUE.equals(ChangeMethodName.this.ignoreDefinition) && ChangeMethodName.this.oldMethodName.equals(m.getName().getSimpleName())) {
                    m = m.withName(m.getName().withSimpleName(ChangeMethodName.this.newMethodName));
                }
                return m;
            }

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, ctx);
                if (ChangeMethodName.this.oldMethodName.equals(m.getName().getSimpleName())) {
                    m = m.withName(m.getName().withSimpleName(ChangeMethodName.this.newMethodName));
                }
                return m;
            }

            @Override
            public J.MemberReference visitMemberReference(J.MemberReference memberRef, ExecutionContext ctx) {
                J.MemberReference m = super.visitMemberReference(memberRef, ctx);
                if (ChangeMethodName.this.oldMethodName.equals(m.getReference().getSimpleName())) {
                    m = m.withReference(m.getReference().withSimpleName(ChangeMethodName.this.newMethodName));
                }
                return m;
            }
        };
    }

    @Generated
    public ChangeMethodName(String oldMethodName, String newMethodName, @Nullable Boolean ignoreDefinition) {
        this.oldMethodName = oldMethodName;
        this.newMethodName = newMethodName;
        this.ignoreDefinition = ignoreDefinition;
    }

    @Generated
    public String getOldMethodName() {
        return this.oldMethodName;
    }

    @Generated
    public String getNewMethodName() {
        return this.newMethodName;
    }

    @Generated
    public @Nullable Boolean getIgnoreDefinition() {
        return this.ignoreDefinition;
    }

    @Generated
    public String toString() {
        return "ChangeMethodName(oldMethodName=" + this.getOldMethodName() + ", newMethodName=" + this.getNewMethodName() + ", ignoreDefinition=" + this.getIgnoreDefinition() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeMethodName)) {
            return false;
        }
        ChangeMethodName other = (ChangeMethodName)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$ignoreDefinition = this.getIgnoreDefinition();
        Boolean other$ignoreDefinition = other.getIgnoreDefinition();
        if (this$ignoreDefinition == null ? other$ignoreDefinition != null : !((Object)this$ignoreDefinition).equals(other$ignoreDefinition)) {
            return false;
        }
        String this$oldMethodName = this.getOldMethodName();
        String other$oldMethodName = other.getOldMethodName();
        if (this$oldMethodName == null ? other$oldMethodName != null : !this$oldMethodName.equals(other$oldMethodName)) {
            return false;
        }
        String this$newMethodName = this.getNewMethodName();
        String other$newMethodName = other.getNewMethodName();
        return !(this$newMethodName == null ? other$newMethodName != null : !this$newMethodName.equals(other$newMethodName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChangeMethodName;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $ignoreDefinition = this.getIgnoreDefinition();
        result = result * 59 + ($ignoreDefinition == null ? 43 : ((Object)$ignoreDefinition).hashCode());
        String $oldMethodName = this.getOldMethodName();
        result = result * 59 + ($oldMethodName == null ? 43 : $oldMethodName.hashCode());
        String $newMethodName = this.getNewMethodName();
        result = result * 59 + ($newMethodName == null ? 43 : $newMethodName.hashCode());
        return result;
    }
}

