/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Markers;
import org.openrewrite.python.tree.Py;
import org.openrewrite.python.tree.PyContainer;
import org.openrewrite.python.tree.PyLeftPadded;
import org.openrewrite.python.tree.PyRightPadded;
import org.openrewrite.python.tree.PySpace;

public class PythonVisitor<P>
extends JavaVisitor<P> {
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof Py;
    }

    public J visitAsync(Py.Async async, P p) {
        Statement tempStatement = (Statement)this.visitStatement(async = async.withPrefix(this.visitSpace(async.getPrefix(), PySpace.Location.ASYNC_PREFIX, p)), p);
        if (!(tempStatement instanceof Py.Async)) {
            return tempStatement;
        }
        async = (Py.Async)tempStatement;
        async = async.withMarkers(this.visitMarkers(async.getMarkers(), p));
        async = async.withStatement((Statement)this.visitAndCast((Tree)async.getStatement(), p));
        return async;
    }

    public J visitAwait(Py.Await await, P p) {
        Expression tempExpression = (Expression)this.visitExpression(await = await.withPrefix(this.visitSpace(await.getPrefix(), PySpace.Location.AWAIT_PREFIX, p)), p);
        if (!(tempExpression instanceof Py.Await)) {
            return tempExpression;
        }
        await = (Py.Await)tempExpression;
        await = await.withMarkers(this.visitMarkers(await.getMarkers(), p));
        await = await.withExpression((Expression)this.visitAndCast((Tree)await.getExpression(), p));
        return await;
    }

    public J visitBinary(Py.Binary binary, P p) {
        Expression tempExpression = (Expression)this.visitExpression(binary = binary.withPrefix(this.visitSpace(binary.getPrefix(), PySpace.Location.BINARY_PREFIX, p)), p);
        if (!(tempExpression instanceof Py.Binary)) {
            return tempExpression;
        }
        binary = (Py.Binary)tempExpression;
        binary = binary.withMarkers(this.visitMarkers(binary.getMarkers(), p));
        binary = binary.withLeft((Expression)this.visitAndCast((Tree)binary.getLeft(), p));
        binary = binary.getPadding().withOperator(this.visitLeftPadded(binary.getPadding().getOperator(), PyLeftPadded.Location.BINARY_OPERATOR, p));
        binary = binary.withNegation(this.visitSpace(binary.getNegation(), PySpace.Location.BINARY_NEGATION, p));
        binary = binary.withRight((Expression)this.visitAndCast((Tree)binary.getRight(), p));
        return binary;
    }

    public J visitChainedAssignment(Py.ChainedAssignment chainedAssignment, P p) {
        Statement tempStatement = (Statement)this.visitStatement(chainedAssignment = chainedAssignment.withPrefix(this.visitSpace(chainedAssignment.getPrefix(), PySpace.Location.CHAINED_ASSIGNMENT_PREFIX, p)), p);
        if (!(tempStatement instanceof Py.ChainedAssignment)) {
            return tempStatement;
        }
        chainedAssignment = (Py.ChainedAssignment)tempStatement;
        chainedAssignment = chainedAssignment.withMarkers(this.visitMarkers(chainedAssignment.getMarkers(), p));
        chainedAssignment = chainedAssignment.getPadding().withVariables(ListUtils.map(chainedAssignment.getPadding().getVariables(), el -> this.visitRightPadded((JRightPadded)el, PyRightPadded.Location.CHAINED_ASSIGNMENT_VARIABLES, p)));
        chainedAssignment = chainedAssignment.withAssignment((Expression)this.visitAndCast((Tree)chainedAssignment.getAssignment(), p));
        return chainedAssignment;
    }

    public J visitExceptionType(Py.ExceptionType exceptionType, P p) {
        exceptionType = exceptionType.withPrefix(this.visitSpace(exceptionType.getPrefix(), PySpace.Location.EXCEPTION_TYPE_PREFIX, p));
        exceptionType = exceptionType.withMarkers(this.visitMarkers(exceptionType.getMarkers(), p));
        exceptionType = exceptionType.withExpression((Expression)this.visitAndCast((Tree)exceptionType.getExpression(), p));
        return exceptionType;
    }

    public J visitForLoop(Py.ForLoop forLoop, P p) {
        Statement tempStatement = (Statement)this.visitStatement((Statement)(forLoop = forLoop.withPrefix(this.visitSpace(forLoop.getPrefix(), PySpace.Location.FOR_LOOP_PREFIX, p))), p);
        if (!(tempStatement instanceof Py.ForLoop)) {
            return tempStatement;
        }
        forLoop = (Py.ForLoop)tempStatement;
        forLoop = forLoop.withMarkers(this.visitMarkers(forLoop.getMarkers(), p));
        forLoop = forLoop.withTarget((Expression)this.visitAndCast((Tree)forLoop.getTarget(), p));
        forLoop = forLoop.getPadding().withIterable(this.visitLeftPadded(forLoop.getPadding().getIterable(), PyLeftPadded.Location.FOR_LOOP_ITERABLE, p));
        forLoop = forLoop.getPadding().withBody(this.visitRightPadded(forLoop.getPadding().getBody(), PyRightPadded.Location.FOR_LOOP_BODY, p));
        return forLoop;
    }

    public J visitLiteralType(Py.LiteralType literalType, P p) {
        Expression tempExpression = (Expression)this.visitExpression(literalType = literalType.withPrefix(this.visitSpace(literalType.getPrefix(), PySpace.Location.LITERAL_TYPE_PREFIX, p)), p);
        if (!(tempExpression instanceof Py.LiteralType)) {
            return tempExpression;
        }
        literalType = (Py.LiteralType)tempExpression;
        literalType = literalType.withMarkers(this.visitMarkers(literalType.getMarkers(), p));
        literalType = literalType.withLiteral((Expression)this.visitAndCast((Tree)literalType.getLiteral(), p));
        return literalType;
    }

    public J visitTypeHint(Py.TypeHint typeHint, P p) {
        typeHint = typeHint.withPrefix(this.visitSpace(typeHint.getPrefix(), PySpace.Location.TYPE_HINT_PREFIX, p));
        typeHint = typeHint.withMarkers(this.visitMarkers(typeHint.getMarkers(), p));
        typeHint = typeHint.withTypeTree((Expression)this.visitAndCast((Tree)typeHint.getTypeTree(), p));
        return typeHint;
    }

    public J visitCompilationUnit(Py.CompilationUnit compilationUnit, P p) {
        compilationUnit = compilationUnit.withPrefix(this.visitSpace(compilationUnit.getPrefix(), Space.Location.COMPILATION_UNIT_PREFIX, p));
        compilationUnit = compilationUnit.withMarkers(this.visitMarkers(compilationUnit.getMarkers(), p));
        compilationUnit = compilationUnit.getPadding().withImports(ListUtils.map(compilationUnit.getPadding().getImports(), el -> this.visitRightPadded((JRightPadded)el, JRightPadded.Location.IMPORT, p)));
        compilationUnit = compilationUnit.getPadding().withStatements(ListUtils.map(compilationUnit.getPadding().getStatements(), el -> this.visitRightPadded((JRightPadded)el, PyRightPadded.Location.COMPILATION_UNIT_STATEMENTS, p)));
        compilationUnit = compilationUnit.withEof(this.visitSpace(compilationUnit.getEof(), Space.Location.COMPILATION_UNIT_EOF, p));
        return compilationUnit;
    }

    public J visitExpressionStatement(Py.ExpressionStatement expressionStatement, P p) {
        expressionStatement = expressionStatement.withExpression((Expression)this.visitAndCast((Tree)expressionStatement.getExpression(), p));
        return expressionStatement;
    }

    public J visitExpressionTypeTree(Py.ExpressionTypeTree expressionTypeTree, P p) {
        Expression tempExpression = (Expression)this.visitExpression(expressionTypeTree = expressionTypeTree.withPrefix(this.visitSpace(expressionTypeTree.getPrefix(), PySpace.Location.EXPRESSION_TYPE_TREE_PREFIX, p)), p);
        if (!(tempExpression instanceof Py.ExpressionTypeTree)) {
            return tempExpression;
        }
        expressionTypeTree = (Py.ExpressionTypeTree)tempExpression;
        expressionTypeTree = expressionTypeTree.withMarkers(this.visitMarkers(expressionTypeTree.getMarkers(), p));
        expressionTypeTree = expressionTypeTree.withReference((J)this.visitAndCast((Tree)expressionTypeTree.getReference(), p));
        return expressionTypeTree;
    }

    public J visitStatementExpression(Py.StatementExpression statementExpression, P p) {
        statementExpression = statementExpression.withStatement((Statement)this.visitAndCast((Tree)statementExpression.getStatement(), p));
        return statementExpression;
    }

    public J visitMultiImport(Py.MultiImport multiImport, P p) {
        Statement tempStatement = (Statement)this.visitStatement(multiImport = multiImport.withPrefix(this.visitSpace(multiImport.getPrefix(), PySpace.Location.MULTI_IMPORT_PREFIX, p)), p);
        if (!(tempStatement instanceof Py.MultiImport)) {
            return tempStatement;
        }
        multiImport = (Py.MultiImport)tempStatement;
        multiImport = multiImport.withMarkers(this.visitMarkers(multiImport.getMarkers(), p));
        multiImport = multiImport.getPadding().withFrom(this.visitRightPadded(multiImport.getPadding().getFrom(), PyRightPadded.Location.MULTI_IMPORT_FROM, p));
        multiImport = multiImport.getPadding().withNames(this.visitContainer(multiImport.getPadding().getNames(), PyContainer.Location.MULTI_IMPORT_NAMES, p));
        return multiImport;
    }

    public J visitKeyValue(Py.KeyValue keyValue, P p) {
        Expression tempExpression = (Expression)this.visitExpression(keyValue = keyValue.withPrefix(this.visitSpace(keyValue.getPrefix(), PySpace.Location.KEY_VALUE_PREFIX, p)), p);
        if (!(tempExpression instanceof Py.KeyValue)) {
            return tempExpression;
        }
        keyValue = (Py.KeyValue)tempExpression;
        keyValue = keyValue.withMarkers(this.visitMarkers(keyValue.getMarkers(), p));
        keyValue = keyValue.getPadding().withKey(this.visitRightPadded(keyValue.getPadding().getKey(), PyRightPadded.Location.KEY_VALUE_KEY, p));
        keyValue = keyValue.withValue((Expression)this.visitAndCast((Tree)keyValue.getValue(), p));
        return keyValue;
    }

    public J visitDictLiteral(Py.DictLiteral dictLiteral, P p) {
        Expression tempExpression = (Expression)this.visitExpression(dictLiteral = dictLiteral.withPrefix(this.visitSpace(dictLiteral.getPrefix(), PySpace.Location.DICT_LITERAL_PREFIX, p)), p);
        if (!(tempExpression instanceof Py.DictLiteral)) {
            return tempExpression;
        }
        dictLiteral = (Py.DictLiteral)tempExpression;
        dictLiteral = dictLiteral.withMarkers(this.visitMarkers(dictLiteral.getMarkers(), p));
        dictLiteral = dictLiteral.getPadding().withElements(this.visitContainer(dictLiteral.getPadding().getElements(), PyContainer.Location.DICT_LITERAL_ELEMENTS, p));
        return dictLiteral;
    }

    public J visitCollectionLiteral(Py.CollectionLiteral collectionLiteral, P p) {
        Expression tempExpression = (Expression)this.visitExpression(collectionLiteral = collectionLiteral.withPrefix(this.visitSpace(collectionLiteral.getPrefix(), PySpace.Location.COLLECTION_LITERAL_PREFIX, p)), p);
        if (!(tempExpression instanceof Py.CollectionLiteral)) {
            return tempExpression;
        }
        collectionLiteral = (Py.CollectionLiteral)tempExpression;
        collectionLiteral = collectionLiteral.withMarkers(this.visitMarkers(collectionLiteral.getMarkers(), p));
        collectionLiteral = collectionLiteral.getPadding().withElements(this.visitContainer(collectionLiteral.getPadding().getElements(), PyContainer.Location.COLLECTION_LITERAL_ELEMENTS, p));
        return collectionLiteral;
    }

    public J visitFormattedString(Py.FormattedString formattedString, P p) {
        Expression tempExpression = (Expression)this.visitExpression(formattedString = formattedString.withPrefix(this.visitSpace(formattedString.getPrefix(), PySpace.Location.FORMATTED_STRING_PREFIX, p)), p);
        if (!(tempExpression instanceof Py.FormattedString)) {
            return tempExpression;
        }
        formattedString = (Py.FormattedString)tempExpression;
        formattedString = formattedString.withMarkers(this.visitMarkers(formattedString.getMarkers(), p));
        formattedString = formattedString.withParts(ListUtils.map(formattedString.getParts(), el -> (Expression)this.visit((Tree)el, p)));
        return formattedString;
    }

    public J visitFormattedStringValue(Py.FormattedString.Value value, P p) {
        Expression tempExpression = (Expression)this.visitExpression(value = value.withPrefix(this.visitSpace(value.getPrefix(), PySpace.Location.FORMATTED_STRING_VALUE_PREFIX, p)), p);
        if (!(tempExpression instanceof Py.FormattedString.Value)) {
            return tempExpression;
        }
        value = (Py.FormattedString.Value)tempExpression;
        value = value.withMarkers(this.visitMarkers(value.getMarkers(), p));
        value = value.getPadding().withExpression(this.visitRightPadded(value.getPadding().getExpression(), PyRightPadded.Location.FORMATTED_STRING_VALUE_EXPRESSION, p));
        value = value.getPadding().withDebug(this.visitRightPadded(value.getPadding().getDebug(), PyRightPadded.Location.FORMATTED_STRING_VALUE_DEBUG, p));
        value = value.withFormat((Expression)this.visitAndCast((Tree)value.getFormat(), p));
        return value;
    }

    public J visitPass(Py.Pass pass, P p) {
        Statement tempStatement = (Statement)this.visitStatement(pass = pass.withPrefix(this.visitSpace(pass.getPrefix(), PySpace.Location.PASS_PREFIX, p)), p);
        if (!(tempStatement instanceof Py.Pass)) {
            return tempStatement;
        }
        pass = (Py.Pass)tempStatement;
        pass = pass.withMarkers(this.visitMarkers(pass.getMarkers(), p));
        return pass;
    }

    public J visitTrailingElseWrapper(Py.TrailingElseWrapper trailingElseWrapper, P p) {
        Statement tempStatement = (Statement)this.visitStatement(trailingElseWrapper = trailingElseWrapper.withPrefix(this.visitSpace(trailingElseWrapper.getPrefix(), PySpace.Location.TRAILING_ELSE_WRAPPER_PREFIX, p)), p);
        if (!(tempStatement instanceof Py.TrailingElseWrapper)) {
            return tempStatement;
        }
        trailingElseWrapper = (Py.TrailingElseWrapper)tempStatement;
        trailingElseWrapper = trailingElseWrapper.withMarkers(this.visitMarkers(trailingElseWrapper.getMarkers(), p));
        trailingElseWrapper = trailingElseWrapper.withStatement((Statement)this.visitAndCast((Tree)trailingElseWrapper.getStatement(), p));
        trailingElseWrapper = trailingElseWrapper.getPadding().withElseBlock(this.visitLeftPadded(trailingElseWrapper.getPadding().getElseBlock(), PyLeftPadded.Location.TRAILING_ELSE_WRAPPER_ELSE_BLOCK, p));
        return trailingElseWrapper;
    }

    public J visitComprehensionExpression(Py.ComprehensionExpression comprehensionExpression, P p) {
        Expression tempExpression = (Expression)this.visitExpression(comprehensionExpression = comprehensionExpression.withPrefix(this.visitSpace(comprehensionExpression.getPrefix(), PySpace.Location.COMPREHENSION_EXPRESSION_PREFIX, p)), p);
        if (!(tempExpression instanceof Py.ComprehensionExpression)) {
            return tempExpression;
        }
        comprehensionExpression = (Py.ComprehensionExpression)tempExpression;
        comprehensionExpression = comprehensionExpression.withMarkers(this.visitMarkers(comprehensionExpression.getMarkers(), p));
        comprehensionExpression = comprehensionExpression.withResult((Expression)this.visitAndCast((Tree)comprehensionExpression.getResult(), p));
        comprehensionExpression = comprehensionExpression.withClauses(ListUtils.map(comprehensionExpression.getClauses(), el -> (Py.ComprehensionExpression.Clause)this.visit((Tree)el, p)));
        comprehensionExpression = comprehensionExpression.withSuffix(this.visitSpace(comprehensionExpression.getSuffix(), PySpace.Location.COMPREHENSION_EXPRESSION_SUFFIX, p));
        return comprehensionExpression;
    }

    public J visitComprehensionCondition(Py.ComprehensionExpression.Condition condition, P p) {
        condition = condition.withPrefix(this.visitSpace(condition.getPrefix(), PySpace.Location.COMPREHENSION_EXPRESSION_CONDITION_PREFIX, p));
        condition = condition.withMarkers(this.visitMarkers(condition.getMarkers(), p));
        condition = condition.withExpression((Expression)this.visitAndCast((Tree)condition.getExpression(), p));
        return condition;
    }

    public J visitComprehensionClause(Py.ComprehensionExpression.Clause clause, P p) {
        clause = clause.withPrefix(this.visitSpace(clause.getPrefix(), PySpace.Location.COMPREHENSION_EXPRESSION_CLAUSE_PREFIX, p));
        clause = clause.withMarkers(this.visitMarkers(clause.getMarkers(), p));
        clause = clause.getPadding().withAsync(this.visitRightPadded(clause.getPadding().getAsync(), PyRightPadded.Location.COMPREHENSION_EXPRESSION_CLAUSE_ASYNC, p));
        clause = clause.withIteratorVariable((Expression)this.visitAndCast((Tree)clause.getIteratorVariable(), p));
        clause = clause.getPadding().withIteratedList(this.visitLeftPadded(clause.getPadding().getIteratedList(), PyLeftPadded.Location.COMPREHENSION_EXPRESSION_CLAUSE_ITERATED_LIST, p));
        clause = clause.withConditions(ListUtils.map(clause.getConditions(), el -> (Py.ComprehensionExpression.Condition)this.visit((Tree)el, p)));
        return clause;
    }

    public J visitTypeAlias(Py.TypeAlias typeAlias, P p) {
        Statement tempStatement = (Statement)this.visitStatement(typeAlias = typeAlias.withPrefix(this.visitSpace(typeAlias.getPrefix(), PySpace.Location.TYPE_ALIAS_PREFIX, p)), p);
        if (!(tempStatement instanceof Py.TypeAlias)) {
            return tempStatement;
        }
        typeAlias = (Py.TypeAlias)tempStatement;
        typeAlias = typeAlias.withMarkers(this.visitMarkers(typeAlias.getMarkers(), p));
        typeAlias = typeAlias.withName((J.Identifier)this.visitAndCast((Tree)typeAlias.getName(), p));
        typeAlias = typeAlias.getPadding().withValue(this.visitLeftPadded(typeAlias.getPadding().getValue(), PyLeftPadded.Location.TYPE_ALIAS_VALUE, p));
        return typeAlias;
    }

    public J visitYieldFrom(Py.YieldFrom yieldFrom, P p) {
        Expression tempExpression = (Expression)this.visitExpression(yieldFrom = yieldFrom.withPrefix(this.visitSpace(yieldFrom.getPrefix(), PySpace.Location.YIELD_FROM_PREFIX, p)), p);
        if (!(tempExpression instanceof Py.YieldFrom)) {
            return tempExpression;
        }
        yieldFrom = (Py.YieldFrom)tempExpression;
        yieldFrom = yieldFrom.withMarkers(this.visitMarkers(yieldFrom.getMarkers(), p));
        yieldFrom = yieldFrom.withExpression((Expression)this.visitAndCast((Tree)yieldFrom.getExpression(), p));
        return yieldFrom;
    }

    public J visitUnionType(Py.UnionType unionType, P p) {
        Expression tempExpression = (Expression)this.visitExpression(unionType = unionType.withPrefix(this.visitSpace(unionType.getPrefix(), PySpace.Location.UNION_TYPE_PREFIX, p)), p);
        if (!(tempExpression instanceof Py.UnionType)) {
            return tempExpression;
        }
        unionType = (Py.UnionType)tempExpression;
        unionType = unionType.withMarkers(this.visitMarkers(unionType.getMarkers(), p));
        unionType = unionType.getPadding().withTypes(ListUtils.map(unionType.getPadding().getTypes(), el -> this.visitRightPadded((JRightPadded)el, PyRightPadded.Location.UNION_TYPE_TYPES, p)));
        return unionType;
    }

    public J visitVariableScope(Py.VariableScope variableScope, P p) {
        Statement tempStatement = (Statement)this.visitStatement(variableScope = variableScope.withPrefix(this.visitSpace(variableScope.getPrefix(), PySpace.Location.VARIABLE_SCOPE_PREFIX, p)), p);
        if (!(tempStatement instanceof Py.VariableScope)) {
            return tempStatement;
        }
        variableScope = (Py.VariableScope)tempStatement;
        variableScope = variableScope.withMarkers(this.visitMarkers(variableScope.getMarkers(), p));
        variableScope = variableScope.getPadding().withNames(ListUtils.map(variableScope.getPadding().getNames(), el -> this.visitRightPadded((JRightPadded)el, PyRightPadded.Location.VARIABLE_SCOPE_NAMES, p)));
        return variableScope;
    }

    public J visitDel(Py.Del del, P p) {
        Statement tempStatement = (Statement)this.visitStatement(del = del.withPrefix(this.visitSpace(del.getPrefix(), PySpace.Location.DEL_PREFIX, p)), p);
        if (!(tempStatement instanceof Py.Del)) {
            return tempStatement;
        }
        del = (Py.Del)tempStatement;
        del = del.withMarkers(this.visitMarkers(del.getMarkers(), p));
        del = del.getPadding().withTargets(ListUtils.map(del.getPadding().getTargets(), el -> this.visitRightPadded((JRightPadded)el, PyRightPadded.Location.DEL_TARGETS, p)));
        return del;
    }

    public J visitSpecialParameter(Py.SpecialParameter specialParameter, P p) {
        specialParameter = specialParameter.withPrefix(this.visitSpace(specialParameter.getPrefix(), PySpace.Location.SPECIAL_PARAMETER_PREFIX, p));
        specialParameter = specialParameter.withMarkers(this.visitMarkers(specialParameter.getMarkers(), p));
        specialParameter = specialParameter.withTypeHint((Py.TypeHint)this.visitAndCast((Tree)specialParameter.getTypeHint(), p));
        return specialParameter;
    }

    public J visitStar(Py.Star star, P p) {
        Expression tempExpression = (Expression)this.visitExpression(star = star.withPrefix(this.visitSpace(star.getPrefix(), PySpace.Location.STAR_PREFIX, p)), p);
        if (!(tempExpression instanceof Py.Star)) {
            return tempExpression;
        }
        star = (Py.Star)tempExpression;
        star = star.withMarkers(this.visitMarkers(star.getMarkers(), p));
        star = star.withExpression((Expression)this.visitAndCast((Tree)star.getExpression(), p));
        return star;
    }

    public J visitNamedArgument(Py.NamedArgument namedArgument, P p) {
        Expression tempExpression = (Expression)this.visitExpression(namedArgument = namedArgument.withPrefix(this.visitSpace(namedArgument.getPrefix(), PySpace.Location.NAMED_ARGUMENT_PREFIX, p)), p);
        if (!(tempExpression instanceof Py.NamedArgument)) {
            return tempExpression;
        }
        namedArgument = (Py.NamedArgument)tempExpression;
        namedArgument = namedArgument.withMarkers(this.visitMarkers(namedArgument.getMarkers(), p));
        namedArgument = namedArgument.withName((J.Identifier)this.visitAndCast((Tree)namedArgument.getName(), p));
        namedArgument = namedArgument.getPadding().withValue(this.visitLeftPadded(namedArgument.getPadding().getValue(), PyLeftPadded.Location.NAMED_ARGUMENT_VALUE, p));
        return namedArgument;
    }

    public J visitTypeHintedExpression(Py.TypeHintedExpression typeHintedExpression, P p) {
        Expression tempExpression = (Expression)this.visitExpression(typeHintedExpression = typeHintedExpression.withPrefix(this.visitSpace(typeHintedExpression.getPrefix(), PySpace.Location.TYPE_HINTED_EXPRESSION_PREFIX, p)), p);
        if (!(tempExpression instanceof Py.TypeHintedExpression)) {
            return tempExpression;
        }
        typeHintedExpression = (Py.TypeHintedExpression)tempExpression;
        typeHintedExpression = typeHintedExpression.withMarkers(this.visitMarkers(typeHintedExpression.getMarkers(), p));
        typeHintedExpression = typeHintedExpression.withExpression((Expression)this.visitAndCast((Tree)typeHintedExpression.getExpression(), p));
        typeHintedExpression = typeHintedExpression.withTypeHint((Py.TypeHint)this.visitAndCast((Tree)typeHintedExpression.getTypeHint(), p));
        return typeHintedExpression;
    }

    public J visitErrorFrom(Py.ErrorFrom errorFrom, P p) {
        Expression tempExpression = (Expression)this.visitExpression(errorFrom = errorFrom.withPrefix(this.visitSpace(errorFrom.getPrefix(), PySpace.Location.ERROR_FROM_PREFIX, p)), p);
        if (!(tempExpression instanceof Py.ErrorFrom)) {
            return tempExpression;
        }
        errorFrom = (Py.ErrorFrom)tempExpression;
        errorFrom = errorFrom.withMarkers(this.visitMarkers(errorFrom.getMarkers(), p));
        errorFrom = errorFrom.withError((Expression)this.visitAndCast((Tree)errorFrom.getError(), p));
        errorFrom = errorFrom.getPadding().withFrom(this.visitLeftPadded(errorFrom.getPadding().getFrom(), PyLeftPadded.Location.ERROR_FROM_FROM, p));
        return errorFrom;
    }

    public J visitMatchCase(Py.MatchCase matchCase, P p) {
        Expression tempExpression = (Expression)this.visitExpression(matchCase = matchCase.withPrefix(this.visitSpace(matchCase.getPrefix(), PySpace.Location.MATCH_CASE_PREFIX, p)), p);
        if (!(tempExpression instanceof Py.MatchCase)) {
            return tempExpression;
        }
        matchCase = (Py.MatchCase)tempExpression;
        matchCase = matchCase.withMarkers(this.visitMarkers(matchCase.getMarkers(), p));
        matchCase = matchCase.withPattern((Py.MatchCase.Pattern)this.visitAndCast((Tree)matchCase.getPattern(), p));
        matchCase = matchCase.getPadding().withGuard(this.visitLeftPadded(matchCase.getPadding().getGuard(), PyLeftPadded.Location.MATCH_CASE_GUARD, p));
        return matchCase;
    }

    public J visitMatchCasePattern(Py.MatchCase.Pattern pattern, P p) {
        Expression tempExpression = (Expression)this.visitExpression(pattern = pattern.withPrefix(this.visitSpace(pattern.getPrefix(), PySpace.Location.MATCH_CASE_PATTERN_PREFIX, p)), p);
        if (!(tempExpression instanceof Py.MatchCase.Pattern)) {
            return tempExpression;
        }
        pattern = (Py.MatchCase.Pattern)tempExpression;
        pattern = pattern.withMarkers(this.visitMarkers(pattern.getMarkers(), p));
        pattern = pattern.getPadding().withChildren(this.visitContainer(pattern.getPadding().getChildren(), PyContainer.Location.MATCH_CASE_PATTERN_CHILDREN, p));
        return pattern;
    }

    public J visitSlice(Py.Slice slice, P p) {
        Expression tempExpression = (Expression)this.visitExpression(slice = slice.withPrefix(this.visitSpace(slice.getPrefix(), PySpace.Location.SLICE_PREFIX, p)), p);
        if (!(tempExpression instanceof Py.Slice)) {
            return tempExpression;
        }
        slice = (Py.Slice)tempExpression;
        slice = slice.withMarkers(this.visitMarkers(slice.getMarkers(), p));
        slice = slice.getPadding().withStart(this.visitRightPadded(slice.getPadding().getStart(), PyRightPadded.Location.SLICE_START, p));
        slice = slice.getPadding().withStop(this.visitRightPadded(slice.getPadding().getStop(), PyRightPadded.Location.SLICE_STOP, p));
        slice = slice.getPadding().withStep(this.visitRightPadded(slice.getPadding().getStep(), PyRightPadded.Location.SLICE_STEP, p));
        return slice;
    }

    public <J2 extends J> JContainer<J2> visitContainer(@Nullable JContainer<J2> container, PyContainer.Location loc, P p) {
        if (container == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), container));
        Space before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), p);
        List js = ListUtils.map((List)container.getPadding().getElements(), t -> this.visitRightPadded((JRightPadded)t, loc.getElementLocation(), p));
        this.setCursor(this.getCursor().getParent());
        return js == container.getPadding().getElements() && before == container.getBefore() ? container : JContainer.build((Space)before, (List)js, (Markers)container.getMarkers());
    }

    public <T> JLeftPadded<T> visitLeftPadded(@Nullable JLeftPadded<T> left, PyLeftPadded.Location loc, P p) {
        if (left == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), left));
        Space before = this.visitSpace(left.getBefore(), loc.getBeforeLocation(), p);
        Object t = left.getElement();
        if (t instanceof J) {
            t = this.visitAndCast((Tree)((J)left.getElement()), p);
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            if (left.getElement() == null && before == left.getBefore()) {
                return left;
            }
            return null;
        }
        return before == left.getBefore() && t == left.getElement() ? left : new JLeftPadded(before, t, left.getMarkers());
    }

    public <T> JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, PyRightPadded.Location loc, P p) {
        if (right == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), right));
        Object t = right.getElement();
        if (t instanceof J) {
            t = this.visitAndCast((Tree)((J)right.getElement()), p);
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            return null;
        }
        Space after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
        Markers markers = this.visitMarkers(right.getMarkers(), p);
        return after == right.getAfter() && t == right.getElement() && markers == right.getMarkers() ? right : new JRightPadded<T>(t, after, markers);
    }

    public Space visitSpace(Space space, PySpace.Location loc, P p) {
        if (space == Space.EMPTY || space == Space.SINGLE_SPACE || space == null) {
            return space;
        }
        if (space.getComments().isEmpty()) {
            return space;
        }
        return this.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }
}

