/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python.style;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.python.PythonIsoVisitor;
import org.openrewrite.python.style.IntelliJ;
import org.openrewrite.python.style.PythonStyle;
import org.openrewrite.python.style.SpacesStyle;
import org.openrewrite.python.style.TabsAndIndentsStyle;
import org.openrewrite.python.tree.Py;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

public class Autodetect
extends NamedStyles
implements PythonStyle {
    public Autodetect(UUID id, Collection<Style> styles) {
        super(id, "org.openrewrite.python.Autodetect", "Auto-detected", "Automatically detect styles from a repository's existing code.", Collections.emptySet(), styles);
    }

    public static Detector detector() {
        return new Detector();
    }

    public static class Detector {
        private final IndentStatistics indentStatistics = new IndentStatistics();
        private final FindIndentVisitor indentVisitor = new FindIndentVisitor();
        private final SpacesStatistics spacesStatistics = new SpacesStatistics();
        private final FindSpaceVisitor spacesVisitor = new FindSpaceVisitor();

        public void sample(SourceFile python) {
            if (python instanceof Py.CompilationUnit) {
                this.indentVisitor.visitNonNull((Tree)python, this.indentStatistics);
                this.spacesVisitor.visitNonNull((Tree)python, this.spacesStatistics);
            }
        }

        public Autodetect build() {
            return new Autodetect(Tree.randomId(), Arrays.asList(this.indentStatistics.getTabsAndIndentsStyle(), this.spacesStatistics.getStyle()));
        }
    }

    private static class FindSpaceVisitor
    extends PythonIsoVisitor<SpacesStatistics> {
        private FindSpaceVisitor() {
        }

        private static boolean variableIsPartOfMethodHeader(Cursor cursor) {
            return cursor.getParentTreeCursor().getValue() instanceof J.VariableDeclarations && cursor.getParentTreeCursor().getParentTreeCursor().getValue() instanceof J.MethodDeclaration;
        }

        private static int hasSpace(@Nullable Space space) {
            if (space == null) {
                return 0;
            }
            return space.getWhitespace().contains(" ") ? 1 : -1;
        }

        private static int hasSpaceBefore(@Nullable JContainer<?> container) {
            if (container != null) {
                return FindSpaceVisitor.hasSpace(container.getBefore());
            }
            return 0;
        }

        private static int hasSpaceBefore(@Nullable JLeftPadded<?> container) {
            if (container != null) {
                return FindSpaceVisitor.hasSpace(container.getBefore());
            }
            return 0;
        }

        private static <T extends J> int hasSpaceBeforeElement(@Nullable JRightPadded<T> padded) {
            if (padded != null) {
                return FindSpaceVisitor.hasSpace(((J)padded.getElement()).getPrefix());
            }
            return 0;
        }

        private static <T extends J> int hasSpaceBeforeElement(@Nullable JLeftPadded<T> padded) {
            if (padded != null) {
                return FindSpaceVisitor.hasSpace(((J)padded.getElement()).getPrefix());
            }
            return 0;
        }

        public @Nullable J visit(@Nullable Tree tree, SpacesStatistics statistics) {
            try {
                super.visit(tree, (Object)statistics);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return (J)tree;
        }

        @Override
        public J.Block visitBlock(J.Block block, SpacesStatistics statistics) {
            statistics.otherBeforeColon += FindSpaceVisitor.hasSpace(block.getPrefix());
            return super.visitBlock(block, statistics);
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable v, SpacesStatistics statistics) {
            v = super.visitVariable(v, statistics);
            if (FindSpaceVisitor.variableIsPartOfMethodHeader(this.getCursor())) {
                return v;
            }
            J.VariableDeclarations parent = (J.VariableDeclarations)this.getCursor().dropParentUntil(J.VariableDeclarations.class::isInstance).getValue();
            if (v.getPadding().getInitializer() != null && parent.getTypeExpression() == null) {
                statistics.aroundOperatorsEqInNamedParameter += FindSpaceVisitor.hasSpaceBefore(v.getPadding().getInitializer());
                statistics.aroundOperatorsEqInNamedParameter += FindSpaceVisitor.hasSpaceBeforeElement(v.getPadding().getInitializer());
            }
            return v;
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, SpacesStatistics statistics) {
            statistics.beforeParenthesesMethodCall += FindSpaceVisitor.hasSpaceBefore(classDecl.getPadding().getImplements());
            if (classDecl.getImplements() != null && !classDecl.getImplements().isEmpty()) {
                statistics.withinMethodCallParentheses += FindSpaceVisitor.hasSpace(((TypeTree)classDecl.getImplements().get(0)).getPrefix());
            }
            return super.visitClassDeclaration(classDecl, statistics);
        }

        @Override
        public J.Binary visitBinary(J.Binary binary, SpacesStatistics statistics) {
            J.Binary b = super.visitBinary(binary, statistics);
            J.Binary.Type op = b.getOperator();
            int hasSpaceAround = Integer.max(FindSpaceVisitor.hasSpace(b.getPadding().getOperator().getBefore()), FindSpaceVisitor.hasSpace(b.getRight().getPrefix()));
            if (op == J.Binary.Type.Addition || op == J.Binary.Type.Subtraction) {
                statistics.aroundOperatorsAdditive += hasSpaceAround;
            } else if (op == J.Binary.Type.Multiplication || op == J.Binary.Type.Division || op == J.Binary.Type.Modulo) {
                statistics.aroundOperatorsMultiplicative += hasSpaceAround;
            } else if (op == J.Binary.Type.Equal || op == J.Binary.Type.NotEqual) {
                statistics.aroundOperatorsEquality += hasSpaceAround;
            } else if (op == J.Binary.Type.LessThan || op == J.Binary.Type.GreaterThan || op == J.Binary.Type.LessThanOrEqual || op == J.Binary.Type.GreaterThanOrEqual) {
                statistics.aroundOperatorsRelational += hasSpaceAround;
            } else if (op == J.Binary.Type.BitAnd || op == J.Binary.Type.BitOr || op == J.Binary.Type.BitXor) {
                statistics.aroundOperatorsBitwise += hasSpaceAround;
            } else if (op == J.Binary.Type.LeftShift || op == J.Binary.Type.RightShift || op == J.Binary.Type.UnsignedRightShift) {
                statistics.aroundOperatorsShift += hasSpaceAround;
            }
            return b;
        }

        @Override
        public Py.Binary visitBinary(Py.Binary binary, SpacesStatistics statistics) {
            J b = super.visitBinary(binary, (Object)statistics);
            Py.Binary.Type op = b.getOperator();
            int hasSpaceAround = Integer.max(FindSpaceVisitor.hasSpace(b.getPadding().getOperator().getBefore()), FindSpaceVisitor.hasSpace(b.getRight().getPrefix()));
            if (op == Py.Binary.Type.FloorDivision || op == Py.Binary.Type.MatrixMultiplication) {
                statistics.aroundOperatorsMultiplicative += hasSpaceAround;
            } else if (op == Py.Binary.Type.StringConcatenation) {
                statistics.aroundOperatorsAdditive += hasSpaceAround;
            } else if (op == Py.Binary.Type.Power) {
                statistics.aroundOperatorsPower += hasSpaceAround;
            }
            return b;
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, SpacesStatistics statistics) {
            statistics.beforeParenthesesMethodDeclaration += FindSpaceVisitor.hasSpace(method.getPadding().getParameters().getBefore());
            if (!method.getParameters().isEmpty()) {
                statistics.withinMethodDeclarationParentheses += FindSpaceVisitor.hasSpace(((Statement)method.getParameters().get(0)).getPrefix());
            } else {
                statistics.withinEmptyMethodDeclarationParentheses += FindSpaceVisitor.hasSpace(method.getPadding().getParameters().getBefore());
            }
            return super.visitMethodDeclaration(method, statistics);
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, SpacesStatistics statistics) {
            statistics.beforeParenthesesMethodCall += FindSpaceVisitor.hasSpace(method.getPadding().getArguments().getBefore());
            if (!method.getArguments().isEmpty()) {
                statistics.withinMethodCallParentheses += FindSpaceVisitor.hasSpace(((Expression)method.getArguments().get(0)).getPrefix());
            } else {
                statistics.withinEmptyMethodCallParentheses += FindSpaceVisitor.hasSpace(method.getPadding().getArguments().getBefore());
            }
            return super.visitMethodInvocation(method, statistics);
        }

        @Override
        public J.Assignment visitAssignment(J.Assignment assignment, SpacesStatistics statistics) {
            statistics.aroundOperatorsAssignment += FindSpaceVisitor.hasSpace(assignment.getPadding().getAssignment().getBefore());
            statistics.aroundOperatorsAssignment += FindSpaceVisitor.hasSpace(assignment.getAssignment().getPrefix());
            return super.visitAssignment(assignment, statistics);
        }

        @Override
        public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignOp, SpacesStatistics statistics) {
            statistics.aroundOperatorsAssignment += FindSpaceVisitor.hasSpace(assignOp.getPadding().getOperator().getBefore());
            statistics.aroundOperatorsAssignment += FindSpaceVisitor.hasSpace(assignOp.getAssignment().getPrefix());
            return super.visitAssignmentOperation(assignOp, statistics);
        }

        @Override
        public Py.ChainedAssignment visitChainedAssignment(Py.ChainedAssignment chainedAssignment, SpacesStatistics statistics) {
            for (JRightPadded<Expression> variable : chainedAssignment.getPadding().getVariables()) {
                statistics.aroundOperatorsAssignment += FindSpaceVisitor.hasSpace(variable.getAfter());
            }
            statistics.aroundOperatorsAssignment += FindSpaceVisitor.hasSpace(chainedAssignment.getAssignment().getPrefix());
            return super.visitChainedAssignment(chainedAssignment, statistics);
        }

        @Override
        public J.MemberReference visitMemberReference(J.MemberReference memberRef, SpacesStatistics statistics) {
            if (memberRef.getPadding().getTypeParameters() != null) {
                statistics.withinBrackets += FindSpaceVisitor.hasSpace(memberRef.getPadding().getTypeParameters().getBefore());
            }
            return super.visitMemberReference(memberRef, statistics);
        }

        @Override
        public J.If visitIf(J.If iff, SpacesStatistics statistics) {
            statistics.otherBeforeColon += FindSpaceVisitor.hasSpace(iff.getPadding().getThenPart().getAfter());
            return super.visitIf(iff, statistics);
        }

        @Override
        public J.ParameterizedType visitParameterizedType(J.ParameterizedType type, SpacesStatistics statistics) {
            JContainer typeParams = type.getPadding().getTypeParameters();
            if (typeParams != null) {
                statistics.withinBrackets += FindSpaceVisitor.hasSpace(typeParams.getBefore());
                if (!typeParams.getElements().isEmpty()) {
                    statistics.withinBrackets += FindSpaceVisitor.hasSpace(((Expression)typeParams.getElements().get(0)).getPrefix());
                }
            }
            return super.visitParameterizedType(type, statistics);
        }

        @Override
        public Py.CollectionLiteral visitCollectionLiteral(Py.CollectionLiteral coll, SpacesStatistics statistics) {
            List<Expression> el = coll.getElements();
            if (coll.getKind() == Py.CollectionLiteral.Kind.LIST) {
                if (!el.isEmpty()) {
                    statistics.withinBrackets += FindSpaceVisitor.hasSpace(el.get(0).getPrefix());
                }
            } else if (!(coll.getKind() != Py.CollectionLiteral.Kind.SET && coll.getKind() != Py.CollectionLiteral.Kind.TUPLE || el.isEmpty())) {
                statistics.withinBraces += FindSpaceVisitor.hasSpace(el.get(0).getPrefix());
            }
            return super.visitCollectionLiteral(coll, statistics);
        }

        @Override
        public Py.TypeHint visitTypeHint(Py.TypeHint typeHint, SpacesStatistics statistics) {
            statistics.otherBeforeColon += FindSpaceVisitor.hasSpace(typeHint.getPrefix());
            statistics.otherAfterColon += FindSpaceVisitor.hasSpace(typeHint.getTypeTree().getPrefix());
            return super.visitTypeHint(typeHint, statistics);
        }

        @Override
        public Py.ComprehensionExpression visitComprehensionExpression(Py.ComprehensionExpression comp, SpacesStatistics statistics) {
            if (comp.getKind() == Py.ComprehensionExpression.Kind.LIST) {
                statistics.withinBrackets += FindSpaceVisitor.hasSpace(comp.getResult().getPrefix());
            } else if (comp.getKind() == Py.ComprehensionExpression.Kind.SET || comp.getKind() == Py.ComprehensionExpression.Kind.DICT) {
                statistics.withinBraces += FindSpaceVisitor.hasSpace(comp.getResult().getPrefix());
            }
            return super.visitComprehensionExpression(comp, statistics);
        }

        @Override
        public J.ArrayAccess visitArrayAccess(J.ArrayAccess arrayAccess, SpacesStatistics statistics) {
            statistics.beforeParenthesesLeftBracket += FindSpaceVisitor.hasSpace(arrayAccess.getDimension().getPrefix());
            if (arrayAccess.getDimension().getPadding().getIndex() != null) {
                statistics.withinBrackets += FindSpaceVisitor.hasSpace(((Expression)arrayAccess.getDimension().getPadding().getIndex().getElement()).getPrefix());
            }
            return super.visitArrayAccess(arrayAccess, statistics);
        }

        @Override
        public Py.NamedArgument visitNamedArgument(Py.NamedArgument namedArg, SpacesStatistics statistics) {
            if (namedArg.getPadding().getValue() != null) {
                statistics.aroundOperatorsEqInKeywordArgument += FindSpaceVisitor.hasSpace(namedArg.getPadding().getValue().getBefore());
                statistics.aroundOperatorsEqInKeywordArgument += FindSpaceVisitor.hasSpace(((Expression)namedArg.getPadding().getValue().getElement()).getPrefix());
            }
            return super.visitNamedArgument(namedArg, statistics);
        }

        @Override
        public Py.ForLoop visitForLoop(Py.ForLoop forLoop, SpacesStatistics statistics) {
            statistics.otherBeforeColon += FindSpaceVisitor.hasSpace(forLoop.getPadding().getIterable().getBefore());
            return super.visitForLoop(forLoop, (Object)statistics);
        }

        @Override
        public Py.Slice visitSlice(Py.Slice slice, SpacesStatistics statistics) {
            statistics.withinBrackets += FindSpaceVisitor.hasSpaceBeforeElement(slice.getPadding().getStart());
            statistics.withinBrackets += FindSpaceVisitor.hasSpaceBeforeElement(slice.getPadding().getStop());
            statistics.withinBrackets += FindSpaceVisitor.hasSpaceBeforeElement(slice.getPadding().getStep());
            return super.visitSlice(slice, statistics);
        }

        @Override
        public Py.DictLiteral visitDictLiteral(Py.DictLiteral dict, SpacesStatistics statistics) {
            if (!dict.getElements().isEmpty()) {
                int size = dict.getPadding().getElements().getPadding().getElements().size();
                for (int i = 0; i < size; ++i) {
                    JRightPadded exp = (JRightPadded)dict.getPadding().getElements().getPadding().getElements().get(i);
                    if (i == 0) {
                        statistics.withinBraces += FindSpaceVisitor.hasSpaceBeforeElement(exp);
                        continue;
                    }
                    if (i == size - 1) {
                        statistics.withinBraces += FindSpaceVisitor.hasSpace(exp.getAfter());
                        continue;
                    }
                    statistics.otherBeforeComma += FindSpaceVisitor.hasSpace(exp.getAfter());
                    statistics.otherAfterComma += FindSpaceVisitor.hasSpaceBeforeElement(exp);
                }
            }
            return super.visitDictLiteral(dict, statistics);
        }
    }

    private static class SpacesStatistics {
        int beforeParenthesesMethodCall = 0;
        int beforeParenthesesMethodDeclaration = 0;
        int beforeParenthesesLeftBracket = 0;
        int aroundOperatorsAssignment = 0;
        int aroundOperatorsEquality = 0;
        int aroundOperatorsRelational = 0;
        int aroundOperatorsBitwise = 0;
        int aroundOperatorsAdditive = 0;
        int aroundOperatorsMultiplicative = 0;
        int aroundOperatorsShift = 0;
        int aroundOperatorsPower = 0;
        int aroundOperatorsEqInNamedParameter = 0;
        int aroundOperatorsEqInKeywordArgument = 0;
        int withinBrackets = 0;
        int withinMethodDeclarationParentheses = 0;
        int withinEmptyMethodDeclarationParentheses = 0;
        int withinMethodCallParentheses = 0;
        int withinEmptyMethodCallParentheses = 0;
        int withinBraces = 0;
        int otherBeforeComma = 0;
        int otherAfterComma = 0;
        int otherBeforeForSemicolon = 0;
        int otherBeforeColon = 0;
        int otherAfterColon = 0;
        int otherBeforeBackslash = 0;
        int otherBeforeHash = 0;
        int otherAfterHash = 0;

        private SpacesStatistics() {
        }

        private static Boolean determineStyleValue(int count, Boolean defaultValue) {
            if (count > 0) {
                return true;
            }
            if (count < 0) {
                return false;
            }
            return defaultValue;
        }

        public SpacesStyle getStyle() {
            SpacesStyle defaults = IntelliJ.spaces();
            return defaults.withBeforeParentheses(defaults.getBeforeParentheses().withMethodCall(SpacesStatistics.determineStyleValue(this.beforeParenthesesMethodCall, defaults.getBeforeParentheses().getMethodCall())).withMethodDeclaration(SpacesStatistics.determineStyleValue(this.beforeParenthesesMethodDeclaration, defaults.getBeforeParentheses().getMethodDeclaration())).withLeftBracket(SpacesStatistics.determineStyleValue(this.beforeParenthesesLeftBracket, defaults.getBeforeParentheses().getLeftBracket()))).withAroundOperators(defaults.getAroundOperators().withAssignment(SpacesStatistics.determineStyleValue(this.aroundOperatorsAssignment, defaults.getAroundOperators().getAssignment())).withEquality(SpacesStatistics.determineStyleValue(this.aroundOperatorsEquality, defaults.getAroundOperators().getEquality())).withRelational(SpacesStatistics.determineStyleValue(this.aroundOperatorsRelational, defaults.getAroundOperators().getRelational())).withBitwise(SpacesStatistics.determineStyleValue(this.aroundOperatorsBitwise, defaults.getAroundOperators().getBitwise())).withAdditive(SpacesStatistics.determineStyleValue(this.aroundOperatorsAdditive, defaults.getAroundOperators().getAdditive())).withMultiplicative(SpacesStatistics.determineStyleValue(this.aroundOperatorsMultiplicative, defaults.getAroundOperators().getMultiplicative())).withShift(SpacesStatistics.determineStyleValue(this.aroundOperatorsShift, defaults.getAroundOperators().getShift())).withPower(SpacesStatistics.determineStyleValue(this.aroundOperatorsPower, defaults.getAroundOperators().getPower())).withEqInNamedParameter(SpacesStatistics.determineStyleValue(this.aroundOperatorsEqInNamedParameter, defaults.getAroundOperators().getEqInNamedParameter())).withEqInKeywordArgument(SpacesStatistics.determineStyleValue(this.aroundOperatorsEqInKeywordArgument, defaults.getAroundOperators().getEqInKeywordArgument()))).withWithin(defaults.getWithin().withBrackets(SpacesStatistics.determineStyleValue(this.withinBrackets, defaults.getWithin().getBrackets())).withMethodDeclarationParentheses(SpacesStatistics.determineStyleValue(this.withinMethodDeclarationParentheses, defaults.getWithin().getMethodDeclarationParentheses())).withEmptyMethodDeclarationParentheses(SpacesStatistics.determineStyleValue(this.withinEmptyMethodDeclarationParentheses, defaults.getWithin().getEmptyMethodDeclarationParentheses())).withMethodCallParentheses(SpacesStatistics.determineStyleValue(this.withinMethodCallParentheses, defaults.getWithin().getMethodCallParentheses())).withEmptyMethodCallParentheses(SpacesStatistics.determineStyleValue(this.withinEmptyMethodCallParentheses, defaults.getWithin().getEmptyMethodCallParentheses())).withBraces(SpacesStatistics.determineStyleValue(this.withinBraces, defaults.getWithin().getBraces()))).withOther(defaults.getOther().withBeforeComma(SpacesStatistics.determineStyleValue(this.otherBeforeComma, defaults.getOther().getBeforeComma())).withAfterComma(SpacesStatistics.determineStyleValue(this.otherAfterComma, defaults.getOther().getAfterComma())).withBeforeForSemicolon(SpacesStatistics.determineStyleValue(this.otherBeforeForSemicolon, defaults.getOther().getBeforeForSemicolon())).withBeforeColon(SpacesStatistics.determineStyleValue(this.otherBeforeColon, defaults.getOther().getBeforeColon())).withAfterColon(SpacesStatistics.determineStyleValue(this.otherAfterColon, defaults.getOther().getAfterColon())).withBeforeBackslash(SpacesStatistics.determineStyleValue(this.otherBeforeBackslash, defaults.getOther().getBeforeBackslash())).withBeforeHash(SpacesStatistics.determineStyleValue(this.otherBeforeHash, defaults.getOther().getBeforeHash())).withAfterHash(SpacesStatistics.determineStyleValue(this.otherAfterHash, defaults.getOther().getAfterHash())));
        }
    }

    private static class IndentStatistics {
        private final Map<Integer, Integer> countsByIndentSize = new HashMap<Integer, Integer>();

        private IndentStatistics() {
        }

        private <T> T keyWithHighestCount(Map<T, Integer> counts) {
            int max = Collections.max(counts.values());
            return (T)counts.entrySet().stream().filter(entry -> (Integer)entry.getValue() == max).findFirst().get().getKey();
        }

        public TabsAndIndentsStyle getTabsAndIndentsStyle() {
            if (this.countsByIndentSize.isEmpty()) {
                return IntelliJ.tabsAndIndents();
            }
            return IntelliJ.tabsAndIndents().withIndentSize(this.keyWithHighestCount(this.countsByIndentSize));
        }
    }

    private static class FindIndentVisitor
    extends PythonIsoVisitor<IndentStatistics> {
        private int currentBlockIndent = 0;

        private FindIndentVisitor() {
        }

        private int countSpaces(String s) {
            int withoutSpaces = s.replaceAll(" ", "").length();
            return s.length() - withoutSpaces;
        }

        @Override
        public J.Block visitBlock(J.Block block, IndentStatistics indentStatistics) {
            int blockIndentBeforeThisBlock = this.currentBlockIndent;
            int currentBlockIndentSize = 0;
            if (!block.getStatements().isEmpty()) {
                this.currentBlockIndent = this.countSpaces(((Statement)block.getStatements().get(0)).getPrefix().getWhitespace());
                currentBlockIndentSize = this.currentBlockIndent - blockIndentBeforeThisBlock;
            }
            for (Statement s : block.getStatements()) {
                int spaceCount = this.countSpaces(s.getPrefix().getWhitespace());
                int relativeIndentSize = spaceCount - this.currentBlockIndent;
                int classifyAsIndentSize = relativeIndentSize + currentBlockIndentSize;
                indentStatistics.countsByIndentSize.put(classifyAsIndentSize, indentStatistics.countsByIndentSize.getOrDefault(classifyAsIndentSize, 0) + 1);
            }
            J.Block ret = super.visitBlock(block, indentStatistics);
            this.currentBlockIndent = blockIndentBeforeThisBlock;
            return ret;
        }
    }
}

