/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote.javascript;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.remote.AbstractRemotingServerEngine;

public class JavaScriptRemotingServerEngine
extends AbstractRemotingServerEngine {
    @Generated
    private static final Logger log = Logger.getLogger(JavaScriptRemotingServerEngine.class.getName());
    public static final String REWRITE_SERVER_JS_NAME = "node_modules/@openrewrite/rewrite-remote/dist/server.js";
    public static final int DEFAULT_DEBUG_PORT = 54323;
    Config config;

    public static JavaScriptRemotingServerEngine create(Path extractedPackageJsonDir) {
        return JavaScriptRemotingServerEngine.create(Config.builder().extractedPackageJsonDir(extractedPackageJsonDir).build());
    }

    public static JavaScriptRemotingServerEngine create(Config config) {
        JavaScriptRemotingServerEngine.installExecutable(config.npmPackageJsonResource, config.extractedPackageJsonDir.toFile());
        return new JavaScriptRemotingServerEngine(config);
    }

    private JavaScriptRemotingServerEngine(Config config) {
        super(new InetSocketAddress(InetAddress.getLoopbackAddress(), config.port), Duration.ofMillis(config.timeoutInMilliseconds));
        this.config = config;
    }

    protected ProcessBuilder configureProcess(ProcessBuilder processBuilder) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.config.nodeExecutable);
        command.add(this.config.jsServerFileName);
        command.add(String.valueOf(this.config.port));
        return processBuilder.command(command).directory(this.config.extractedPackageJsonDir.toFile());
    }

    private static void installExecutable(String npmPackageJsonResourceName, File installationDir) throws IOException, InterruptedException {
        if (!Files.isDirectory(installationDir.toPath(), new LinkOption[0])) {
            installationDir.mkdirs();
        }
        JavaScriptRemotingServerEngine.exportResource(npmPackageJsonResourceName, installationDir);
        ArrayList<String> command = new ArrayList<String>(Arrays.asList("npm", "install", "--no-package-lock"));
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        Process process = processBuilder.directory(installationDir).start();
        int exitCode = process.waitFor();
    }

    private static void exportResource(String resourceName, File outputDir) throws IOException {
        try (InputStream stream = JavaScriptRemotingServerEngine.class.getClassLoader().getResourceAsStream(resourceName);){
            if (stream == null) {
                throw new IllegalArgumentException("Cannot get resource \"" + resourceName + "\" from Jar file.");
            }
            byte[] buffer = new byte[4096];
            try (OutputStream resStreamOut = Files.newOutputStream(Paths.get(outputDir.getPath(), Paths.get(resourceName, new String[0]).getFileName().toString()), new OpenOption[0]);){
                int readBytes;
                while ((readBytes = stream.read(buffer)) > 0) {
                    resStreamOut.write(buffer, 0, readBytes);
                }
                resStreamOut.flush();
            }
        }
    }

    public String getLanguageName() {
        return "JavaScript";
    }

    public static class Config {
        int port;
        int timeoutInMilliseconds;
        @Nullable String logFilePath;
        @Nullable String nodePackagesFolder;
        String nodeExecutable;
        String npmPackageJsonResource;
        Path extractedPackageJsonDir;
        String jsServerFileName;

        @Generated
        private static int $default$port() {
            return 54323;
        }

        @Generated
        private static int $default$timeoutInMilliseconds() {
            return (int)Duration.ofHours(1L).toMillis();
        }

        @Generated
        private static String $default$logFilePath() {
            return null;
        }

        @Generated
        private static String $default$nodePackagesFolder() {
            return null;
        }

        @Generated
        private static String $default$nodeExecutable() {
            return "node";
        }

        @Generated
        private static String $default$npmPackageJsonResource() {
            return "META-INF/package.json";
        }

        @Generated
        private static String $default$jsServerFileName() {
            return JavaScriptRemotingServerEngine.REWRITE_SERVER_JS_NAME;
        }

        @Generated
        Config(int port, int timeoutInMilliseconds, @Nullable String logFilePath, @Nullable String nodePackagesFolder, String nodeExecutable, String npmPackageJsonResource, Path extractedPackageJsonDir, String jsServerFileName) {
            this.port = port;
            this.timeoutInMilliseconds = timeoutInMilliseconds;
            this.logFilePath = logFilePath;
            this.nodePackagesFolder = nodePackagesFolder;
            this.nodeExecutable = nodeExecutable;
            this.npmPackageJsonResource = npmPackageJsonResource;
            this.extractedPackageJsonDir = extractedPackageJsonDir;
            this.jsServerFileName = jsServerFileName;
        }

        @Generated
        public static ConfigBuilder builder() {
            return new ConfigBuilder();
        }

        @Generated
        public static class ConfigBuilder {
            @Generated
            private boolean port$set;
            @Generated
            private int port$value;
            @Generated
            private boolean timeoutInMilliseconds$set;
            @Generated
            private int timeoutInMilliseconds$value;
            @Generated
            private boolean logFilePath$set;
            @Generated
            private String logFilePath$value;
            @Generated
            private boolean nodePackagesFolder$set;
            @Generated
            private String nodePackagesFolder$value;
            @Generated
            private boolean nodeExecutable$set;
            @Generated
            private String nodeExecutable$value;
            @Generated
            private boolean npmPackageJsonResource$set;
            @Generated
            private String npmPackageJsonResource$value;
            @Generated
            private Path extractedPackageJsonDir;
            @Generated
            private boolean jsServerFileName$set;
            @Generated
            private String jsServerFileName$value;

            @Generated
            ConfigBuilder() {
            }

            @Generated
            public ConfigBuilder port(int port) {
                this.port$value = port;
                this.port$set = true;
                return this;
            }

            @Generated
            public ConfigBuilder timeoutInMilliseconds(int timeoutInMilliseconds) {
                this.timeoutInMilliseconds$value = timeoutInMilliseconds;
                this.timeoutInMilliseconds$set = true;
                return this;
            }

            @Generated
            public ConfigBuilder logFilePath(@Nullable String logFilePath) {
                this.logFilePath$value = logFilePath;
                this.logFilePath$set = true;
                return this;
            }

            @Generated
            public ConfigBuilder nodePackagesFolder(@Nullable String nodePackagesFolder) {
                this.nodePackagesFolder$value = nodePackagesFolder;
                this.nodePackagesFolder$set = true;
                return this;
            }

            @Generated
            public ConfigBuilder nodeExecutable(String nodeExecutable) {
                this.nodeExecutable$value = nodeExecutable;
                this.nodeExecutable$set = true;
                return this;
            }

            @Generated
            public ConfigBuilder npmPackageJsonResource(String npmPackageJsonResource) {
                this.npmPackageJsonResource$value = npmPackageJsonResource;
                this.npmPackageJsonResource$set = true;
                return this;
            }

            @Generated
            public ConfigBuilder extractedPackageJsonDir(Path extractedPackageJsonDir) {
                this.extractedPackageJsonDir = extractedPackageJsonDir;
                return this;
            }

            @Generated
            public ConfigBuilder jsServerFileName(String jsServerFileName) {
                this.jsServerFileName$value = jsServerFileName;
                this.jsServerFileName$set = true;
                return this;
            }

            @Generated
            public Config build() {
                int port$value = this.port$value;
                if (!this.port$set) {
                    port$value = Config.$default$port();
                }
                int timeoutInMilliseconds$value = this.timeoutInMilliseconds$value;
                if (!this.timeoutInMilliseconds$set) {
                    timeoutInMilliseconds$value = Config.$default$timeoutInMilliseconds();
                }
                String logFilePath$value = this.logFilePath$value;
                if (!this.logFilePath$set) {
                    logFilePath$value = Config.$default$logFilePath();
                }
                String nodePackagesFolder$value = this.nodePackagesFolder$value;
                if (!this.nodePackagesFolder$set) {
                    nodePackagesFolder$value = Config.$default$nodePackagesFolder();
                }
                String nodeExecutable$value = this.nodeExecutable$value;
                if (!this.nodeExecutable$set) {
                    nodeExecutable$value = Config.$default$nodeExecutable();
                }
                String npmPackageJsonResource$value = this.npmPackageJsonResource$value;
                if (!this.npmPackageJsonResource$set) {
                    npmPackageJsonResource$value = Config.$default$npmPackageJsonResource();
                }
                String jsServerFileName$value = this.jsServerFileName$value;
                if (!this.jsServerFileName$set) {
                    jsServerFileName$value = Config.$default$jsServerFileName();
                }
                return new Config(port$value, timeoutInMilliseconds$value, logFilePath$value, nodePackagesFolder$value, nodeExecutable$value, npmPackageJsonResource$value, this.extractedPackageJsonDir, jsServerFileName$value);
            }

            @Generated
            public String toString() {
                return "JavaScriptRemotingServerEngine.Config.ConfigBuilder(port$value=" + this.port$value + ", timeoutInMilliseconds$value=" + this.timeoutInMilliseconds$value + ", logFilePath$value=" + this.logFilePath$value + ", nodePackagesFolder$value=" + this.nodePackagesFolder$value + ", nodeExecutable$value=" + this.nodeExecutable$value + ", npmPackageJsonResource$value=" + this.npmPackageJsonResource$value + ", extractedPackageJsonDir=" + this.extractedPackageJsonDir + ", jsServerFileName$value=" + this.jsServerFileName$value + ")";
            }
        }
    }
}

