/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.Parser;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.RefactorVisitorTest;
import org.openrewrite.SourceFile;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.AddImportTest;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\bf\u0018\u00002\u00020\u0001:\u0001\u0016J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0017"}, d2={"Lorg/openrewrite/java/AddImportTest;", "Lorg/openrewrite/RefactorVisitorTest;", "addMultipleImports", "", "jp", "Lorg/openrewrite/java/JavaParser;", "addNamedImport", "addNamedImportIfStarStaticImportExists", "addNamedStaticImport", "addNamedStaticImportWhenReferenced", "addStaticWildcardImportWhenReferenced", "doNotAddImportIfAlreadyExists", "doNotAddImportIfCoveredByStarImport", "doNotAddImportIfNotReferenced", "doNotAddNamedStaticImportIfNotReferenced", "doNotAddWildcardImportIfNotReferenced", "dontAddImportForPrimitive", "dontAddImportWhenClassHasNoPackage", "dontAddStaticWildcardImportIfNotReferenced", "importsAddedInAlphabeticalOrder", "lastImportWhenFirstClassDeclarationHasJavadoc", "namedImportAddedAfterPackageDeclaration", "FixEmptyListMethodType", "rewrite-test"})
public interface AddImportTest
extends RefactorVisitorTest {
    @Test
    public void addMultipleImports(@NotNull JavaParser var1);

    @Test
    public void addNamedImport(@NotNull JavaParser var1);

    @Test
    public void doNotAddImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void doNotAddWildcardImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void lastImportWhenFirstClassDeclarationHasJavadoc(@NotNull JavaParser var1);

    @Test
    public void namedImportAddedAfterPackageDeclaration(@NotNull JavaParser var1);

    @Test
    public void importsAddedInAlphabeticalOrder(@NotNull JavaParser var1);

    @Test
    public void doNotAddImportIfAlreadyExists(@NotNull JavaParser var1);

    @Test
    public void doNotAddImportIfCoveredByStarImport(@NotNull JavaParser var1);

    @Test
    public void dontAddImportWhenClassHasNoPackage(@NotNull JavaParser var1);

    @Test
    public void dontAddImportForPrimitive(@NotNull JavaParser var1);

    @Test
    public void addNamedImportIfStarStaticImportExists(@NotNull JavaParser var1);

    @Test
    public void addNamedStaticImport(@NotNull JavaParser var1);

    @Test
    public void dontAddStaticWildcardImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void addNamedStaticImportWhenReferenced(@NotNull JavaParser var1);

    @Test
    public void doNotAddNamedStaticImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void addStaticWildcardImportWhenReferenced(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/openrewrite/java/AddImportTest$FixEmptyListMethodType;", "Lorg/openrewrite/java/JavaIsoRefactorVisitor;", "()V", "visitMethodInvocation", "Lorg/openrewrite/java/tree/J$MethodInvocation;", "method", "rewrite-test"})
    private static final class FixEmptyListMethodType
    extends JavaIsoRefactorVisitor {
        @NotNull
        public J.MethodInvocation visitMethodInvocation(@Nullable J.MethodInvocation method) {
            J.MethodInvocation methodInvocation = super.visitMethodInvocation(method);
            Intrinsics.checkNotNullExpressionValue((Object)methodInvocation, (String)"super.visitMethodInvocation(method)");
            J.MethodInvocation original = methodInvocation;
            J.Ident ident = original.getName();
            Intrinsics.checkNotNullExpressionValue((Object)ident, (String)"original.name");
            if (Intrinsics.areEqual((Object)ident.getSimpleName(), (Object)"emptyList")) {
                JavaType.Method.Signature signature = new JavaType.Method.Signature((JavaType)JavaType.Class.build((String)"java.util.List"), CollectionsKt.emptyList());
                JavaType.Method method2 = JavaType.Method.build((JavaType.FullyQualified)((JavaType.FullyQualified)JavaType.Class.build((String)"java.util.Collections")), (String)"emptyList", (JavaType.Method.Signature)signature, (JavaType.Method.Signature)signature, Collections.emptyList(), Stream.of(Flag.Public, Flag.Static).collect(Collectors.toSet()));
                Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"JavaType.Method.build(\n \u2026lect(Collectors.toSet()))");
                JavaType.Method emptyListMethod = method2;
                J.MethodInvocation methodInvocation2 = original.withType((JavaType)emptyListMethod);
                Intrinsics.checkNotNullExpressionValue((Object)methodInvocation2, (String)"original.withType(emptyListMethod)");
                return methodInvocation2;
            }
            return original;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void addMultipleImports(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            AddImport $this$apply;
            Object[] objectArray;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport addImport = new AddImport();
            boolean bl = false;
            boolean bl2 = false;
            AddImport addImport2 = addImport;
            int n = 0;
            Object[] objectArray2 = objectArray = new AddImport[2];
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            $this$apply.setOnlyIfReferenced(false);
            Unit unit = Unit.INSTANCE;
            objectArray[n] = addImport;
            addImport = new AddImport();
            bl = false;
            bl2 = false;
            $this$apply = addImport;
            n = 1;
            objectArray = objectArray2;
            boolean bl4 = false;
            $this$apply.setType("java.util.Set");
            $this$apply.setOnlyIfReferenced(false);
            unit = Unit.INSTANCE;
            objectArray[n] = addImport;
            RefactorVisitorTest.DefaultImpls.assertRefactored$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object[])objectArray2), null, null, null, "\n                class A {}\n            ", "\n                import java.util.List;\n                import java.util.Set;\n    \n                class A {}\n            ", 28, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void addNamedImport(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport addImport = new AddImport();
            boolean bl = false;
            boolean bl2 = false;
            AddImport addImport2 = addImport;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            $this$apply.setOnlyIfReferenced(false);
            Unit unit = Unit.INSTANCE;
            RefactorVisitorTest.DefaultImpls.assertRefactored$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object)addImport), null, null, null, "class A {}", "\n                import java.util.List;\n                \n                class A {}\n            ", 28, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void doNotAddImportIfNotReferenced(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport addImport = new AddImport();
            boolean bl = false;
            boolean bl2 = false;
            AddImport addImport2 = addImport;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            $this$apply.setOnlyIfReferenced(true);
            Unit unit = Unit.INSTANCE;
            RefactorVisitorTest.DefaultImpls.assertUnchanged$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object)addImport), null, null, null, "\n                package a;\n                \n                class A {}\n            ", 28, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void doNotAddWildcardImportIfNotReferenced(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport addImport = new AddImport();
            boolean bl = false;
            boolean bl2 = false;
            AddImport addImport2 = addImport;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("java.util.*");
            $this$apply.setOnlyIfReferenced(true);
            Unit unit = Unit.INSTANCE;
            RefactorVisitorTest.DefaultImpls.assertUnchanged$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object)addImport), null, null, null, "\n                package a;\n                \n                class A {}\n            ", 28, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void lastImportWhenFirstClassDeclarationHasJavadoc(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport addImport = new AddImport();
            boolean bl = false;
            boolean bl2 = false;
            AddImport addImport2 = addImport;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("java.util.Collections");
            $this$apply.setStaticMethod("*");
            $this$apply.setOnlyIfReferenced(false);
            Unit unit = Unit.INSTANCE;
            RefactorVisitorTest.DefaultImpls.assertRefactored$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object)addImport), null, null, null, "\n                import java.util.List;\n                \n                /**\n                 * My type\n                 */\n                class A {}\n            ", "\n                import java.util.List;\n                \n                import static java.util.Collections.*;\n                \n                /**\n                 * My type\n                 */\n                class A {}\n            ", 28, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void namedImportAddedAfterPackageDeclaration(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport addImport = new AddImport();
            boolean bl = false;
            boolean bl2 = false;
            AddImport addImport2 = addImport;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            $this$apply.setOnlyIfReferenced(false);
            Unit unit = Unit.INSTANCE;
            RefactorVisitorTest.DefaultImpls.assertRefactored$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object)addImport), null, null, null, "\n                package a;\n                class A {}\n            ", "\n                package a;\n                \n                import java.util.List;\n                \n                class A {}\n            ", 28, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void importsAddedInAlphabeticalOrder(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            String string;
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List otherPackages = CollectionsKt.listOf((Object[])new String[]{"c", "c.c", "c.c.c"});
            Iterable $this$mapIndexed$iv = otherPackages;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i2;
                void pkg;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                string = (String)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string2 = "package " + (String)pkg + ";\npublic class C" + (int)i2 + " {}";
                collection.add(string2);
            }
            List otherImports = (List)destination$iv$iv;
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])new Pair[]{TuplesKt.to((Object)"b", (Object)0), TuplesKt.to((Object)"c.b", (Object)1), TuplesKt.to((Object)"c.c.b", (Object)2)});
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$apply;
                void pkg;
                String string3;
                Object object;
                void $this$mapIndexedTo$iv$iv2;
                Object item$iv$iv;
                Pair it = (Pair)element$iv;
                boolean bl = false;
                Pair pair = it;
                item$iv$iv = (String)pair.component1();
                int order = ((Number)pair.component2()).intValue();
                Iterable $this$mapIndexed$iv2 = otherPackages;
                boolean $i$f$mapIndexed2 = false;
                Iterable i2 = $this$mapIndexed$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
                boolean $i$f$mapIndexedTo2 = false;
                int index$iv$iv2 = 0;
                for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv2) {
                    void i3;
                    void otherPkg;
                    int n = index$iv$iv2++;
                    boolean bl3 = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string4 = (String)item$iv$iv2;
                    int n3 = n;
                    object = destination$iv$iv2;
                    boolean bl4 = false;
                    string3 = (String)otherPkg + ".C" + (int)i3;
                    object.add(string3);
                }
                List expectedImports = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
                expectedImports.add(order, (String)pkg + ".B");
                RefactorVisitorTest refactorVisitorTest = $this;
                Parser parser = (Parser)jp;
                SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                Collection $this$toTypedArray$iv = otherImports;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                spreadBuilder.addSpread((Object)stringArray);
                spreadBuilder.add((Object)("\n                            package " + (String)pkg + ";\n                            public class B {}\n                        "));
                Object object2 = new AddImport();
                boolean bl5 = false;
                boolean bl6 = false;
                destination$iv$iv2 = object2;
                Iterable iterable2 = null;
                Iterable iterable3 = null;
                List list = CollectionsKt.listOf((Object[])((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()])));
                string3 = parser;
                object = refactorVisitorTest;
                boolean bl7 = false;
                $this$apply.setType((String)pkg + ".B");
                $this$apply.setOnlyIfReferenced(false);
                Unit unit = Unit.INSTANCE;
                Iterable iterable4 = CollectionsKt.listOf((Object)object2);
                object2 = "package a;\n\n" + CollectionsKt.joinToString$default((Iterable)expectedImports, (CharSequence)"\n", null, null, (int)0, null, (Function1)importsAddedInAlphabeticalOrder.1.2.INSTANCE, (int)30, null) + "\n\nclass A {}";
                string = "\n                        package a;\n            \n                        import c.C0;\n                        import c.c.C1;\n                        import c.c.c.C2;\n            \n                        class A {}\n                    ";
                Iterable iterable5 = iterable4;
                Iterable iterable6 = iterable2;
                Iterable iterable7 = iterable3;
                List list2 = list;
                RefactorVisitorTest.DefaultImpls.assertRefactored$default((RefactorVisitorTest)object, (Parser)string3, iterable5, iterable7, iterable6, list2, string, (String)object2, 12, null);
                jp.reset();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void doNotAddImportIfAlreadyExists(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport addImport = new AddImport();
            boolean bl = false;
            boolean bl2 = false;
            AddImport addImport2 = addImport;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            $this$apply.setOnlyIfReferenced(false);
            Unit unit = Unit.INSTANCE;
            RefactorVisitorTest.DefaultImpls.assertUnchanged$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object)addImport), null, null, null, "\n                package a;\n                \n                import java.util.List;\n                class A {}\n            ", 28, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void doNotAddImportIfCoveredByStarImport(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport addImport = new AddImport();
            boolean bl = false;
            boolean bl2 = false;
            AddImport addImport2 = addImport;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            $this$apply.setOnlyIfReferenced(false);
            Unit unit = Unit.INSTANCE;
            RefactorVisitorTest.DefaultImpls.assertUnchanged$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object)addImport), null, null, null, "\n                package a;\n                \n                import java.util.*;\n                class A {}\n            ", 28, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void dontAddImportWhenClassHasNoPackage(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport addImport = new AddImport();
            boolean bl = false;
            boolean bl2 = false;
            AddImport addImport2 = addImport;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("C");
            $this$apply.setOnlyIfReferenced(false);
            Unit unit = Unit.INSTANCE;
            RefactorVisitorTest.DefaultImpls.assertUnchanged$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object)addImport), null, null, null, "class A {}", 28, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void dontAddImportForPrimitive(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport addImport = new AddImport();
            boolean bl = false;
            boolean bl2 = false;
            AddImport addImport2 = addImport;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("int");
            Unit unit = Unit.INSTANCE;
            RefactorVisitorTest.DefaultImpls.assertUnchanged$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object)addImport), null, null, null, "class A {}", 28, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void addNamedImportIfStarStaticImportExists(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport addImport = new AddImport();
            boolean bl = false;
            boolean bl2 = false;
            AddImport addImport2 = addImport;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            $this$apply.setOnlyIfReferenced(false);
            Unit unit = Unit.INSTANCE;
            RefactorVisitorTest.DefaultImpls.assertRefactored$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object)addImport), null, null, null, "\n                package a;\n                \n                import static java.util.List.*;\n                class A {}\n            ", "\n                package a;\n                \n                import java.util.List;\n                \n                import static java.util.List.*;\n                \n                class A {}\n            ", 28, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void addNamedStaticImport(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport addImport = new AddImport();
            boolean bl = false;
            boolean bl2 = false;
            AddImport addImport2 = addImport;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("java.util.Collections");
            $this$apply.setStaticMethod("emptyList");
            $this$apply.setOnlyIfReferenced(false);
            Unit unit = Unit.INSTANCE;
            RefactorVisitorTest.DefaultImpls.assertRefactored$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object)addImport), null, null, null, "\n                import java.util.*;\n                class A {}\n            ", "\n                import java.util.*;\n                \n                import static java.util.Collections.emptyList;\n                \n                class A {}\n            ", 28, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void dontAddStaticWildcardImportIfNotReferenced(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport addImport = new AddImport();
            boolean bl = false;
            boolean bl2 = false;
            AddImport addImport2 = addImport;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("java.util.Collections");
            $this$apply.setStaticMethod("*");
            $this$apply.setOnlyIfReferenced(true);
            Unit unit = Unit.INSTANCE;
            RefactorVisitorTest.DefaultImpls.assertUnchanged$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object)addImport), null, null, null, "\n                package a;\n                \n                class A {}\n            ", 28, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void addNamedStaticImportWhenReferenced(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object[] objectArray = new JavaIsoRefactorVisitor[2];
            objectArray[0] = new FixEmptyListMethodType();
            AddImport addImport = new AddImport();
            boolean bl = false;
            boolean bl2 = false;
            AddImport addImport2 = addImport;
            int n = 1;
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = objectArray;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("java.util.Collections");
            $this$apply.setStaticMethod("emptyList");
            $this$apply.setOnlyIfReferenced(true);
            Unit unit = Unit.INSTANCE;
            objectArray2[n] = (JavaIsoRefactorVisitor)addImport;
            RefactorVisitorTest.DefaultImpls.assertRefactored$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object[])objectArray3), null, null, null, "\n                package a;\n                \n                import java.util.List;\n                \n                class A {\n                    public A() {\n                        List<String> list = emptyList();\n                    }\n                }\n            ", "\n                package a;\n                \n                import java.util.List;\n                \n                import static java.util.Collections.emptyList;\n                \n                class A {\n                    public A() {\n                        List<String> list = emptyList();\n                    }\n                }\n            ", 28, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void doNotAddNamedStaticImportIfNotReferenced(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport addImport = new AddImport();
            boolean bl = false;
            boolean bl2 = false;
            AddImport addImport2 = addImport;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("java.util.Collections");
            $this$apply.setStaticMethod("emptyList");
            $this$apply.setOnlyIfReferenced(true);
            Unit unit = Unit.INSTANCE;
            RefactorVisitorTest.DefaultImpls.assertUnchanged$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object)addImport), null, null, null, "\n                package a;\n                \n                class A {}\n            ", 28, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void addStaticWildcardImportWhenReferenced(@NotNull AddImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object[] objectArray = new JavaIsoRefactorVisitor[2];
            objectArray[0] = new FixEmptyListMethodType();
            AddImport addImport = new AddImport();
            boolean bl = false;
            boolean bl2 = false;
            AddImport addImport2 = addImport;
            int n = 1;
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = objectArray;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("java.util.Collections");
            $this$apply.setStaticMethod("*");
            $this$apply.setOnlyIfReferenced(true);
            Unit unit = Unit.INSTANCE;
            objectArray2[n] = (JavaIsoRefactorVisitor)addImport;
            RefactorVisitorTest.DefaultImpls.assertRefactored$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object[])objectArray3), null, null, null, "\n                package a;\n                \n                import java.util.List;\n                \n                class A {\n                    public A() {\n                        List<String> list = emptyList();\n                    }\n                }\n            ", "\n                package a;\n                \n                import java.util.List;\n                \n                import static java.util.Collections.*;\n                \n                class A {\n                    public A() {\n                        List<String> list = emptyList();\n                    }\n                }\n            ", 28, null);
        }

        @NotNull
        public static Iterable<RefactorVisitor<?>> getVisitors(@NotNull AddImportTest $this) {
            return RefactorVisitorTest.DefaultImpls.getVisitors($this);
        }

        public static <S extends SourceFile> void assertRefactored(@NotNull AddImportTest $this, @NotNull Parser<S> parser, @NotNull Iterable<? extends RefactorVisitor<?>> visitors, @NotNull Iterable<? extends Function1<? super S, ? extends RefactorVisitor<? super S>>> visitorsMapped, @NotNull Iterable<? extends Function1<? super S, ? extends Iterable<? extends RefactorVisitor<? super S>>>> visitorsMappedToMany, @NotNull List<String> dependencies, @NotNull String before, @NotNull String after) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter(visitors, (String)"visitors");
            Intrinsics.checkNotNullParameter(visitorsMapped, (String)"visitorsMapped");
            Intrinsics.checkNotNullParameter(visitorsMappedToMany, (String)"visitorsMappedToMany");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RefactorVisitorTest.DefaultImpls.assertRefactored((RefactorVisitorTest)$this, parser, visitors, visitorsMapped, visitorsMappedToMany, dependencies, before, after);
        }

        public static <S extends SourceFile> void assertRefactored(@NotNull AddImportTest $this, @NotNull Parser<S> parser, @NotNull Iterable<? extends RefactorVisitor<?>> visitors, @NotNull Iterable<? extends Function1<? super S, ? extends RefactorVisitor<? super S>>> visitorsMapped, @NotNull Iterable<? extends Function1<? super S, ? extends Iterable<? extends RefactorVisitor<? super S>>>> visitorsMappedToMany, @NotNull List<String> dependencies, @NotNull String before, @NotNull Function0<String> after) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter(visitors, (String)"visitors");
            Intrinsics.checkNotNullParameter(visitorsMapped, (String)"visitorsMapped");
            Intrinsics.checkNotNullParameter(visitorsMappedToMany, (String)"visitorsMappedToMany");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter(after, (String)"after");
            RefactorVisitorTest.DefaultImpls.assertRefactored((RefactorVisitorTest)$this, parser, visitors, visitorsMapped, visitorsMappedToMany, dependencies, before, after);
        }

        public static <S extends SourceFile> void assertRefactored(@NotNull AddImportTest $this, @NotNull Parser<S> parser, @NotNull Iterable<? extends RefactorVisitor<?>> visitors, @NotNull Iterable<? extends Function1<? super S, ? extends RefactorVisitor<? super S>>> visitorsMapped, @NotNull Iterable<? extends Function1<? super S, ? extends Iterable<? extends RefactorVisitor<? super S>>>> visitorsMappedToMany, @NotNull List<? extends File> dependencies, @NotNull File before, @NotNull String after) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter(visitors, (String)"visitors");
            Intrinsics.checkNotNullParameter(visitorsMapped, (String)"visitorsMapped");
            Intrinsics.checkNotNullParameter(visitorsMappedToMany, (String)"visitorsMappedToMany");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RefactorVisitorTest.DefaultImpls.assertRefactored((RefactorVisitorTest)$this, parser, visitors, visitorsMapped, visitorsMappedToMany, dependencies, before, after);
        }

        public static <S extends SourceFile> void assertUnchanged(@NotNull AddImportTest $this, @NotNull Parser<S> parser, @NotNull Iterable<? extends RefactorVisitor<?>> visitors, @NotNull Iterable<? extends Function1<? super S, ? extends RefactorVisitor<? super S>>> visitorsMapped, @NotNull Iterable<? extends Function1<? super S, ? extends Iterable<? extends RefactorVisitor<? super S>>>> visitorsMappedToMany, @NotNull List<String> dependencies, @NotNull String before) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter(visitors, (String)"visitors");
            Intrinsics.checkNotNullParameter(visitorsMapped, (String)"visitorsMapped");
            Intrinsics.checkNotNullParameter(visitorsMappedToMany, (String)"visitorsMappedToMany");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            RefactorVisitorTest.DefaultImpls.assertUnchanged((RefactorVisitorTest)$this, parser, visitors, visitorsMapped, visitorsMappedToMany, dependencies, before);
        }

        public static <S extends SourceFile> void assertUnchanged(@NotNull AddImportTest $this, @NotNull Parser<S> parser, @NotNull Iterable<? extends RefactorVisitor<?>> visitors, @NotNull Iterable<? extends Function1<? super S, ? extends RefactorVisitor<? super S>>> visitorsMapped, @NotNull Iterable<? extends Function1<? super S, ? extends Iterable<? extends RefactorVisitor<? super S>>>> visitorsMappedToMany, @NotNull List<? extends File> dependencies, @NotNull File before) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter(visitors, (String)"visitors");
            Intrinsics.checkNotNullParameter(visitorsMapped, (String)"visitorsMapped");
            Intrinsics.checkNotNullParameter(visitorsMappedToMany, (String)"visitorsMappedToMany");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            RefactorVisitorTest.DefaultImpls.assertUnchanged((RefactorVisitorTest)$this, parser, visitors, visitorsMapped, visitorsMappedToMany, dependencies, before);
        }
    }
}

