/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.openrewrite.Change;
import org.openrewrite.Parser;
import org.openrewrite.Refactor;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;

public class Assertions {
    public static <S extends SourceFile> StringSourceFileAssert<S> whenParsedBy(Parser<S> parser, String source) {
        return new StringSourceFileAssert<S>(parser, source);
    }

    public static <S extends SourceFile> PathSourceFileAssert<S> whenParsedBy(Parser<S> parser, Path source) {
        return new PathSourceFileAssert<S>(parser, source);
    }

    public static class RefactoringAssert<S extends SourceFile> {
        private final Refactor refactor = new Refactor(true);
        private final S primarySource;
        private final List<S> sources;

        public RefactoringAssert(S primarySource, List<S> sources) {
            this.primarySource = primarySource;
            this.sources = sources;
        }

        public RefactoringAssert<S> whenVisitedBy(RefactorVisitor<?> visitor) {
            this.refactor.visit(new RefactorVisitor[]{visitor});
            return this;
        }

        public RefactoringAssert<S> whenVisitedBy(Iterable<RefactorVisitor<?>> visitors) {
            this.refactor.visit(visitors);
            return this;
        }

        public RefactoringAssert<S> whenVisitedByMapped(Function<S, RefactorVisitor<? super S>> visitorFunction) {
            ((ListAssert)org.assertj.core.api.Assertions.assertThat(this.sources).withFailMessage("Expected sources to be provided, but none were.", new Object[0])).isNotEmpty();
            return this.whenVisitedBy(visitorFunction.apply((SourceFile)this.sources.iterator().next()));
        }

        public RefactoringAssert<S> whenVisitedByMany(Function<S, Iterable<RefactorVisitor<? super S>>> visitorFunction) {
            ((ListAssert)org.assertj.core.api.Assertions.assertThat(this.sources).withFailMessage("Expected sources to be provided, but none were.", new Object[0])).isNotEmpty();
            visitorFunction.apply((SourceFile)this.sources.iterator().next()).forEach(xva$0 -> this.refactor.visit(new RefactorVisitor[]{xva$0}));
            return this;
        }

        private SourceFile doRefactor() {
            Collection fixes = this.refactor.fix(this.sources);
            ((IterableAssert)org.assertj.core.api.Assertions.assertThat((Iterable)fixes).withFailMessage("Expecting refactoring visitor to make changes to source file, but none were made.", new Object[0])).isNotEmpty();
            return fixes.stream().filter(f -> this.primarySource.equals(f.getOriginal())).findAny().map(Change::getFixed).orElseThrow(() -> new IllegalStateException("unable to find primary source"));
        }

        public RefactoringAssert<S> isRefactoredTo(String expected) {
            return this.isRefactoredTo(expected, (S s) -> {});
        }

        public RefactoringAssert<S> isRefactoredTo(String expected, Consumer<S> conditions) {
            SourceFile fixed = this.doRefactor();
            ((ObjectAssert)org.assertj.core.api.Assertions.assertThat((Object)fixed).withFailMessage("Expecting refactoring visitor to make changes to source file, but none were made.", new Object[0])).isNotNull();
            org.assertj.core.api.Assertions.assertThat((String)fixed.printTrimmed()).isEqualTo(StringUtils.trimIndent((String)expected));
            conditions.accept(fixed);
            return this;
        }

        public RefactoringAssert<S> isRefactoredTo(Supplier<String> expected) {
            return this.isRefactoredTo(expected, (S s) -> {});
        }

        public RefactoringAssert<S> isRefactoredTo(Supplier<String> expected, Consumer<S> conditions) {
            SourceFile fixed = this.doRefactor();
            ((ObjectAssert)org.assertj.core.api.Assertions.assertThat((Object)fixed).withFailMessage("Expecting refactoring visitor to make changes to source file, but none were made.", new Object[0])).isNotNull();
            org.assertj.core.api.Assertions.assertThat((String)fixed.printTrimmed()).isEqualTo(StringUtils.trimIndent((String)expected.get()));
            return this;
        }

        public RefactoringAssert<S> isUnchanged() {
            ArrayList<String> results = new ArrayList<String>();
            for (Change change : this.refactor.fix(this.sources)) {
                if (change.getFixed() != null) {
                    results.add(change.getFixed().printTrimmed());
                    continue;
                }
                assert (change.getOriginal() != null);
                results.add(change.getOriginal().getSourcePath() + " has been DELETED");
            }
            org.assertj.core.api.Assertions.assertThat(results).isEmpty();
            return this;
        }

        public List<S> fixed() {
            return this.refactor.fix(this.sources).stream().map(Change::getFixed).map(s -> s).collect(Collectors.toList());
        }
    }

    public static class PathSourceFileAssert<S extends SourceFile> {
        private final Parser<S> parser;
        private final Path primarySource;
        private final List<Path> sourceFiles = new ArrayList<Path>();
        @Nullable
        private Path relativeTo;

        public PathSourceFileAssert(Parser<S> parser, Path source) {
            this.parser = parser;
            this.primarySource = source;
            this.sourceFiles.add(source);
        }

        public PathSourceFileAssert<S> relativeTo(@Nullable Path relativeTo) {
            this.relativeTo = relativeTo;
            return this;
        }

        public PathSourceFileAssert<S> whichDependsOn(Path ... sources) {
            Collections.addAll(this.sourceFiles, sources);
            return this;
        }

        public RefactoringAssert<S> whenVisitedBy(RefactorVisitor<?> visitor) {
            List sources = this.parser.parse(this.sourceFiles, this.relativeTo);
            return new RefactoringAssert<S>(this.primary(sources), sources).whenVisitedBy(visitor);
        }

        public RefactoringAssert<S> whenVisitedBy(Iterable<RefactorVisitor<?>> visitors) {
            List sources = this.parser.parse(this.sourceFiles, this.relativeTo);
            return new RefactoringAssert<S>(this.primary(sources), sources).whenVisitedBy(visitors);
        }

        public RefactoringAssert<S> whenVisitedByMapped(Function<S, RefactorVisitor<? super S>> visitorFunction) {
            List sources = this.parser.parse(this.sourceFiles, this.relativeTo);
            return new RefactoringAssert<S>(this.primary(sources), sources).whenVisitedByMapped(visitorFunction);
        }

        public RefactoringAssert<S> whenVisitedByMany(Function<S, Iterable<RefactorVisitor<? super S>>> visitorFunction) {
            List sources = this.parser.parse(this.sourceFiles, this.relativeTo);
            return new RefactoringAssert<S>(this.primary(sources), sources).whenVisitedByMany(visitorFunction);
        }

        private S primary(List<S> sources) {
            return (S)sources.stream().filter(s -> s.getSourcePath().equals(this.primarySource)).findAny().orElseThrow(() -> new IllegalStateException("unable to find primary source"));
        }
    }

    public static class StringSourceFileAssert<S extends SourceFile> {
        private final Parser<S> parser;
        private final String primarySource;
        private final List<String> sourceFiles = new ArrayList<String>();

        public StringSourceFileAssert(Parser<S> parser, String source) {
            this.parser = parser;
            this.primarySource = StringUtils.trimIndent((String)source);
            this.sourceFiles.add(this.primarySource);
        }

        public StringSourceFileAssert<S> whichDependsOn(String ... sources) {
            for (String source : sources) {
                this.sourceFiles.add(StringUtils.trimIndent((String)source));
            }
            return this;
        }

        public RefactoringAssert<S> whenVisitedBy(RefactorVisitor<?> visitor) {
            List sources = this.parser.parse(this.sourceFiles.toArray(new String[0]));
            return new RefactoringAssert<S>(this.primary(sources), sources).whenVisitedBy(visitor);
        }

        public RefactoringAssert<S> whenVisitedBy(Iterable<RefactorVisitor<?>> visitors) {
            List sources = this.parser.parse(this.sourceFiles.toArray(new String[0]));
            return new RefactoringAssert<S>(this.primary(sources), sources).whenVisitedBy(visitors);
        }

        public RefactoringAssert<S> whenVisitedByMapped(Function<S, RefactorVisitor<? super S>> visitorFunction) {
            List sources = this.parser.parse(this.sourceFiles.toArray(new String[0]));
            return new RefactoringAssert<S>(this.primary(sources), sources).whenVisitedByMapped(visitorFunction);
        }

        public RefactoringAssert<S> whenVisitedByMany(Function<S, Iterable<RefactorVisitor<? super S>>> visitorFunction) {
            List sources = this.parser.parse(this.sourceFiles.toArray(new String[0]));
            return new RefactoringAssert<S>(this.primary(sources), sources).whenVisitedByMany(visitorFunction);
        }

        private S primary(List<S> sources) {
            return (S)sources.stream().filter(s -> s.print().trim().equals(this.primarySource)).findAny().orElseThrow(() -> new IllegalStateException("unable to find primary source"));
        }
    }
}

