/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Parser;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.RefactorVisitorTest;
import org.openrewrite.SourceFile;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.RemoveUnusedImports;
import org.openrewrite.java.style.ImportLayoutStyle;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0017\u00a8\u0006\u000b"}, d2={"Lorg/openrewrite/java/RemoveUnusedOrdersTest;", "Lorg/openrewrite/RefactorVisitorTest;", "doNotUnfoldStaticWildcards", "", "doNotUnfoldWildcards", "dontMoveImports", "jp", "Lorg/openrewrite/java/JavaParser;", "dontMoveStaticImports", "unFoldPackageWildcard", "unfoldStaticStar", "rewrite-test"})
public interface RemoveUnusedOrdersTest
extends RefactorVisitorTest {
    @Test
    public void unFoldPackageWildcard(@NotNull JavaParser var1);

    @Test
    public void doNotUnfoldWildcards();

    @Test
    public void dontMoveImports(@NotNull JavaParser var1);

    @Test
    public void unfoldStaticStar(@NotNull JavaParser var1);

    @Test
    public void dontMoveStaticImports(@NotNull JavaParser var1);

    @Test
    public void doNotUnfoldStaticWildcards();

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void unFoldPackageWildcard(@NotNull RemoveUnusedOrdersTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RefactorVisitorTest.DefaultImpls.assertRefactored$default((RefactorVisitorTest)$this, (Parser)jp, (Iterable)CollectionsKt.listOf((Object)new RemoveUnusedImports()), null, null, null, "\n                import java.util.*;\n                import java.math.BigDecimal;\n\n                class A {\n                    List<BigDecimal> getList() {\n                        return Collections.emptyList();\n                    }\n                    Set<BigDecimal> getSet() {\n                        return new HashSet<>();\n                    }\n                }\n            ", "                \n                import java.util.Collections;\n                import java.util.HashSet;\n                import java.util.List;\n                import java.util.Set;\n                import java.math.BigDecimal;\n\n                class A {\n                    List<BigDecimal> getList() {\n                        return Collections.emptyList();\n                    }\n                    Set<BigDecimal> getSet() {\n                        return new HashSet<>();\n                    }\n                }\n            ", null, 156, null);
        }

        @Test
        public static void doNotUnfoldWildcards(@NotNull RemoveUnusedOrdersTest $this) {
            RefactorVisitorTest refactorVisitorTest = $this;
            JavaParser javaParser = JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.mutableListOf((Object[])new ImportLayoutStyle[]{ImportLayoutStyle.layout((int)3, (int)3, (String[])new String[0])})).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"JavaParser.fromJavaVersi\u2026yle.layout(3,3))).build()");
            RefactorVisitorTest.DefaultImpls.assertUnchanged$default(refactorVisitorTest, (Parser)javaParser, (Iterable)CollectionsKt.listOf((Object)new RemoveUnusedImports()), null, null, null, "\n                import java.util.*;\n                import java.math.BigDecimal;\n\n                class A {\n                    List<BigDecimal> getList() {\n                        return Collections.emptyList();\n                    }\n                    Set<BigDecimal> getSet() {\n                        return new HashSet<>();\n                    }\n                }\n            ", 28, null);
        }

        @Test
        public static void dontMoveImports(@NotNull RemoveUnusedOrdersTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RefactorVisitorTest.DefaultImpls.assertUnchanged$default((RefactorVisitorTest)$this, (Parser)jp, (Iterable)CollectionsKt.listOf((Object)new RemoveUnusedImports()), null, null, null, "\n                import java.util.ArrayList;\n                import java.util.HashSet;\n                import java.math.BigDecimal;\n                import java.util.List;\n                import java.util.Set;\n\n                class A {\n                    List<BigDecimal> getList() {\n                        return Collections.emptyList();\n                    }\n                    Set<BigDecimal> getSet() {\n                        return new HashSet<>();\n                    }\n                }\n            ", 28, null);
        }

        @Test
        public static void unfoldStaticStar(@NotNull RemoveUnusedOrdersTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RefactorVisitorTest refactorVisitorTest = $this;
            JavaParser javaParser = JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.mutableListOf((Object[])new ImportLayoutStyle[]{ImportLayoutStyle.layout((int)999, (int)999, (String[])new String[0])})).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"JavaParser.fromJavaVersi\u2026layout(999,999))).build()");
            RefactorVisitorTest.DefaultImpls.assertRefactored$default(refactorVisitorTest, (Parser)javaParser, (Iterable)CollectionsKt.listOf((Object)new RemoveUnusedImports()), null, null, null, "\n                import static java.util.Collections.*;\n                import java.math.BigDecimal;\n                import java.util.List;\n\n                class A {\n                    List<BigDecimal> getList() {\n                        return singletonList(BigDecimal.valueOf(1));\n                    }\n                    List<BigDecimal> getEmptyList() {\n                        return emptyList();\n                    }\n                }\n            ", "                \n                import static java.util.Collections.emptyList;\n                import static java.util.Collections.singletonList;\n                import java.math.BigDecimal;\n                import java.util.List;\n\n                class A {\n                    List<BigDecimal> getList() {\n                        return singletonList(BigDecimal.valueOf(1));\n                    }\n                    List<BigDecimal> getEmptyList() {\n                        return emptyList();\n                    }\n                }\n            ", null, 156, null);
        }

        @Test
        public static void dontMoveStaticImports(@NotNull RemoveUnusedOrdersTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RefactorVisitorTest refactorVisitorTest = $this;
            JavaParser javaParser = JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.mutableListOf((Object[])new ImportLayoutStyle[]{ImportLayoutStyle.layout((int)999, (int)999, (String[])new String[0])})).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"JavaParser.fromJavaVersi\u2026layout(999,999))).build()");
            RefactorVisitorTest.DefaultImpls.assertUnchanged$default(refactorVisitorTest, (Parser)javaParser, (Iterable)CollectionsKt.listOf((Object)new RemoveUnusedImports()), null, null, null, "\n                import static java.util.Collections.emptyList;\n                import java.math.BigDecimal;\n                import java.util.List;\n                import static java.util.Collections.singletonList;\n\n                class A {\n                    List<BigDecimal> getList() {\n                        return singletonList(BigDecimal.valueOf(1));\n                    }\n                    List<BigDecimal> getEmptyList() {\n                        return emptyList();\n                    }\n                }\n            ", 28, null);
        }

        @Test
        public static void doNotUnfoldStaticWildcards(@NotNull RemoveUnusedOrdersTest $this) {
            RefactorVisitorTest refactorVisitorTest = $this;
            JavaParser javaParser = JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.mutableListOf((Object[])new ImportLayoutStyle[]{ImportLayoutStyle.layout((int)2, (int)2, (String[])new String[0])})).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"JavaParser.fromJavaVersi\u2026yle.layout(2,2))).build()");
            RefactorVisitorTest.DefaultImpls.assertUnchanged$default(refactorVisitorTest, (Parser)javaParser, (Iterable)CollectionsKt.listOf((Object)new RemoveUnusedImports()), null, null, null, "\n                import static java.util.Collections.*;\n                import java.math.BigDecimal;\n                import java.util.List;\n\n                class A {\n                    List<BigDecimal> getList() {\n                        return singletonList(BigDecimal.valueOf(1));\n                    }\n                    List<BigDecimal> getEmptyList() {\n                        return emptyList();\n                    }\n                }\n            ", 28, null);
        }

        @NotNull
        public static Iterable<RefactorVisitor<?>> getVisitors(@NotNull RemoveUnusedOrdersTest $this) {
            return RefactorVisitorTest.DefaultImpls.getVisitors($this);
        }

        public static <S extends SourceFile> void assertRefactored(@NotNull RemoveUnusedOrdersTest $this, @NotNull Parser<S> parser, @NotNull Iterable<? extends RefactorVisitor<?>> visitors, @NotNull Iterable<? extends Function1<? super S, ? extends RefactorVisitor<? super S>>> visitorsMapped, @NotNull Iterable<? extends Function1<? super S, ? extends Iterable<? extends RefactorVisitor<? super S>>>> visitorsMappedToMany, @NotNull List<String> dependencies, @NotNull String before, @NotNull String after, @NotNull Function1<? super S, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter(visitors, (String)"visitors");
            Intrinsics.checkNotNullParameter(visitorsMapped, (String)"visitorsMapped");
            Intrinsics.checkNotNullParameter(visitorsMappedToMany, (String)"visitorsMappedToMany");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RefactorVisitorTest.DefaultImpls.assertRefactored((RefactorVisitorTest)$this, parser, visitors, visitorsMapped, visitorsMappedToMany, dependencies, before, after, afterConditions);
        }

        public static <S extends SourceFile> void assertRefactored(@NotNull RemoveUnusedOrdersTest $this, @NotNull Parser<S> parser, @NotNull Iterable<? extends RefactorVisitor<?>> visitors, @NotNull Iterable<? extends Function1<? super S, ? extends RefactorVisitor<? super S>>> visitorsMapped, @NotNull Iterable<? extends Function1<? super S, ? extends Iterable<? extends RefactorVisitor<? super S>>>> visitorsMappedToMany, @NotNull List<String> dependencies, @NotNull String before, @NotNull Function0<String> after, @NotNull Function1<? super S, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter(visitors, (String)"visitors");
            Intrinsics.checkNotNullParameter(visitorsMapped, (String)"visitorsMapped");
            Intrinsics.checkNotNullParameter(visitorsMappedToMany, (String)"visitorsMappedToMany");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter(after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RefactorVisitorTest.DefaultImpls.assertRefactored((RefactorVisitorTest)$this, parser, visitors, visitorsMapped, visitorsMappedToMany, dependencies, before, after, afterConditions);
        }

        public static <S extends SourceFile> void assertRefactored(@NotNull RemoveUnusedOrdersTest $this, @NotNull Parser<S> parser, @NotNull Iterable<? extends RefactorVisitor<?>> visitors, @NotNull Iterable<? extends Function1<? super S, ? extends RefactorVisitor<? super S>>> visitorsMapped, @NotNull Iterable<? extends Function1<? super S, ? extends Iterable<? extends RefactorVisitor<? super S>>>> visitorsMappedToMany, @NotNull List<? extends File> dependencies, @NotNull File before, @NotNull String after, @NotNull Function1<? super S, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter(visitors, (String)"visitors");
            Intrinsics.checkNotNullParameter(visitorsMapped, (String)"visitorsMapped");
            Intrinsics.checkNotNullParameter(visitorsMappedToMany, (String)"visitorsMappedToMany");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RefactorVisitorTest.DefaultImpls.assertRefactored((RefactorVisitorTest)$this, parser, visitors, visitorsMapped, visitorsMappedToMany, dependencies, before, after, afterConditions);
        }

        public static <S extends SourceFile> void assertUnchanged(@NotNull RemoveUnusedOrdersTest $this, @NotNull Parser<S> parser, @NotNull Iterable<? extends RefactorVisitor<?>> visitors, @NotNull Iterable<? extends Function1<? super S, ? extends RefactorVisitor<? super S>>> visitorsMapped, @NotNull Iterable<? extends Function1<? super S, ? extends Iterable<? extends RefactorVisitor<? super S>>>> visitorsMappedToMany, @NotNull List<String> dependencies, @NotNull String before) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter(visitors, (String)"visitors");
            Intrinsics.checkNotNullParameter(visitorsMapped, (String)"visitorsMapped");
            Intrinsics.checkNotNullParameter(visitorsMappedToMany, (String)"visitorsMappedToMany");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            RefactorVisitorTest.DefaultImpls.assertUnchanged((RefactorVisitorTest)$this, parser, visitors, visitorsMapped, visitorsMappedToMany, dependencies, before);
        }

        public static <S extends SourceFile> void assertUnchanged(@NotNull RemoveUnusedOrdersTest $this, @NotNull Parser<S> parser, @NotNull Iterable<? extends RefactorVisitor<?>> visitors, @NotNull Iterable<? extends Function1<? super S, ? extends RefactorVisitor<? super S>>> visitorsMapped, @NotNull Iterable<? extends Function1<? super S, ? extends Iterable<? extends RefactorVisitor<? super S>>>> visitorsMappedToMany, @NotNull List<? extends File> dependencies, @NotNull File before) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter(visitors, (String)"visitors");
            Intrinsics.checkNotNullParameter(visitorsMapped, (String)"visitorsMapped");
            Intrinsics.checkNotNullParameter(visitorsMappedToMany, (String)"visitorsMappedToMany");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            RefactorVisitorTest.DefaultImpls.assertUnchanged((RefactorVisitorTest)$this, parser, visitors, visitorsMapped, visitorsMappedToMany, dependencies, before);
        }
    }
}

