/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowableAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodTypeBuilder;
import org.openrewrite.java.tree.MethodTypeBuilderTest;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0017\u00a8\u0006\u000e"}, d2={"Lorg/openrewrite/java/tree/MethodTypeBuilderTest;", "", "errorThrownIfDeclaringTypeIsNotDefined", "", "errorThrownIfMethodNameIsNotDefined", "methodTypeWithDeclaringType", "jp", "Lorg/openrewrite/java/JavaParser;", "methodTypeWithFlags", "methodTypeWithGenericParameters", "methodTypeWithGenericReturnType", "methodTypeWithParameters", "methodTypeWithReturnType", "methodTypeWithoutReturnType", "rewrite-test"})
public interface MethodTypeBuilderTest {
    @Test
    public void errorThrownIfMethodNameIsNotDefined();

    @Test
    public void errorThrownIfDeclaringTypeIsNotDefined();

    @Test
    public void methodTypeWithDeclaringType(@NotNull JavaParser var1);

    @Test
    public void methodTypeWithoutReturnType(@NotNull JavaParser var1);

    @Test
    public void methodTypeWithReturnType(@NotNull JavaParser var1);

    @Test
    public void methodTypeWithGenericReturnType(@NotNull JavaParser var1);

    @Test
    public void methodTypeWithParameters(@NotNull JavaParser var1);

    @Test
    public void methodTypeWithGenericParameters(@NotNull JavaParser var1);

    @Test
    public void methodTypeWithFlags(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void errorThrownIfMethodNameIsNotDefined(@NotNull MethodTypeBuilderTest $this) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)errorThrownIfMethodNameIsNotDefined.1.INSTANCE).isInstanceOf(IllegalArgumentException.class)).hasMessage("The method name is required.");
        }

        @Test
        public static void errorThrownIfDeclaringTypeIsNotDefined(@NotNull MethodTypeBuilderTest $this) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)errorThrownIfDeclaringTypeIsNotDefined.1.INSTANCE).isInstanceOf(IllegalArgumentException.class)).hasMessage("The declaring type is required.");
        }

        @Test
        public static void methodTypeWithDeclaringType(@NotNull MethodTypeBuilderTest $this, @NotNull JavaParser jp) {
            JavaType.Method m;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List a = jp.parse(new String[]{"public class A {\n    public void foo() {\n        String str = notification();\n    }\n    \n    String notification() {\n        return \"You have been notified\";\n    }\n}"});
            Object e = a.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a[0]");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a[0].classes[0]");
            J.Block block = ((J.ClassDecl)e2).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"a[0].classes[0].body");
            Object e3 = block.getStatements().get(0);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDecl");
            }
            J.Block block2 = ((J.MethodDecl)e3).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"(a[0].classes[0].body.st\u2026[0] as J.MethodDecl).body");
            Object e4 = block2.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            Object e5 = ((J.VariableDecls)e4).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e5, (String)"((a[0].classes[0].body.s\u2026 J.VariableDecls).vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e5).getInitializer();
            Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"((a[0].classes[0].body.s\u2026ecls).vars[0].initializer");
            JavaType javaType = expression.getType();
            if (javaType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Method");
            }
            JavaType.FullyQualified b = ((JavaType.Method)javaType).getDeclaringType();
            JavaType.Method method = m = MethodTypeBuilder.newMethodType().name("notification").declaringClass("A").build();
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"m");
            Assertions.assertThat((Object)method.getDeclaringType()).isEqualTo((Object)b);
        }

        @Test
        public static void methodTypeWithoutReturnType(@NotNull MethodTypeBuilderTest $this, @NotNull JavaParser jp) {
            JavaType.Method method;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaType.Method method2 = method = MethodTypeBuilder.newMethodType().name("notification").declaringClass("A").build();
            Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"method");
            JavaType.Method.Signature signature = method2.getResolvedSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature, (String)"method.resolvedSignature");
            Assertions.assertThat((Object)signature.getReturnType()).isEqualTo((Object)JavaType.Primitive.Void);
            JavaType.Method.Signature signature2 = method.getGenericSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature2, (String)"method.genericSignature");
            Assertions.assertThat((Object)signature2.getReturnType()).isEqualTo((Object)JavaType.Primitive.Void);
        }

        @Test
        public static void methodTypeWithReturnType(@NotNull MethodTypeBuilderTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List cu = jp.parse(new String[]{"public class A {\n    public void foo() {\n        String str1 = notification1();\n        String[] str2 = notification2();\n    }\n    \n    String notification1() {\n        return \"You have been notified once\";\n    }\n    \n    String[] notification2() {\n        return new String[]{\"You have been notified\", \"Of two important things\"};\n    }\n}"});
            Object e = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"cu[0]");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"cu[0].classes[0]");
            J.Block block = ((J.ClassDecl)e2).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"cu[0].classes[0].body");
            Object e3 = block.getStatements().get(0);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDecl");
            }
            J.Block block2 = ((J.MethodDecl)e3).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"(cu[0].classes[0].body.s\u2026[0] as J.MethodDecl).body");
            Object e4 = block2.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            Object e5 = ((J.VariableDecls)e4).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e5, (String)"((cu[0].classes[0].body.\u2026 J.VariableDecls).vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e5).getInitializer();
            Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"((cu[0].classes[0].body.\u2026ecls).vars[0].initializer");
            JavaType javaType = expression.getType();
            if (javaType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Method");
            }
            JavaType.Method.Signature signature = ((JavaType.Method)javaType).getResolvedSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature, (String)"(((cu[0].classes[0].body\u2026Method).resolvedSignature");
            JavaType expectedReturnType1 = signature.getReturnType();
            Object e6 = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e6, (String)"cu[0]");
            Object e7 = ((J.CompilationUnit)e6).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e7, (String)"cu[0].classes[0]");
            J.Block block3 = ((J.ClassDecl)e7).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block3, (String)"cu[0].classes[0].body");
            Object e8 = block3.getStatements().get(0);
            if (e8 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDecl");
            }
            J.Block block4 = ((J.MethodDecl)e8).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block4, (String)"(cu[0].classes[0].body.s\u2026[0] as J.MethodDecl).body");
            Object e9 = block4.getStatements().get(1);
            if (e9 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            Object e10 = ((J.VariableDecls)e9).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e10, (String)"((cu[0].classes[0].body.\u2026 J.VariableDecls).vars[0]");
            Expression expression2 = ((J.VariableDecls.NamedVar)e10).getInitializer();
            Intrinsics.checkNotNullExpressionValue((Object)expression2, (String)"((cu[0].classes[0].body.\u2026ecls).vars[0].initializer");
            JavaType javaType2 = expression2.getType();
            if (javaType2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Method");
            }
            JavaType.Method.Signature signature2 = ((JavaType.Method)javaType2).getResolvedSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature2, (String)"(((cu[0].classes[0].body\u2026Method).resolvedSignature");
            JavaType expectedReturnType2 = signature2.getReturnType();
            JavaType.Method method1 = MethodTypeBuilder.newMethodType().name("notification1").declaringClass("A").returnType("java.lang.String").build();
            JavaType.Method method2 = MethodTypeBuilder.newMethodType().name("notification2").declaringClass("A").returnType((JavaType)new JavaType.Array(JavaType.buildType((String)"java.lang.String"))).build();
            JavaType.Method method = method1;
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method1");
            JavaType.Method.Signature signature3 = method.getResolvedSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature3, (String)"method1.resolvedSignature");
            Assertions.assertThat((Object)signature3.getReturnType()).isEqualTo((Object)expectedReturnType1);
            JavaType.Method method3 = method2;
            Intrinsics.checkNotNullExpressionValue((Object)method3, (String)"method2");
            JavaType.Method.Signature signature4 = method3.getResolvedSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature4, (String)"method2.resolvedSignature");
            Assertions.assertThat((Object)signature4.getReturnType()).isEqualTo((Object)expectedReturnType2);
        }

        @Test
        public static void methodTypeWithGenericReturnType(@NotNull MethodTypeBuilderTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List cu = jp.parse(new String[]{"public class A {\n    public void foo() {\n        String str = notification();\n    }\n    \n    <T> T notification() {\n        return (T) \"You have been notified\";\n    }\n}"});
            Object e = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"cu[0]");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"cu[0].classes[0]");
            J.Block block = ((J.ClassDecl)e2).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"cu[0].classes[0].body");
            Object e3 = block.getStatements().get(0);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDecl");
            }
            J.Block block2 = ((J.MethodDecl)e3).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"(cu[0].classes[0].body.s\u2026[0] as J.MethodDecl).body");
            Object e4 = block2.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            Object e5 = ((J.VariableDecls)e4).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e5, (String)"((cu[0].classes[0].body.\u2026 J.VariableDecls).vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e5).getInitializer();
            Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"((cu[0].classes[0].body.\u2026ecls).vars[0].initializer");
            JavaType javaType = expression.getType();
            if (javaType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Method");
            }
            JavaType.Method expectedReturnType = (JavaType.Method)javaType;
            JavaType.Method method1 = MethodTypeBuilder.newMethodType().name("notification").declaringClass("A").returnType("java.lang.String", "T").build();
            JavaType.Method method2 = MethodTypeBuilder.newMethodType().name("notification").declaringClass("A").returnType(JavaType.buildType((String)"java.lang.String"), (JavaType)new JavaType.GenericTypeVariable("T", JavaType.Class.build((String)"java.lang.Object"))).build();
            JavaType.Method method = method1;
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method1");
            JavaType.Method.Signature signature = method.getResolvedSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature, (String)"method1.resolvedSignature");
            ObjectAssert objectAssert = Assertions.assertThat((Object)signature.getReturnType());
            JavaType.Method.Signature signature2 = expectedReturnType.getResolvedSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature2, (String)"expectedReturnType.resolvedSignature");
            objectAssert.isEqualTo((Object)signature2.getReturnType());
            JavaType.Method.Signature signature3 = method1.getGenericSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature3, (String)"method1.genericSignature");
            ObjectAssert objectAssert2 = Assertions.assertThat((Object)signature3.getReturnType());
            JavaType.Method.Signature signature4 = expectedReturnType.getGenericSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature4, (String)"expectedReturnType.genericSignature");
            objectAssert2.isEqualTo((Object)signature4.getReturnType());
            JavaType.Method method3 = method2;
            Intrinsics.checkNotNullExpressionValue((Object)method3, (String)"method2");
            JavaType.Method.Signature signature5 = method3.getResolvedSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature5, (String)"method2.resolvedSignature");
            ObjectAssert objectAssert3 = Assertions.assertThat((Object)signature5.getReturnType());
            JavaType.Method.Signature signature6 = expectedReturnType.getResolvedSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature6, (String)"expectedReturnType.resolvedSignature");
            objectAssert3.isEqualTo((Object)signature6.getReturnType());
            JavaType.Method.Signature signature7 = method2.getGenericSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature7, (String)"method2.genericSignature");
            ObjectAssert objectAssert4 = Assertions.assertThat((Object)signature7.getReturnType());
            JavaType.Method.Signature signature8 = expectedReturnType.getGenericSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature8, (String)"expectedReturnType.genericSignature");
            objectAssert4.isEqualTo((Object)signature8.getReturnType());
        }

        @Test
        public static void methodTypeWithParameters(@NotNull MethodTypeBuilderTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List cu = jp.parse(new String[]{"public class A {\n    public void foo() {\n        String str = notification(\"Something\");\n    }\n    \n    String notification(String message) {\n        return \"You have been notified of \" + message;\n    }\n}"});
            Object e = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"cu[0]");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"cu[0].classes[0]");
            J.Block block = ((J.ClassDecl)e2).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"cu[0].classes[0].body");
            Object e3 = block.getStatements().get(0);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDecl");
            }
            J.Block block2 = ((J.MethodDecl)e3).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"(cu[0].classes[0].body.s\u2026[0] as J.MethodDecl).body");
            Object e4 = block2.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            Object e5 = ((J.VariableDecls)e4).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e5, (String)"((cu[0].classes[0].body.\u2026 J.VariableDecls).vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e5).getInitializer();
            Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"((cu[0].classes[0].body.\u2026ecls).vars[0].initializer");
            JavaType javaType = expression.getType();
            if (javaType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Method");
            }
            JavaType.Method.Signature signature = ((JavaType.Method)javaType).getResolvedSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature, (String)"(((cu[0].classes[0].body\u2026Method).resolvedSignature");
            List expectedParameters = signature.getParamTypes();
            JavaType.Method method1 = MethodTypeBuilder.newMethodType().name("notification").declaringClass("A").parameter("java.lang.String", "message").build();
            JavaType.Method method2 = MethodTypeBuilder.newMethodType().name("notification").declaringClass("A").parameter(JavaType.buildType((String)"java.lang.String"), "message").build();
            JavaType.Method method = method1;
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method1");
            JavaType.Method.Signature signature2 = method.getResolvedSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature2, (String)"method1.resolvedSignature");
            Assertions.assertThat((List)signature2.getParamTypes()).isEqualTo((Object)expectedParameters);
            JavaType.Method method3 = method2;
            Intrinsics.checkNotNullExpressionValue((Object)method3, (String)"method2");
            JavaType.Method.Signature signature3 = method3.getResolvedSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature3, (String)"method2.resolvedSignature");
            Assertions.assertThat((List)signature3.getParamTypes()).isEqualTo((Object)expectedParameters);
            JavaType.Method.Signature signature4 = method1.getResolvedSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature4, (String)"method1.resolvedSignature");
            ListAssert listAssert = Assertions.assertThat((List)signature4.getParamTypes());
            JavaType.Method.Signature signature5 = method1.getGenericSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature5, (String)"method1.genericSignature");
            listAssert.isEqualTo((Object)signature5.getParamTypes());
            JavaType.Method.Signature signature6 = method2.getResolvedSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature6, (String)"method2.resolvedSignature");
            ListAssert listAssert2 = Assertions.assertThat((List)signature6.getParamTypes());
            JavaType.Method.Signature signature7 = method2.getGenericSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature7, (String)"method2.genericSignature");
            listAssert2.isEqualTo((Object)signature7.getParamTypes());
        }

        @Test
        public static void methodTypeWithGenericParameters(@NotNull MethodTypeBuilderTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List cu = jp.parse(new String[]{"public class A {\n    public void foo() {\n        String str = notification(\"Something\");\n    }\n    \n    <T> String notification(T message) {\n        return \"You have been notified of \" + message;\n    }\n}"});
            Object e = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"cu[0]");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"cu[0].classes[0]");
            J.Block block = ((J.ClassDecl)e2).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"cu[0].classes[0].body");
            Object e3 = block.getStatements().get(0);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDecl");
            }
            J.Block block2 = ((J.MethodDecl)e3).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"(cu[0].classes[0].body.s\u2026[0] as J.MethodDecl).body");
            Object e4 = block2.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            Object e5 = ((J.VariableDecls)e4).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e5, (String)"((cu[0].classes[0].body.\u2026 J.VariableDecls).vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e5).getInitializer();
            Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"((cu[0].classes[0].body.\u2026ecls).vars[0].initializer");
            JavaType javaType = expression.getType();
            if (javaType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Method");
            }
            JavaType.Method expectedMethod = (JavaType.Method)javaType;
            JavaType.Method method1 = MethodTypeBuilder.newMethodType().name("notification").declaringClass("A").parameter("java.lang.String", "T", "message").build();
            JavaType.Method method2 = MethodTypeBuilder.newMethodType().name("notification").declaringClass("A").parameter(JavaType.buildType((String)"java.lang.String"), (JavaType)new JavaType.GenericTypeVariable("T", JavaType.Class.build((String)"java.lang.Object")), "message").build();
            JavaType.Method method = method1;
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method1");
            JavaType.Method.Signature signature = method.getResolvedSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature, (String)"method1.resolvedSignature");
            ListAssert listAssert = Assertions.assertThat((List)signature.getParamTypes());
            JavaType.Method.Signature signature2 = expectedMethod.getResolvedSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature2, (String)"expectedMethod.resolvedSignature");
            listAssert.isEqualTo((Object)signature2.getParamTypes());
            JavaType.Method.Signature signature3 = method1.getGenericSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature3, (String)"method1.genericSignature");
            ListAssert listAssert2 = Assertions.assertThat((List)signature3.getParamTypes());
            JavaType.Method.Signature signature4 = expectedMethod.getGenericSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature4, (String)"expectedMethod.genericSignature");
            listAssert2.isEqualTo((Object)signature4.getParamTypes());
            JavaType.Method method3 = method2;
            Intrinsics.checkNotNullExpressionValue((Object)method3, (String)"method2");
            JavaType.Method.Signature signature5 = method3.getResolvedSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature5, (String)"method2.resolvedSignature");
            ListAssert listAssert3 = Assertions.assertThat((List)signature5.getParamTypes());
            JavaType.Method.Signature signature6 = expectedMethod.getResolvedSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature6, (String)"expectedMethod.resolvedSignature");
            listAssert3.isEqualTo((Object)signature6.getParamTypes());
            JavaType.Method.Signature signature7 = method2.getGenericSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature7, (String)"method2.genericSignature");
            ListAssert listAssert4 = Assertions.assertThat((List)signature7.getParamTypes());
            JavaType.Method.Signature signature8 = expectedMethod.getGenericSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature8, (String)"expectedMethod.genericSignature");
            listAssert4.isEqualTo((Object)signature8.getParamTypes());
        }

        @Test
        public static void methodTypeWithFlags(@NotNull MethodTypeBuilderTest $this, @NotNull JavaParser jp) {
            JavaType.Method method1;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List cu = jp.parse(new String[]{"public class A {\n    public void foo() {\n        String str = notification();\n    }\n    \n    public static String notification() {\n        return \"You have been notified\";\n    }\n}"});
            Object e = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"cu[0]");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"cu[0].classes[0]");
            J.Block block = ((J.ClassDecl)e2).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"cu[0].classes[0].body");
            Object e3 = block.getStatements().get(0);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDecl");
            }
            J.Block block2 = ((J.MethodDecl)e3).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"(cu[0].classes[0].body.s\u2026[0] as J.MethodDecl).body");
            Object e4 = block2.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            Object e5 = ((J.VariableDecls)e4).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e5, (String)"((cu[0].classes[0].body.\u2026 J.VariableDecls).vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e5).getInitializer();
            Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"((cu[0].classes[0].body.\u2026ecls).vars[0].initializer");
            JavaType javaType = expression.getType();
            if (javaType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Method");
            }
            JavaType.Method expectedMethod = (JavaType.Method)javaType;
            JavaType.Method method = method1 = MethodTypeBuilder.newMethodType().name("notifications").declaringClass("A").returnType("java.lang.String").flags(new Flag[]{Flag.Public, Flag.Static}).build();
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method1");
            Assertions.assertThat((Iterable)method.getFlags()).isEqualTo((Object)expectedMethod.getFlags());
        }
    }
}

