/*
 * Copyright 2021 the original author or authors.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * https://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.openrewrite.java.recipes

import org.junit.jupiter.api.Test
import org.openrewrite.java.JavaParser
import org.openrewrite.test.RecipeSpec
import org.openrewrite.test.RewriteTest

interface PublicGetVisitorTest : RewriteTest {
    override fun defaults(spec: RecipeSpec) {
        spec
            .parser(
                JavaParser.fromJavaVersion()
                    .classpath(JavaParser.runtimeClasspath())
                    .build()
            )
            .recipe(PublicGetVisitor())
    }

    @Suppress("NullableProblems")
    @Test
    fun getVisitor() = rewriteRun(
        java(
            """
                import org.openrewrite.*;
                class SampleRecipe extends Recipe {
                    @Override
                    protected TreeVisitor<?, ExecutionContext> getVisitor() {
                        return TreeVisitor.noop();
                    }
                }
            """,
            """
                import org.openrewrite.*;
                class SampleRecipe extends Recipe {
                    @Override
                    public TreeVisitor<?, ExecutionContext> getVisitor() {
                        return TreeVisitor.noop();
                    }
                }
            """
        )
    )
}
