/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.glcommon;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.ComputeShader;
import org.openrndr.draw.ComputeStructure;
import org.openrndr.draw.ComputeStyle;
import org.openrndr.draw.ComputeStyleManager;
import org.openrndr.draw.ShaderBufferBindings;
import org.openrndr.draw.ShaderImageBindings;
import org.openrndr.draw.ShaderUniforms;
import org.openrndr.draw.StyleBufferBindings;
import org.openrndr.draw.StyleImageBindings;
import org.openrndr.draw.StyleParameters;
import org.openrndr.internal.Driver;
import org.openrndr.internal.glcommon.ComputeStyleManagerGLCommonKt;
import org.openrndr.internal.glcommon.StyleManagerDispatchBufferBindings;
import org.openrndr.internal.glcommon.StyleManagerDispatchImageBindings;
import org.openrndr.internal.glcommon.StyleManagerDispatchUniform;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\t\"\u0004\b\u0014\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lorg/openrndr/internal/glcommon/ComputeStyleManagerGLCommon;", "Lorg/openrndr/draw/ComputeStyleManager;", "Lorg/openrndr/internal/glcommon/StyleManagerDispatchUniform;", "Lorg/openrndr/internal/glcommon/StyleManagerDispatchBufferBindings;", "Lorg/openrndr/internal/glcommon/StyleManagerDispatchImageBindings;", "()V", "imageIndex", "", "getImageIndex", "()I", "setImageIndex", "(I)V", "shaders", "", "Lorg/openrndr/draw/ComputeStructure;", "Lorg/openrndr/draw/ComputeShader;", "getShaders", "()Ljava/util/Map;", "textureIndex", "getTextureIndex", "setTextureIndex", "shader", "style", "Lorg/openrndr/draw/ComputeStyle;", "name", "", "openrndr-gl-common"})
@SourceDebugExtension(value={"SMAP\nComputeStyleManagerGLCommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComputeStyleManagerGLCommon.kt\norg/openrndr/internal/glcommon/ComputeStyleManagerGLCommon\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,48:1\n372#2,7:49\n*S KotlinDebug\n*F\n+ 1 ComputeStyleManagerGLCommon.kt\norg/openrndr/internal/glcommon/ComputeStyleManagerGLCommon\n*L\n26#1:49,7\n*E\n"})
public final class ComputeStyleManagerGLCommon
extends ComputeStyleManager
implements StyleManagerDispatchUniform,
StyleManagerDispatchBufferBindings,
StyleManagerDispatchImageBindings {
    @NotNull
    private final Map<ComputeStructure, ComputeShader> shaders = new LinkedHashMap();
    private int textureIndex = 2;
    private int imageIndex;

    @NotNull
    public final Map<ComputeStructure, ComputeShader> getShaders() {
        return this.shaders;
    }

    @Override
    public int getTextureIndex() {
        return this.textureIndex;
    }

    @Override
    public void setTextureIndex(int n) {
        this.textureIndex = n;
    }

    @Override
    public int getImageIndex() {
        return this.imageIndex;
    }

    @Override
    public void setImageIndex(int n) {
        this.imageIndex = n;
    }

    @NotNull
    public ComputeShader shader(@NotNull ComputeStyle style, @NotNull String name) {
        ComputeShader computeShader;
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ComputeStructure structure = ComputeStyleManagerGLCommonKt.structure(style);
        Map<ComputeStructure, ComputeShader> $this$getOrPut$iv = this.shaders;
        boolean $i$f$getOrPut = false;
        ComputeShader value$iv = $this$getOrPut$iv.get(structure);
        if (value$iv == null) {
            String string;
            String string2;
            boolean bl = false;
            int n = structure.getWorkGroupSize().getX();
            int n2 = structure.getWorkGroupSize().getY();
            int n3 = structure.getWorkGroupSize().getZ();
            String string3 = structure.getStructDefinitions();
            if (string3 == null) {
                string3 = "";
            }
            if ((string2 = structure.getUniforms()) == null) {
                string2 = "";
            }
            if ((string = structure.getBuffers()) == null) {
                string = "";
            }
            String code = "#version 450 core\nlayout(local_size_x = " + n + ", local_size_y = " + n2 + ", local_size_z = " + n3 + ") in;\n\n" + string3 + "\n" + string2 + "\n" + string + "\n\n" + structure.getComputePreamble() + "\n\nvoid main() {\n" + StringsKt.prependIndent((String)structure.getComputeTransform(), (String)"    ") + "        \n}";
            ComputeShader answer$iv = Driver.DefaultImpls.createComputeShader$default((Driver)Driver.Companion.getInstance(), (String)code, (String)name, null, (int)4, null);
            $this$getOrPut$iv.put(structure, answer$iv);
            computeShader = answer$iv;
        } else {
            computeShader = value$iv;
        }
        ComputeShader shader = computeShader;
        this.dispatchBufferBindings((StyleBufferBindings)style, (ShaderBufferBindings)shader);
        this.dispatchParameters((StyleParameters)style, (ShaderUniforms)shader);
        this.dispatchImageBindings((StyleImageBindings)style, (ShaderImageBindings)shader);
        return shader;
    }

    @Override
    public <T extends ShaderUniforms> void dispatchParameters(@NotNull StyleParameters style, @NotNull T shader) {
        StyleManagerDispatchUniform.DefaultImpls.dispatchParameters(this, style, shader);
    }

    @Override
    public <T extends ShaderUniforms> void setUniform(@NotNull T shader, @NotNull String targetName, @NotNull String name, @NotNull Object value) {
        StyleManagerDispatchUniform.DefaultImpls.setUniform(this, shader, targetName, name, value);
    }

    @Override
    public <T extends ShaderBufferBindings> void dispatchBufferBindings(@NotNull StyleBufferBindings style, @NotNull T shader) {
        StyleManagerDispatchBufferBindings.DefaultImpls.dispatchBufferBindings(this, style, shader);
    }

    @Override
    public <T extends ShaderImageBindings> void dispatchImageBindings(@NotNull StyleImageBindings style, @NotNull T shader) {
        StyleManagerDispatchImageBindings.DefaultImpls.dispatchImageBindings(this, style, shader);
    }
}

