/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.glcommon;

import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferPrimitiveType;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorSampling;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.ShadeStyleKt;
import org.openrndr.draw.ShadeStyleOutput;
import org.openrndr.draw.ShaderStorageFormat;
import org.openrndr.draw.VertexElementType;
import org.openrndr.draw.font.BufferAccess;
import org.openrndr.draw.font.BufferFlag;
import org.openrndr.internal.glcommon.MappingKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u001a\u0018\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0001H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\u0001*\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0018\u0010\u000b\u001a\u00020\u0001*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0018\u0010\u000b\u001a\u00020\u0001*\u00020\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0010\"\u0018\u0010\u000b\u001a\u00020\u0001*\u00020\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0012\"\u0018\u0010\u0013\u001a\u00020\u0001*\u00020\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u001c"}, d2={"glsl", "", "Lorg/openrndr/draw/font/BufferAccess;", "getGlsl", "(Lorg/openrndr/draw/font/BufferAccess;)Ljava/lang/String;", "Lorg/openrndr/draw/font/BufferFlag;", "(Lorg/openrndr/draw/font/BufferFlag;)Ljava/lang/String;", "glslLayout", "Lorg/openrndr/draw/ShaderStorageFormat;", "getGlslLayout", "(Lorg/openrndr/draw/ShaderStorageFormat;)Ljava/lang/String;", "glslType", "Lorg/openrndr/draw/BufferPrimitiveType;", "getGlslType", "(Lorg/openrndr/draw/BufferPrimitiveType;)Ljava/lang/String;", "Lorg/openrndr/draw/ShadeStyleOutput;", "(Lorg/openrndr/draw/ShadeStyleOutput;)Ljava/lang/String;", "Lorg/openrndr/draw/VertexElementType;", "(Lorg/openrndr/draw/VertexElementType;)Ljava/lang/String;", "glslVaryingQualifier", "getGlslVaryingQualifier", "imageLayout", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "mapTypeToUniform", "name", "openrndr-gl-common"})
public final class MappingKt {
    @NotNull
    public static final String imageLayout(@NotNull ColorFormat format, @NotNull ColorType type) {
        String string;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Pair pair = new Pair((Object)format, (Object)type);
        if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.R, (Object)ColorType.UINT8))) {
            string = "r8";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.R, (Object)ColorType.UINT8_INT))) {
            string = "r8u";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.R, (Object)ColorType.SINT8_INT))) {
            string = "r8i";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.R, (Object)ColorType.UINT16))) {
            string = "r16";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.R, (Object)ColorType.UINT16_INT))) {
            string = "r16u";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.R, (Object)ColorType.SINT16_INT))) {
            string = "r16i";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.R, (Object)ColorType.UINT32_INT))) {
            string = "r32u";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.R, (Object)ColorType.SINT32_INT))) {
            string = "r32i";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.R, (Object)ColorType.FLOAT16))) {
            string = "r16f";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.R, (Object)ColorType.FLOAT32))) {
            string = "r32f";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.RG, (Object)ColorType.UINT8))) {
            string = "rg8";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.RG, (Object)ColorType.UINT8_INT))) {
            string = "rg8u";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.RG, (Object)ColorType.SINT8_INT))) {
            string = "rg8i";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.RG, (Object)ColorType.UINT16))) {
            string = "rg16";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.RG, (Object)ColorType.UINT16_INT))) {
            string = "rg16u";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.RG, (Object)ColorType.SINT16_INT))) {
            string = "rg16i";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.RG, (Object)ColorType.FLOAT16))) {
            string = "rg16f";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.RG, (Object)ColorType.FLOAT32))) {
            string = "rg32f";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.RGBa, (Object)ColorType.UINT8))) {
            string = "rgba8";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.RGBa, (Object)ColorType.UINT8_INT))) {
            string = "rgba8u";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.RGBa, (Object)ColorType.SINT8_INT))) {
            string = "rgba8i";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.RGBa, (Object)ColorType.UINT16))) {
            string = "rgba16";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.RGBa, (Object)ColorType.UINT16_INT))) {
            string = "rgba16u";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.RGBa, (Object)ColorType.SINT16_INT))) {
            string = "rgba16i";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.RGBa, (Object)ColorType.FLOAT16))) {
            string = "rgba16f";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)ColorFormat.RGBa, (Object)ColorType.FLOAT32))) {
            string = "rgba32f";
        } else {
            throw new IllegalStateException(("unsupported layout: " + format + " " + type).toString());
        }
        return string;
    }

    @NotNull
    public static final String getGlslType(@NotNull ShadeStyleOutput $this$glslType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$glslType, (String)"<this>");
        Pair pair = new Pair((Object)$this$glslType.getFormat().getComponentCount(), (Object)$this$glslType.getType().getColorSampling());
        if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)1, (Object)ColorSampling.NORMALIZED))) {
            string = "float";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)2, (Object)ColorSampling.NORMALIZED))) {
            string = "vec2";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)3, (Object)ColorSampling.NORMALIZED))) {
            string = "vec3";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)4, (Object)ColorSampling.NORMALIZED))) {
            string = "vec4";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)1, (Object)ColorSampling.UNSIGNED_INTEGER))) {
            string = "uint";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)2, (Object)ColorSampling.UNSIGNED_INTEGER))) {
            string = "uvec2";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)3, (Object)ColorSampling.UNSIGNED_INTEGER))) {
            string = "uvec3";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)4, (Object)ColorSampling.UNSIGNED_INTEGER))) {
            string = "uvec4";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)1, (Object)ColorSampling.SIGNED_INTEGER))) {
            string = "int";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)2, (Object)ColorSampling.SIGNED_INTEGER))) {
            string = "ivec2";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)3, (Object)ColorSampling.SIGNED_INTEGER))) {
            string = "ivec3";
        } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)4, (Object)ColorSampling.SIGNED_INTEGER))) {
            string = "ivec4";
        } else {
            throw new IllegalStateException("unsupported type".toString());
        }
        return string;
    }

    private static final String getGlslType(BufferPrimitiveType $this$glslType) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$glslType.ordinal()]) {
            case 1: {
                string = "bool";
                break;
            }
            case 2: {
                string = "int";
                break;
            }
            case 3: {
                string = "uint";
                break;
            }
            case 4: {
                string = "float";
                break;
            }
            case 5: {
                string = "double";
                break;
            }
            case 6: {
                string = "uvec2";
                break;
            }
            case 7: {
                string = "bvec2";
                break;
            }
            case 8: {
                string = "ivec2";
                break;
            }
            case 9: {
                string = "vec2";
                break;
            }
            case 10: {
                string = "dvec2";
                break;
            }
            case 11: {
                string = "uvec3";
                break;
            }
            case 12: {
                string = "bvec3";
                break;
            }
            case 13: {
                string = "ivec3";
                break;
            }
            case 14: {
                string = "vec3";
                break;
            }
            case 15: {
                string = "dvec3";
                break;
            }
            case 16: {
                string = "uvec4";
                break;
            }
            case 17: {
                string = "bvec4";
                break;
            }
            case 18: {
                string = "ivec4";
                break;
            }
            case 19: {
                string = "vec4";
                break;
            }
            case 20: {
                string = "dvec4";
                break;
            }
            case 21: {
                string = "mat2";
                break;
            }
            case 22: {
                string = "mat3";
                break;
            }
            case 23: {
                string = "mat4";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public static final String getGlslType(@NotNull VertexElementType $this$glslType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$glslType, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$glslType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                string = "int";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "uint";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "uvec2";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                string = "ivec2";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                string = "uvec3";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                string = "ivec3";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                string = "uvec4";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                string = "ivec4";
                break;
            }
            case 25: {
                string = "float";
                break;
            }
            case 26: {
                string = "vec2";
                break;
            }
            case 27: {
                string = "vec3";
                break;
            }
            case 28: {
                string = "vec4";
                break;
            }
            case 29: {
                string = "mat2";
                break;
            }
            case 30: {
                string = "mat3";
                break;
            }
            case 31: {
                string = "mat4";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public static final String getGlslVaryingQualifier(@NotNull VertexElementType $this$glslVaryingQualifier) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$glslVaryingQualifier, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$glslVaryingQualifier.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                string = "flat ";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "flat ";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "flat ";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                string = "flat ";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                string = "flat ";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                string = "flat ";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                string = "flat ";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                string = "flat ";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @NotNull
    public static final String getGlslLayout(@NotNull ShaderStorageFormat $this$glslLayout) {
        Intrinsics.checkNotNullParameter((Object)$this$glslLayout, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)$this$glslLayout.getElements(), (CharSequence)"\n", null, null, (int)0, null, (Function1)glslLayout.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final String getGlsl(@NotNull BufferAccess $this$glsl) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$glsl, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$2[$this$glsl.ordinal()]) {
            case 1: {
                string = "readonly";
                break;
            }
            case 2: {
                string = "";
                break;
            }
            case 3: {
                string = "writeonly";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public static final String getGlsl(@NotNull BufferFlag $this$glsl) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$glsl, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$3[$this$glsl.ordinal()]) {
            case 1: {
                string = "restrict";
                break;
            }
            case 2: {
                string = "coherent";
                break;
            }
            case 3: {
                string = "volatile";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public static final String mapTypeToUniform(@NotNull String type, @NotNull String name) {
        String string;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String[] stringArray = new String[]{","};
        List tokens = StringsKt.split$default((CharSequence)type, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String arraySize = (String)CollectionsKt.getOrNull((List)tokens, (int)1);
        String u = "uniform";
        Object object = new String[]{" "};
        List subtokens = StringsKt.split$default((CharSequence)((CharSequence)tokens.get(0)), (String[])object, (boolean)false, (int)0, (int)6, null);
        block9 : switch ((String)subtokens.get(0)) {
            case "struct": {
                string = u + " " + subtokens.get(1) + " p_" + name + MappingKt.mapTypeToUniform$arraySizeDefinition(arraySize, arraySize, name);
                break;
            }
            case "Image3D": 
            case "ImageCube": 
            case "ImageBuffer": 
            case "Image2D": 
            case "ImageCubeArray": 
            case "Image2DArray": {
                String string2 = StringsKt.take((String)((String)tokens.get(0)), (int)1).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                String sampler = string2 + StringsKt.drop((String)((String)tokens.get(0)), (int)1);
                ColorFormat colorFormat = ColorFormat.valueOf((String)((String)tokens.get(1)));
                ColorType colorType = ColorType.valueOf((String)((String)tokens.get(2)));
                BufferAccess access = BufferAccess.valueOf((String)((String)tokens.get(3)));
                String layout = MappingKt.imageLayout(colorFormat, colorType);
                switch (WhenMappings.$EnumSwitchMapping$2[access.ordinal()]) {
                    case 1: {
                        string = "layout(" + layout + ") readonly " + u + " " + sampler + " p_" + name + ";";
                        break block9;
                    }
                    case 2: {
                        string = "layout(" + layout + ") " + u + " " + sampler + " p_" + name + ";";
                        break block9;
                    }
                    case 3: {
                        string = "layout(" + layout + ") writeonly " + u + " " + sampler + " p_" + name + ";";
                        break block9;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            default: {
                string = u + " " + ShadeStyleKt.shadeStyleTypeToGLSL((String)((String)tokens.get(0))) + " p_" + name + MappingKt.mapTypeToUniform$arraySizeDefinition(arraySize, arraySize, name);
            }
        }
        return string;
    }

    private static final String mapTypeToUniform$arraySizeDefinition(String $this$mapTypeToUniform_u24arraySizeDefinition, String arraySize, String $name) {
        return $this$mapTypeToUniform_u24arraySizeDefinition == null ? ";" : "[" + arraySize + "]; \n#define p_" + $name + "_SIZE " + arraySize;
    }

    public static final /* synthetic */ String access$getGlslType(BufferPrimitiveType $receiver) {
        return MappingKt.getGlslType($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[BufferPrimitiveType.values().length];
            try {
                nArray[BufferPrimitiveType.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.INT32.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.UINT32.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.FLOAT32.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.FLOAT64.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR2_UINT32.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR2_BOOLEAN.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR2_INT32.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR2_FLOAT32.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR2_FLOAT64.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR3_UINT32.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR3_BOOLEAN.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR3_INT32.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR3_FLOAT32.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR3_FLOAT64.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR4_UINT32.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR4_BOOLEAN.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR4_INT32.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR4_FLOAT32.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR4_FLOAT64.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.MATRIX22_FLOAT32.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.MATRIX33_FLOAT32.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.MATRIX44_FLOAT32.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[VertexElementType.values().length];
            try {
                nArray[VertexElementType.INT8.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.INT16.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.INT32.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.UINT8.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.UINT16.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.UINT32.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_UINT8.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_UINT16.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_UINT32.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_INT8.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_INT16.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_INT32.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_UINT8.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_UINT16.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_UINT32.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_INT8.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_INT16.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_INT32.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_UINT8.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_UINT16.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_UINT32.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_INT8.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_INT16.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_INT32.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.FLOAT32.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_FLOAT32.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_FLOAT32.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_FLOAT32.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.MATRIX22_FLOAT32.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.MATRIX33_FLOAT32.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.MATRIX44_FLOAT32.ordinal()] = 31;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[BufferAccess.values().length];
            try {
                nArray[BufferAccess.READ.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferAccess.READ_WRITE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferAccess.WRITE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[BufferFlag.values().length];
            try {
                nArray[BufferFlag.RESTRICT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferFlag.COHERENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferFlag.VOLATILE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

