/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.openal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openal.AL11;
import org.openrndr.openal.AudioBuffer;
import org.openrndr.openal.AudioData;
import org.openrndr.openal.AudioPlayerKt;
import org.openrndr.openal.AudioQueueSource;
import org.openrndr.openal.AudioSource;
import org.openrndr.openal.Queue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u0012\b\u0002\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001eJ\u0006\u0010 \u001a\u00020\u001eJ\u0006\u0010!\u001a\u00020\u001eJ\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\bJ\u0006\u0010$\u001a\u00020\u001eJ\u0006\u0010%\u001a\u00020\u001eR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000e\u00a8\u0006&"}, d2={"Lorg/openrndr/openal/AudioQueueSource;", "Lorg/openrndr/openal/AudioSource;", "source", "", "bufferCount", "queueSize", "pullFunction", "Lkotlin/Function0;", "Lorg/openrndr/openal/AudioData;", "(IIILkotlin/jvm/functions/Function0;)V", "<set-?>", "", "bufferOffset", "getBufferOffset", "()J", "inputQueue", "Lorg/openrndr/openal/Queue;", "outputQueue", "", "Lkotlin/Pair;", "outputQueueFull", "", "getOutputQueueFull", "()Z", "getQueueSize", "()I", "queued", "sampleOffset", "getSampleOffset", "dispose", "", "flush", "pause", "play", "queue", "data", "resume", "stop", "openrndr-openal"})
public final class AudioQueueSource
extends AudioSource {
    private final int bufferCount;
    private final int queueSize;
    @Nullable
    private final Function0<AudioData> pullFunction;
    @NotNull
    private final Queue<AudioData> inputQueue;
    private int queued;
    @NotNull
    private List<Pair<Integer, Integer>> outputQueue;
    private long bufferOffset;

    public AudioQueueSource(int source, int bufferCount, int queueSize, @Nullable Function0<AudioData> pullFunction) {
        super(source);
        this.bufferCount = bufferCount;
        this.queueSize = queueSize;
        this.pullFunction = pullFunction;
        this.inputQueue = new Queue(this.queueSize);
        this.outputQueue = new ArrayList();
    }

    public /* synthetic */ AudioQueueSource(int n, int n2, int n3, Function0 function0, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n2 = 2;
        }
        if ((n4 & 4) != 0) {
            n3 = 20;
        }
        if ((n4 & 8) != 0) {
            function0 = null;
        }
        this(n, n2, n3, (Function0<AudioData>)function0);
    }

    public final int getQueueSize() {
        return this.queueSize;
    }

    public final void queue(@NotNull AudioData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.inputQueue.push(data);
    }

    public final boolean getOutputQueueFull() {
        return this.outputQueue.size() >= this.queueSize - 1;
    }

    public final long getBufferOffset() {
        return this.bufferOffset;
    }

    public final long getSampleOffset() {
        return this.bufferOffset + (long)AL11.alGetSourcei((int)this.getSource(), (int)4133);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void play() {
        int startBufferCount = Math.min(this.bufferCount, this.inputQueue.size());
        for (int i = 0; i < startBufferCount; ++i) {
            AudioData data = this.inputQueue.pop();
            AudioBuffer buffer = data.createBuffer();
            AL11.alSourcef((int)this.getSource(), (int)4099, (float)1.0f);
            List<Pair<Integer, Integer>> list = this.outputQueue;
            synchronized (list) {
                boolean bl = false;
                AL11.alSourceQueueBuffers((int)this.getSource(), (int)buffer.getBuffer());
                this.outputQueue.add((Pair<Integer, Integer>)new Pair((Object)buffer.getBuffer(), (Object)(data.getBuffer().capacity() / 4)));
                int n = this.queued;
                this.queued = n + 1;
                int n2 = n;
                continue;
            }
        }
        AL11.alSourcePlay((int)this.getSource());
        ThreadsKt.thread$default((boolean)false, (boolean)true, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ AudioQueueSource this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                boolean playing = true;
                while (true) {
                    List list;
                    AudioQueueSource audioQueueSource;
                    List list2;
                    if (AudioQueueSource.access$getInputQueue$p(this.this$0).size() < AudioQueueSource.access$getInputQueue$p(this.this$0).getMaxSize() - 1) {
                        AudioData data;
                        Function0 function0 = AudioQueueSource.access$getPullFunction$p(this.this$0);
                        AudioData audioData = data = function0 != null ? (AudioData)function0.invoke() : null;
                        if (data != null) {
                            AudioQueueSource.access$getInputQueue$p(this.this$0).push(data);
                        }
                    }
                    if (AudioQueueSource.access$getQueued$p(this.this$0) == 0) {
                        boolean observation;
                        boolean bl = observation = AL11.alGetSourcei((int)this.this$0.getSource(), (int)4112) == 4114;
                        if (!observation && playing) {
                            AudioPlayerKt.access$getLogger$p().debug((Function0)play.1.INSTANCE);
                            playing = false;
                        }
                    }
                    int buffersProcessed = AL11.alGetSourcei((int)this.this$0.getSource(), (int)4118);
                    AudioQueueSource audioQueueSource2 = this.this$0;
                    AudioQueueSource.access$setQueued$p(audioQueueSource2, AudioQueueSource.access$getQueued$p(audioQueueSource2) - buffersProcessed);
                    AudioQueueSource.access$setQueued$p(this.this$0, RangesKt.coerceAtLeast((int)AudioQueueSource.access$getQueued$p(this.this$0), (int)0));
                    for (int i = 0; i < buffersProcessed; ++i) {
                        int unqueue = AL11.alSourceUnqueueBuffers((int)this.this$0.getSource());
                        list2 = AudioQueueSource.access$getOutputQueue$p(this.this$0);
                        audioQueueSource = this.this$0;
                        list = list2;
                        synchronized (list) {
                            boolean $i$a$-synchronized-AudioQueueSource$play$2$42 = false;
                            if (!((Collection)AudioQueueSource.access$getOutputQueue$p(audioQueueSource)).isEmpty()) {
                                AL11.alDeleteBuffers((int)unqueue);
                                if (unqueue == ((Number)((Pair)AudioQueueSource.access$getOutputQueue$p(audioQueueSource).get(0)).getFirst()).intValue()) {
                                    AudioQueueSource.access$setBufferOffset$p(audioQueueSource, audioQueueSource.getBufferOffset() + ((Number)((Pair)AudioQueueSource.access$getOutputQueue$p(audioQueueSource).get(0)).getSecond()).longValue());
                                    AudioQueueSource.access$getOutputQueue$p(audioQueueSource).remove(0);
                                }
                            }
                            Unit $i$a$-synchronized-AudioQueueSource$play$2$42 = Unit.INSTANCE;
                            continue;
                        }
                    }
                    while (AudioQueueSource.access$getQueued$p(this.this$0) <= AudioQueueSource.access$getBufferCount$p(this.this$0) && !AudioQueueSource.access$getInputQueue$p(this.this$0).isEmpty()) {
                        AudioData data = (AudioData)AudioQueueSource.access$getInputQueue$p(this.this$0).pop();
                        AudioBuffer buffer = data.createBuffer();
                        list2 = AudioQueueSource.access$getOutputQueue$p(this.this$0);
                        audioQueueSource = this.this$0;
                        list = list2;
                        synchronized (list) {
                            boolean bl = false;
                            AudioQueueSource.access$getOutputQueue$p(audioQueueSource).add(new Pair((Object)buffer.getBuffer(), (Object)(data.getBuffer().capacity() / 4)));
                            AL11.alSourceQueueBuffers((int)audioQueueSource.getSource(), (int)buffer.getBuffer());
                            int n = AudioQueueSource.access$getQueued$p(audioQueueSource);
                            AudioQueueSource.access$setQueued$p(audioQueueSource, n + 1);
                            int n2 = n;
                        }
                    }
                    if (!playing && AudioQueueSource.access$getQueued$p(this.this$0) > 0) {
                        AudioPlayerKt.access$getLogger$p().debug((Function0)play.4.INSTANCE);
                        playing = true;
                        AL11.alSourcePlay((int)this.this$0.getSource());
                    }
                    Thread.sleep(0L);
                }
            }
        }), (int)29, null);
    }

    public final void stop() {
        this.flush();
    }

    public final void pause() {
        AL11.alSourcePause((int)this.getSource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        while (!this.inputQueue.isEmpty()) {
            this.inputQueue.pop();
        }
        AL11.alSourceStop((int)this.getSource());
        List<Pair<Integer, Integer>> list = this.outputQueue;
        synchronized (list) {
            boolean bl = false;
            for (Pair<Integer, Integer> i : this.outputQueue) {
                AL11.alDeleteBuffers((int)((Number)i.getFirst()).intValue());
            }
            this.outputQueue.clear();
            Unit unit = Unit.INSTANCE;
        }
        this.bufferOffset = 0L;
        this.queued = 0;
    }

    public final void resume() {
        AL11.alSourcePlay((int)this.getSource());
    }

    public final void dispose() {
        this.flush();
        AL11.alDeleteSources((int)this.getSource());
    }

    public static final /* synthetic */ Queue access$getInputQueue$p(AudioQueueSource $this) {
        return $this.inputQueue;
    }

    public static final /* synthetic */ Function0 access$getPullFunction$p(AudioQueueSource $this) {
        return $this.pullFunction;
    }

    public static final /* synthetic */ int access$getQueued$p(AudioQueueSource $this) {
        return $this.queued;
    }

    public static final /* synthetic */ void access$setQueued$p(AudioQueueSource $this, int n) {
        $this.queued = n;
    }

    public static final /* synthetic */ List access$getOutputQueue$p(AudioQueueSource $this) {
        return $this.outputQueue;
    }

    public static final /* synthetic */ int access$getBufferCount$p(AudioQueueSource $this) {
        return $this.bufferCount;
    }

    public static final /* synthetic */ void access$setBufferOffset$p(AudioQueueSource $this, long l) {
        $this.bufferOffset = l;
    }
}

