/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.openal;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\r\u0010\u000f\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0010J\u000b\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\r\u0010\u0012\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010\u0017\u001a\u00020\u0004R\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/openrndr/openal/Queue;", "T", "", "maxSize", "", "(I)V", "array", "", "[Ljava/lang/Object;", "head", "getMaxSize", "()I", "tail", "isEmpty", "", "peek", "()Ljava/lang/Object;", "pop", "popOrNull", "push", "", "element", "(Ljava/lang/Object;)V", "size", "openrndr-openal"})
public final class Queue<T> {
    private final int maxSize;
    @NotNull
    private final Object[] array;
    private int head;
    private int tail;

    public Queue(int maxSize) {
        this.maxSize = maxSize;
        this.array = new Object[this.maxSize];
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    public final void push(T element) {
        if ((this.tail + 1) % this.maxSize == this.head) {
            throw new Error("queue overflow: " + this.tail + " " + this.head);
        }
        this.array[this.tail] = element;
        this.tail = (this.tail + 1) % this.maxSize;
    }

    public final T pop() {
        if (this.tail == this.head) {
            throw new Error("queue underflow");
        }
        Object result = this.array[this.head];
        this.array[this.head] = null;
        this.head = (this.head + 1) % this.maxSize;
        return (T)result;
    }

    @Nullable
    public final T peek() {
        if (this.isEmpty()) {
            return null;
        }
        return (T)this.array[this.head];
    }

    public final int size() {
        return this.tail >= this.head ? this.tail - this.head : this.maxSize - (this.head - this.tail);
    }

    public final boolean isEmpty() {
        return this.head == this.tail;
    }

    @Nullable
    public final T popOrNull() {
        return this.isEmpty() ? null : (T)this.pop();
    }
}

