/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.svg;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openrndr.shape.CompositionStyleSheetKt;
import org.openrndr.shape.Style;
import org.openrndr.shape.Transform;
import org.openrndr.svg.Prop;
import org.openrndr.svg.SVGElement;
import org.openrndr.svg.SVGParse;
import org.openrndr.svg.SVGPath;
import org.openrndr.svg.Tag;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/openrndr/svg/SVGGroup;", "Lorg/openrndr/svg/SVGElement;", "element", "Lorg/jsoup/nodes/Element;", "elements", "", "(Lorg/jsoup/nodes/Element;Ljava/util/List;)V", "getElement", "()Lorg/jsoup/nodes/Element;", "getElements", "()Ljava/util/List;", "handleAttribute", "", "attribute", "Lorg/jsoup/nodes/Attribute;", "handleChildren", "openrndr-svg"})
@SourceDebugExtension(value={"SMAP\nSVGElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SVGElement.kt\norg/openrndr/svg/SVGGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,429:1\n1855#2,2:430\n1855#2,2:432\n*S KotlinDebug\n*F\n+ 1 SVGElement.kt\norg/openrndr/svg/SVGGroup\n*L\n62#1:430,2\n74#1:432,2\n*E\n"})
public class SVGGroup
extends SVGElement {
    @NotNull
    private final Element element;
    @NotNull
    private final List<SVGElement> elements;

    public SVGGroup(@NotNull Element element, @NotNull List<SVGElement> elements) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        super(element, null);
        this.element = element;
        this.elements = elements;
        Attributes attributes = this.element.attributes();
        Intrinsics.checkNotNullExpressionValue((Object)attributes, (String)"attributes(...)");
        Iterable $this$forEach$iv = (Iterable)attributes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Attribute it = (Attribute)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getKey(), (Object)"style")) {
                Intrinsics.checkNotNull((Object)it);
                this.inlineStyles(it);
                continue;
            }
            Intrinsics.checkNotNull((Object)it);
            this.handleAttribute(it);
        }
        this.handleChildren();
    }

    public /* synthetic */ SVGGroup(Element element, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = new ArrayList();
        }
        this(element, list);
    }

    @NotNull
    public final Element getElement() {
        return this.element;
    }

    @NotNull
    public final List<SVGElement> getElements() {
        return this.elements;
    }

    private final void handleChildren() {
        Elements elements = this.element.children();
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"children(...)");
        Iterable $this$forEach$iv = (Iterable)elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element child = (Element)element$iv;
            boolean bl = false;
            String string = child.tagName();
            if (Tag.INSTANCE.getGraphicsList().contains(string)) {
                this.elements.add(new SVGPath(child));
                continue;
            }
            Intrinsics.checkNotNull((Object)child);
            this.elements.add(new SVGGroup(child, null, 2, null));
        }
    }

    @Override
    public void handleAttribute(@NotNull Attribute attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        String string = attribute.getKey();
        if (Prop.INSTANCE.getList().contains(string)) {
            String string2 = attribute.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-key>(...)");
            String string3 = attribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-value>(...)");
            this.styleProperty(string2, string3);
        } else if (Intrinsics.areEqual((Object)string, (Object)"transform")) {
            CompositionStyleSheetKt.setTransform((Style)this.getStyle(), (Transform)SVGParse.INSTANCE.transform(this.element));
        }
    }
}

