/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.svg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchNamedGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.Linearity;
import org.openrndr.math.Matrix44;
import org.openrndr.math.transforms.TransformsKt;
import org.openrndr.shape.Align;
import org.openrndr.shape.AspectRatio;
import org.openrndr.shape.CompositionDimensions;
import org.openrndr.shape.Length;
import org.openrndr.shape.LineCap;
import org.openrndr.shape.LineJoin;
import org.openrndr.shape.MeetOrSlice;
import org.openrndr.shape.Numeric;
import org.openrndr.shape.Paint;
import org.openrndr.shape.RectangleKt;
import org.openrndr.shape.Transform;
import org.openrndr.shape.ViewBox;
import org.openrndr.svg.CSSColorNamesKt;
import org.openrndr.svg.Command;
import org.openrndr.svg.PropertyRegex;
import org.openrndr.svg.SVGParse;
import org.openrndr.svg.SVGParseKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u0006J.\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rJ\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\rJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\rJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010\r2\u0006\u0010 \u001a\u00020\rH\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\rJ\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110\bH\u0002J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010(\u001a\u00020)2\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\rH\u0002J\u000e\u0010-\u001a\u00020.2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010/\u001a\u0002002\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u00061"}, d2={"Lorg/openrndr/svg/SVGParse;", "", "()V", "bounds", "Lorg/openrndr/shape/CompositionDimensions;", "element", "Lorg/jsoup/nodes/Element;", "circle", "", "Lorg/openrndr/svg/Command;", "color", "Lorg/openrndr/shape/Paint;", "colorValue", "", "ellipse", "ellipsePath", "x", "", "y", "width", "height", "expandToTwoDigitsPerComponent", "hexValue", "length", "Lorg/openrndr/shape/Length;", "value", "line", "lineCap", "Lorg/openrndr/shape/LineCap;", "lineJoin", "Lorg/openrndr/shape/LineJoin;", "normalizeColorHex", "colorHex", "number", "Lorg/openrndr/shape/Numeric;", "path", "pointsToCommands", "numbers", "polygon", "polyline", "preserveAspectRatio", "Lorg/openrndr/shape/AspectRatio;", "rectangle", "rgbFunction", "rgbValue", "transform", "Lorg/openrndr/shape/Transform;", "viewBox", "Lorg/openrndr/shape/ViewBox;", "openrndr-svg"})
@SourceDebugExtension(value={"SMAP\nSVGParse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SVGParse.kt\norg/openrndr/svg/SVGParse\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,498:1\n1549#2:499\n1620#2,3:500\n1549#2:503\n1620#2,2:504\n1622#2:507\n1549#2:508\n1620#2,3:509\n1620#2,3:512\n959#2,7:515\n1549#2:522\n1620#2,3:523\n1549#2:526\n1620#2,3:527\n766#2:530\n857#2,2:531\n1549#2:533\n1620#2,3:534\n1#3:506\n2206#4,7:537\n*S KotlinDebug\n*F\n+ 1 SVGParse.kt\norg/openrndr/svg/SVGParse\n*L\n79#1:499\n79#1:500,3\n130#1:503\n130#1:504,2\n130#1:507\n137#1:508\n137#1:509,3\n299#1:512,3\n315#1:515,7\n316#1:522\n316#1:523,3\n418#1:526\n418#1:527,3\n489#1:530\n489#1:531,2\n490#1:533\n490#1:534,3\n497#1:537,7\n*E\n"})
public final class SVGParse {
    @NotNull
    public static final SVGParse INSTANCE = new SVGParse();

    private SVGParse() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ViewBox viewBox(@NotNull Element element) {
        List list;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.attr("viewBox");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
        String viewBoxValue = ((Object)StringsKt.trim((CharSequence)string)).toString();
        boolean it = PropertyRegex.NumberList.INSTANCE.getRegex().matches((CharSequence)viewBoxValue);
        boolean bl = false;
        if (!it) {
            return (ViewBox)ViewBox.None.INSTANCE;
        }
        Object object = viewBoxValue;
        Regex regex = PropertyRegex.Companion.getCommaWsp();
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$map2 = false;
        void var9_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(Double.parseDouble((String)p0));
        }
        List list2 = (List)destination$iv$iv;
        switch (list2.size()) {
            case 1: {
                if (((Number)list2.get(0)).doubleValue() == 0.0) {
                    return (ViewBox)ViewBox.None.INSTANCE;
                }
                Object[] $i$f$map2 = new Double[]{0.0, 0.0, 0.0, list2.get(0)};
                list = CollectionsKt.listOf((Object[])$i$f$map2);
                break;
            }
            case 2: {
                Object[] $i$f$map2 = new Double[]{0.0, 0.0, list2.get(0), list2.get(1)};
                list = CollectionsKt.listOf((Object[])$i$f$map2);
                break;
            }
            case 3: {
                Object[] $i$f$map2 = new Double[]{0.0, list2.get(0), list2.get(1), list2.get(2)};
                list = CollectionsKt.listOf((Object[])$i$f$map2);
                break;
            }
            case 4: {
                list = list2;
                break;
            }
            default: {
                return (ViewBox)ViewBox.None.INSTANCE;
            }
        }
        List list3 = list;
        double minX = ((Number)list3.get(0)).doubleValue();
        double minY = ((Number)list3.get(1)).doubleValue();
        double width = ((Number)list3.get(2)).doubleValue();
        double height = ((Number)list3.get(3)).doubleValue();
        return (ViewBox)new ViewBox.Value(RectangleKt.Rectangle((double)minX, (double)minY, (double)RangesKt.coerceAtLeast((double)width, (double)0.0), (double)RangesKt.coerceAtLeast((double)height, (double)0.0)));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final AspectRatio preserveAspectRatio(@NotNull Element element) {
        AspectRatio aspectRatio;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String aspectRatioValue = element.attr("preserveAspectRatio");
        Regex regex = PropertyRegex.PreserveAspectRatio.INSTANCE.getRegex();
        Intrinsics.checkNotNull((Object)aspectRatioValue);
        MatchResult it = regex.matchEntire((CharSequence)aspectRatioValue);
        boolean bl = false;
        MatchResult matchResult = it;
        Object object = matchResult != null ? matchResult.getGroups() : null;
        MatchNamedGroupCollection matchNamedGroupCollection = object instanceof MatchNamedGroupCollection ? (MatchNamedGroupCollection)object : null;
        String value = matchNamedGroupCollection != null && (matchNamedGroupCollection = matchNamedGroupCollection.get("align")) != null ? matchNamedGroupCollection.getValue() : null;
        MatchResult matchResult2 = it;
        MatchGroupCollection matchGroupCollection = matchResult2 != null ? matchResult2.getGroups() : null;
        MatchNamedGroupCollection matchNamedGroupCollection2 = matchGroupCollection instanceof MatchNamedGroupCollection ? (MatchNamedGroupCollection)matchGroupCollection : null;
        String type = matchNamedGroupCollection2 != null && (matchNamedGroupCollection2 = matchNamedGroupCollection2.get("meetOrSlice")) != null ? matchNamedGroupCollection2.getValue() : null;
        Pair pair = TuplesKt.to((Object)value, (Object)type);
        String alignmentValue = (String)pair.component1();
        String meetValue = (String)pair.component2();
        MeetOrSlice meet = Intrinsics.areEqual((Object)meetValue, (Object)"slice") ? MeetOrSlice.SLICE : MeetOrSlice.MEET;
        object = alignmentValue;
        if (object != null) {
            int n = -1;
            switch (((String)object).hashCode()) {
                case 1192728087: {
                    if (!((String)object).equals("xMaxYMax")) break;
                    n = 1;
                    break;
                }
                case 1412526323: {
                    if (!((String)object).equals("xMinYMin")) break;
                    n = 2;
                    break;
                }
                case 1192728325: {
                    if (!((String)object).equals("xMaxYMin")) break;
                    n = 3;
                    break;
                }
                case 1412526085: {
                    if (!((String)object).equals("xMinYMax")) break;
                    n = 4;
                    break;
                }
                case 1412526313: {
                    if (!((String)object).equals("xMinYMid")) break;
                    n = 5;
                    break;
                }
                case 3387192: {
                    if (!((String)object).equals("none")) break;
                    n = 6;
                    break;
                }
                case 1403291103: {
                    if (!((String)object).equals("xMidYMid")) break;
                    n = 7;
                    break;
                }
                case 1192728315: {
                    if (!((String)object).equals("xMaxYMid")) break;
                    n = 8;
                    break;
                }
                case 1403291113: {
                    if (!((String)object).equals("xMidYMin")) break;
                    n = 9;
                    break;
                }
                case 1403290875: {
                    if (!((String)object).equals("xMidYMax")) break;
                    n = 10;
                    break;
                }
            }
            switch (n) {
                case 6: {
                    aspectRatio = new AspectRatio(Align.NONE, meet);
                    return aspectRatio;
                }
                case 2: {
                    aspectRatio = new AspectRatio(Align.X_MIN_Y_MIN, meet);
                    return aspectRatio;
                }
                case 9: {
                    aspectRatio = new AspectRatio(Align.X_MID_Y_MIN, meet);
                    return aspectRatio;
                }
                case 3: {
                    aspectRatio = new AspectRatio(Align.X_MAX_Y_MIN, meet);
                    return aspectRatio;
                }
                case 5: {
                    aspectRatio = new AspectRatio(Align.X_MIN_Y_MID, meet);
                    return aspectRatio;
                }
                case 7: {
                    aspectRatio = new AspectRatio(Align.X_MID_Y_MID, meet);
                    return aspectRatio;
                }
                case 8: {
                    aspectRatio = new AspectRatio(Align.X_MAX_Y_MID, meet);
                    return aspectRatio;
                }
                case 4: {
                    aspectRatio = new AspectRatio(Align.X_MIN_Y_MAX, meet);
                    return aspectRatio;
                }
                case 10: {
                    aspectRatio = new AspectRatio(Align.X_MID_Y_MAX, meet);
                    return aspectRatio;
                }
                case 1: {
                    aspectRatio = new AspectRatio(Align.X_MAX_Y_MAX, meet);
                    return aspectRatio;
                }
            }
        }
        aspectRatio = new AspectRatio(Align.X_MID_Y_MID, meet);
        return aspectRatio;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompositionDimensions bounds(@NotNull Element element) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object object = new String[]{"x", "y", "width", "height"};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])object);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            CharSequence charSequence;
            void attribute;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String it = element.attr((String)attribute);
            boolean bl2 = false;
            CharSequence charSequence2 = it;
            if (charSequence2.length() == 0) {
                boolean bl3 = false;
                charSequence = "0";
            } else {
                charSequence = charSequence2;
            }
            collection.add((String)charSequence);
        }
        List values = (List)destination$iv$iv;
        Iterable $this$map$iv2 = values;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Length.Pixels pixels;
            Object object2;
            double value;
            block17: {
                block16: {
                    void str;
                    String bl = (String)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl4 = false;
                    Regex regex = PropertyRegex.Length.INSTANCE.getRegex();
                    Intrinsics.checkNotNull((Object)str);
                    MatchResult it = regex.matchEntire((CharSequence)str);
                    boolean bl5 = false;
                    MatchResult matchResult = it;
                    MatchGroupCollection matchGroupCollection = matchResult != null ? matchResult.getGroups() : null;
                    Object object3 = matchGroupCollection instanceof MatchNamedGroupCollection ? (MatchNamedGroupCollection)matchGroupCollection : null;
                    value = object3 != null && (object3 = object3.get("number")) != null && (object3 = object3.getValue()) != null ? Double.parseDouble((String)object3) : 0.0;
                    MatchResult matchResult2 = it;
                    MatchGroupCollection matchGroupCollection2 = matchResult2 != null ? matchResult2.getGroups() : null;
                    object2 = matchGroupCollection2 instanceof MatchNamedGroupCollection ? (MatchNamedGroupCollection)matchGroupCollection2 : null;
                    if (object2 == null || (object2 = object2.get("ident")) == null || (object2 = object2.getValue()) == null) break block16;
                    String string = ((String)object2).toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                    object2 = string;
                    if (string != null) break block17;
                }
                object2 = "PX";
            }
            Length.UnitIdentifier type = Length.UnitIdentifier.valueOf((String)object2);
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    pixels = Length.Pixels.Companion.fromInches(value);
                    break;
                }
                case 2: {
                    pixels = Length.Pixels.Companion.fromPicas(value);
                    break;
                }
                case 3: {
                    pixels = Length.Pixels.Companion.fromPoints(value);
                    break;
                }
                case 4: {
                    pixels = new Length.Pixels(value);
                    break;
                }
                case 5: {
                    pixels = Length.Pixels.Companion.fromCentimeters(value);
                    break;
                }
                case 6: {
                    pixels = Length.Pixels.Companion.fromMillimeters(value);
                    break;
                }
                case 7: {
                    pixels = Length.Pixels.Companion.fromQuarterMillimeters(value);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            collection.add(pixels);
        }
        object = (List)destination$iv$iv2;
        Length.Pixels x = (Length.Pixels)object.get(0);
        Length.Pixels y = (Length.Pixels)object.get(1);
        Length.Pixels width = (Length.Pixels)object.get(2);
        Length.Pixels height = (Length.Pixels)object.get(3);
        return new CompositionDimensions((Length)x, (Length)y, (Length)width, (Length)height);
    }

    @NotNull
    public final LineJoin lineJoin(@NotNull String value) {
        LineJoin lineJoin;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (value) {
            case "miter": {
                lineJoin = (LineJoin)LineJoin.Miter.INSTANCE;
                break;
            }
            case "bevel": {
                lineJoin = (LineJoin)LineJoin.Bevel.INSTANCE;
                break;
            }
            case "round": {
                lineJoin = (LineJoin)LineJoin.Round.INSTANCE;
                break;
            }
            default: {
                lineJoin = (LineJoin)LineJoin.Miter.INSTANCE;
            }
        }
        return lineJoin;
    }

    @NotNull
    public final LineCap lineCap(@NotNull String value) {
        LineCap lineCap;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (value) {
            case "round": {
                lineCap = (LineCap)LineCap.Round.INSTANCE;
                break;
            }
            case "butt": {
                lineCap = (LineCap)LineCap.Butt.INSTANCE;
                break;
            }
            case "square": {
                lineCap = (LineCap)LineCap.Square.INSTANCE;
                break;
            }
            default: {
                lineCap = (LineCap)LineCap.Butt.INSTANCE;
            }
        }
        return lineCap;
    }

    @NotNull
    public final Numeric number(@NotNull String value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        MatchResult match = PropertyRegex.Number.INSTANCE.getRegex().matchEntire((CharSequence)value);
        return match != null ? (Numeric)new Numeric.Rational((object = match.getGroups().get(0)) != null && (object = object.getValue()) != null ? Double.parseDouble((String)object) : 0.0) : (Numeric)new Numeric.Rational(0.0);
    }

    @NotNull
    public final Length length(@NotNull String value) {
        Length length;
        Object object;
        double number;
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                MatchResult it = PropertyRegex.Length.INSTANCE.getRegex().matchEntire((CharSequence)value);
                boolean bl = false;
                MatchResult matchResult = it;
                MatchGroupCollection matchGroupCollection = matchResult != null ? matchResult.getGroups() : null;
                Object object2 = matchGroupCollection instanceof MatchNamedGroupCollection ? (MatchNamedGroupCollection)matchGroupCollection : null;
                number = object2 != null && (object2 = object2.get("number")) != null && (object2 = object2.getValue()) != null ? Double.parseDouble((String)object2) : 0.0;
                MatchResult matchResult2 = it;
                MatchGroupCollection matchGroupCollection2 = matchResult2 != null ? matchResult2.getGroups() : null;
                object = matchGroupCollection2 instanceof MatchNamedGroupCollection ? (MatchNamedGroupCollection)matchGroupCollection2 : null;
                if (object == null || (object = object.get("ident")) == null || (object = object.getValue()) == null) break block11;
                String string = ((String)object).toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                object = string;
                if (string != null) break block12;
            }
            object = "PX";
        }
        Length.UnitIdentifier ident = Length.UnitIdentifier.valueOf((String)object);
        Pair pair = TuplesKt.to((Object)number, (Object)ident);
        double number2 = ((Number)pair.component1()).doubleValue();
        Length.UnitIdentifier ident2 = (Length.UnitIdentifier)pair.component2();
        switch (WhenMappings.$EnumSwitchMapping$0[ident2.ordinal()]) {
            case 1: {
                length = (Length)Length.Pixels.Companion.fromInches(number2);
                break;
            }
            case 2: {
                length = (Length)Length.Pixels.Companion.fromPicas(number2);
                break;
            }
            case 3: {
                length = (Length)Length.Pixels.Companion.fromPoints(number2);
                break;
            }
            case 4: {
                length = (Length)new Length.Pixels(number2);
                break;
            }
            case 5: {
                length = (Length)Length.Pixels.Companion.fromCentimeters(number2);
                break;
            }
            case 6: {
                length = (Length)Length.Pixels.Companion.fromMillimeters(number2);
                break;
            }
            case 7: {
                length = (Length)Length.Pixels.Companion.fromQuarterMillimeters(number2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return length;
    }

    @NotNull
    public final Transform transform(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Matrix44 transform = Matrix44.Companion.getIDENTITY();
        String it = element.attr("transform");
        boolean bl = false;
        CharSequence charSequence = it;
        if (charSequence.length() == 0) {
            boolean bl2 = false;
            return (Transform)Transform.None.INSTANCE;
        }
        String transformValue = (String)charSequence;
        Pattern p = Pattern.compile("(matrix|translate|scale|rotate|skewX|skewY)\\([\\d\\.,\\-\\s]+\\)");
        Matcher m = p.matcher(transformValue);
        while (m.find()) {
            Double d;
            Matrix44.Companion companion;
            double d2;
            int n;
            List<Double> list;
            List<Double> operands;
            String token = m.group();
            Intrinsics.checkNotNull((Object)token);
            if (StringsKt.startsWith$default((String)token, (String)"matrix", (boolean)false, (int)2, null)) {
                operands = SVGParse.transform$getTransformOperands(token);
                Matrix44 mat = new Matrix44(((Number)operands.get(0)).doubleValue(), ((Number)operands.get(2)).doubleValue(), 0.0, ((Number)operands.get(4)).doubleValue(), ((Number)operands.get(1)).doubleValue(), ((Number)operands.get(3)).doubleValue(), 0.0, ((Number)operands.get(5)).doubleValue(), 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
                transform = transform.times(mat);
            }
            if (StringsKt.startsWith$default((String)token, (String)"scale", (boolean)false, (int)2, null)) {
                Double d3;
                String string = token.substring(5);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                operands = SVGParse.transform$getTransformOperands(string);
                Matrix44.Companion companion2 = Matrix44.Companion;
                double d4 = ((Number)operands.get(0)).doubleValue();
                list = operands;
                n = 1;
                if (n <= CollectionsKt.getLastIndex(list)) {
                    d3 = list.get(n);
                } else {
                    int n2 = n;
                    d2 = d4;
                    companion = companion2;
                    boolean bl3 = false;
                    d = ((Number)operands.get(0)).doubleValue();
                    companion2 = companion;
                    d4 = d2;
                    d3 = d;
                }
                Matrix44 mat = TransformsKt.scale((Matrix44.Companion)companion2, (double)d4, (double)((Number)d3).doubleValue(), (double)0.0);
                transform = transform.times(mat);
            }
            if (StringsKt.startsWith$default((String)token, (String)"translate", (boolean)false, (int)2, null)) {
                Double d5;
                String string = token.substring(9);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                operands = SVGParse.transform$getTransformOperands(string);
                Matrix44.Companion companion3 = Matrix44.Companion;
                double d6 = ((Number)operands.get(0)).doubleValue();
                list = operands;
                n = 1;
                if (n <= CollectionsKt.getLastIndex(list)) {
                    d5 = list.get(n);
                } else {
                    int it2 = n;
                    d2 = d6;
                    companion = companion3;
                    boolean bl4 = false;
                    d = 0.0;
                    companion3 = companion;
                    d6 = d2;
                    d5 = d;
                }
                Matrix44 mat = TransformsKt.translate((Matrix44.Companion)companion3, (double)d6, (double)((Number)d5).doubleValue(), (double)0.0);
                transform = transform.times(mat);
            }
            if (StringsKt.startsWith$default((String)token, (String)"rotate", (boolean)false, (int)2, null)) {
                Double d7;
                Double d8;
                String string = token.substring(6);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                operands = SVGParse.transform$getTransformOperands(string);
                double angle = Math.toRadians(((Number)operands.get(0)).doubleValue());
                double sina = Math.sin(angle);
                double cosa = Math.cos(angle);
                List<Double> list2 = operands;
                int n3 = 1;
                if (n3 <= CollectionsKt.getLastIndex(list2)) {
                    d8 = list2.get(n3);
                } else {
                    int it3 = n3;
                    boolean bl5 = false;
                    d8 = 0.0;
                }
                double x = ((Number)d8).doubleValue();
                List<Double> it3 = operands;
                int n4 = 2;
                if (n4 <= CollectionsKt.getLastIndex(it3)) {
                    d7 = it3.get(n4);
                } else {
                    int it4 = n4;
                    boolean bl6 = false;
                    d7 = 0.0;
                }
                double y = ((Number)d7).doubleValue();
                Matrix44 mat = new Matrix44(cosa, -sina, 0.0, -x * cosa + y * sina + x, sina, cosa, 0.0, -x * sina - y * cosa + y, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
                transform = transform.times(mat);
            }
            if (StringsKt.startsWith$default((String)token, (String)"skewX", (boolean)false, (int)2, null)) {
                String string = token.substring(5);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                operands = SVGParse.transform$getTransformOperands(string);
                Matrix44 mat = new Matrix44(1.0, Math.tan(Math.toRadians(((Number)operands.get(0)).doubleValue())), 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
                transform = transform.times(mat);
            }
            if (!StringsKt.startsWith$default((String)token, (String)"skewY", (boolean)false, (int)2, null)) continue;
            String string = token.substring(5);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            operands = SVGParse.transform$getTransformOperands(string);
            Matrix44 mat = new Matrix44(1.0, 0.0, 0.0, 0.0, Math.tan(Math.toRadians(((Number)operands.get(0)).doubleValue())), 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            transform = transform.times(mat);
        }
        return !Intrinsics.areEqual((Object)transform, (Object)Matrix44.Companion.getIDENTITY()) ? (Transform)new Transform.Matrix(transform) : (Transform)Transform.None.INSTANCE;
    }

    private final List<Command> pointsToCommands(List<Double> numbers) {
        Object[] objectArray = new Command[1];
        double[] dArray = new double[]{((Number)numbers.get(0)).doubleValue(), ((Number)numbers.get(1)).doubleValue()};
        objectArray[0] = new Command("M", dArray);
        List commands = CollectionsKt.mutableListOf((Object[])objectArray);
        Iterable $this$mapTo$iv = CollectionsKt.windowed((Iterable)CollectionsKt.drop((Iterable)numbers, (int)2), (int)2, (int)2, (boolean)false);
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            List list = (List)item$iv;
            Collection collection = commands;
            boolean bl = false;
            double x = ((Number)list.get(0)).doubleValue();
            double y = ((Number)list.get(1)).doubleValue();
            double[] dArray2 = new double[]{x, y};
            collection.add(new Command("L", dArray2));
        }
        return commands;
    }

    @NotNull
    public final List<Command> polygon(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List commands = CollectionsKt.toMutableList((Collection)this.polyline(element));
        commands.add(new Command("Z", new double[0]));
        return commands;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Command> polyline(@NotNull Element element) {
        List<Command> list;
        void $this$mapTo$iv$iv;
        void $this$takeWhile$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.attr("points");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
        Object object = ((Object)StringsKt.trim((CharSequence)string)).toString();
        Regex regex = PropertyRegex.Companion.getCommaWsp();
        int n = 0;
        object = regex.split((CharSequence)object, n);
        regex = PropertyRegex.Number.INSTANCE.getRegex();
        boolean $i$f$takeWhile22 = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            CharSequence p0 = (CharSequence)item$iv;
            boolean bl = false;
            if (!regex.matches(p0)) break;
            list$iv.add(item$iv);
        }
        Iterable $this$map$iv = list$iv;
        boolean $i$f$map = false;
        Iterable $i$f$takeWhile22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String bl = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(Double.parseDouble((String)p0));
        }
        List numbers = (List)destination$iv$iv;
        if (numbers.size() > 1) {
            if ((numbers.size() & 1) == 1) {
                SVGParseKt.access$getLogger$p().warn((Function0)new Function0<Object>(element){
                    final /* synthetic */ Element $element;
                    {
                        this.$element = $element;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return this.$element.tagName() + " attribute points has odd amount of numbers";
                    }
                });
                list = this.pointsToCommands(CollectionsKt.dropLast((List)numbers, (int)1));
            } else {
                list = this.pointsToCommands(numbers);
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<Command> ellipsePath(double x, double y, double width, double height) {
        double dx = x - width / (double)2;
        double dy = y - height / (double)2;
        double kappa = 0.5522848;
        double ox = width / (double)2 * kappa;
        double oy = height / (double)2 * kappa;
        double xe = dx + width;
        double ye = dy + height;
        Object[] objectArray = new Command[6];
        double[] dArray = new double[]{dx, y};
        objectArray[0] = new Command("M", dArray);
        dArray = new double[]{dx, y - oy, x - ox, dy, x, dy};
        objectArray[1] = new Command("C", dArray);
        dArray = new double[]{x + ox, dy, xe, y - oy, xe, y};
        objectArray[2] = new Command("C", dArray);
        dArray = new double[]{xe, y + oy, x + ox, ye, x, ye};
        objectArray[3] = new Command("C", dArray);
        dArray = new double[]{x - ox, ye, dx, y + oy, dx, y};
        objectArray[4] = new Command("C", dArray);
        objectArray[5] = new Command("z", new double[0]);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<Command> circle(@NotNull Element element) {
        Double d;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String it = element.attr("cx");
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        Double d2 = ((CharSequence)it).length() == 0 ? Double.valueOf(0.0) : StringsKt.toDoubleOrNull((String)it);
        if (d2 == null) {
            return CollectionsKt.emptyList();
        }
        double cx = d2;
        String it2 = element.attr("cy");
        boolean bl2 = false;
        Intrinsics.checkNotNull((Object)it2);
        Double d3 = ((CharSequence)it2).length() == 0 ? Double.valueOf(0.0) : StringsKt.toDoubleOrNull((String)it2);
        if (d3 == null) {
            return CollectionsKt.emptyList();
        }
        double cy = d3;
        String it3 = element.attr("r");
        boolean bl3 = false;
        Intrinsics.checkNotNull((Object)it3);
        if (((CharSequence)it3).length() == 0) {
            d = 0.0;
        } else {
            Double d4 = StringsKt.toDoubleOrNull((String)it3);
            d = d4 != null ? Double.valueOf(d4 * 2.0) : null;
        }
        if (d == null) {
            return CollectionsKt.emptyList();
        }
        double r = d;
        return this.ellipsePath(cx, cy, r, r);
    }

    @NotNull
    public final List<Command> ellipse(@NotNull Element element) {
        Double d;
        Double d2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String it = element.attr("cx");
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        Double d3 = ((CharSequence)it).length() == 0 ? Double.valueOf(0.0) : StringsKt.toDoubleOrNull((String)it);
        if (d3 == null) {
            return CollectionsKt.emptyList();
        }
        double cx = d3;
        String it2 = element.attr("cy");
        boolean bl2 = false;
        Intrinsics.checkNotNull((Object)it2);
        Double d4 = ((CharSequence)it2).length() == 0 ? Double.valueOf(0.0) : StringsKt.toDoubleOrNull((String)it2);
        if (d4 == null) {
            return CollectionsKt.emptyList();
        }
        double cy = d4;
        String it3 = element.attr("rx");
        boolean bl3 = false;
        Intrinsics.checkNotNull((Object)it3);
        if (((CharSequence)it3).length() == 0) {
            d2 = 0.0;
        } else {
            Double d5 = StringsKt.toDoubleOrNull((String)it3);
            d2 = d5 != null ? Double.valueOf(d5 * 2.0) : null;
        }
        if (d2 == null) {
            return CollectionsKt.emptyList();
        }
        double rx = d2;
        String it4 = element.attr("ry");
        boolean bl4 = false;
        Intrinsics.checkNotNull((Object)it4);
        if (((CharSequence)it4).length() == 0) {
            d = 0.0;
        } else {
            Double d6 = StringsKt.toDoubleOrNull((String)it4);
            d = d6 != null ? Double.valueOf(d6 * 2.0) : null;
        }
        if (d == null) {
            return CollectionsKt.emptyList();
        }
        double ry = d;
        return this.ellipsePath(cx, cy, rx, ry);
    }

    @NotNull
    public final List<Command> rectangle(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String it = element.attr("x");
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        Double d = ((CharSequence)it).length() == 0 ? Double.valueOf(0.0) : StringsKt.toDoubleOrNull((String)it);
        if (d == null) {
            return CollectionsKt.emptyList();
        }
        double x = d;
        String it2 = element.attr("y");
        boolean bl2 = false;
        Intrinsics.checkNotNull((Object)it2);
        Double d2 = ((CharSequence)it2).length() == 0 ? Double.valueOf(0.0) : StringsKt.toDoubleOrNull((String)it2);
        if (d2 == null) {
            return CollectionsKt.emptyList();
        }
        double y = d2;
        String string = element.attr("width");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
        Double d3 = StringsKt.toDoubleOrNull((String)string);
        if (d3 == null) {
            return CollectionsKt.emptyList();
        }
        double width = d3;
        String string2 = element.attr("height");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"attr(...)");
        Double d4 = StringsKt.toDoubleOrNull((String)string2);
        if (d4 == null) {
            return CollectionsKt.emptyList();
        }
        double height = d4;
        Object[] objectArray = new Command[5];
        double[] dArray = new double[]{x, y};
        objectArray[0] = new Command("M", dArray);
        dArray = new double[]{width};
        objectArray[1] = new Command("h", dArray);
        dArray = new double[]{height};
        objectArray[2] = new Command("v", dArray);
        dArray = new double[]{-width};
        objectArray[3] = new Command("h", dArray);
        objectArray[4] = new Command("z", new double[0]);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<Command> line(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.attr("x1");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
        Double d = StringsKt.toDoubleOrNull((String)string);
        if (d == null) {
            return CollectionsKt.emptyList();
        }
        double x1 = d;
        String string2 = element.attr("x2");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"attr(...)");
        Double d2 = StringsKt.toDoubleOrNull((String)string2);
        if (d2 == null) {
            return CollectionsKt.emptyList();
        }
        double x2 = d2;
        String string3 = element.attr("y1");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"attr(...)");
        Double d3 = StringsKt.toDoubleOrNull((String)string3);
        if (d3 == null) {
            return CollectionsKt.emptyList();
        }
        double y1 = d3;
        String string4 = element.attr("y2");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"attr(...)");
        Double d4 = StringsKt.toDoubleOrNull((String)string4);
        if (d4 == null) {
            return CollectionsKt.emptyList();
        }
        double y2 = d4;
        Object[] objectArray = new Command[2];
        double[] dArray = new double[]{x1, y1};
        objectArray[0] = new Command("M", dArray);
        dArray = new double[]{x2, y2};
        objectArray[1] = new Command("L", dArray);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Command> path(@NotNull Element element) {
        Object object;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String pathValue = element.attr("d");
        Intrinsics.checkNotNull((Object)pathValue);
        if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)pathValue)).toString(), (Object)"none")) {
            return CollectionsKt.emptyList();
        }
        Object object2 = pathValue;
        Regex regex = new Regex("(?=[MmZzLlHhVvCcSsQqTtAa])");
        int n = 0;
        object2 = regex.split((CharSequence)object2, n);
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            object = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)p0))).toString());
        }
        List rawCommands = (List)destination$iv$iv;
        Pattern numbers = Pattern.compile("[-+]?[0-9]*[.]?[0-9]+(?:[eE][-+]?[0-9]+)?");
        List commands = new ArrayList();
        for (String rawCommand : rawCommands) {
            if (!(((CharSequence)rawCommand).length() > 0)) continue;
            Matcher numberMatcher = numbers.matcher(rawCommand);
            List operands = new ArrayList();
            while (numberMatcher.find()) {
                String string = numberMatcher.group();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                operands.add(Double.parseDouble(string));
            }
            Collection collection = commands;
            object = CollectionsKt.toDoubleArray((Collection)operands);
            collection.add(new Command(String.valueOf(rawCommand.charAt(0)), Arrays.copyOf((double[])object, ((Object)object).length)));
        }
        return commands;
    }

    @NotNull
    public final Paint color(@NotNull String colorValue) {
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)colorValue, (String)"colorValue");
        String string = colorValue.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String col = string;
        if (((CharSequence)col).length() == 0) {
            paint = (Paint)Paint.None.INSTANCE;
        } else if (StringsKt.startsWith$default((String)col, (String)"#", (boolean)false, (int)2, null)) {
            String string2 = this.normalizeColorHex(col);
            if (string2 == null) {
                return (Paint)Paint.None.INSTANCE;
            }
            String normalizedColor = string2;
            long v = Long.parseLong(normalizedColor, CharsKt.checkRadix((int)16));
            int vi = (int)v;
            int r = vi >> 16 & 0xFF;
            int g = vi >> 8 & 0xFF;
            int b = vi & 0xFF;
            paint = (Paint)new Paint.RGB(new ColorRGBa((double)r / 255.0, (double)g / 255.0, (double)b / 255.0, 0.0, Linearity.SRGB, 8, null));
        } else if (StringsKt.startsWith$default((String)col, (String)"rgb(", (boolean)false, (int)2, null)) {
            paint = this.rgbFunction(col);
        } else if (CSSColorNamesKt.getCssColorNames().containsKey(col)) {
            Integer n = CSSColorNamesKt.getCssColorNames().get(col);
            Intrinsics.checkNotNull((Object)n);
            paint = (Paint)new Paint.RGB(ColorRGBa.Companion.fromHex(((Number)n).intValue()));
        } else {
            paint = (Paint)Paint.None.INSTANCE;
        }
        return paint;
    }

    private final String normalizeColorHex(String colorHex) {
        String string;
        MatchResult matchResult = PropertyRegex.RGBHex.INSTANCE.getRegex().matchEntire((CharSequence)colorHex);
        if (matchResult == null) {
            return null;
        }
        MatchResult matchResult2 = matchResult;
        MatchGroup matchGroup = matchResult2.getGroups().get(1);
        Intrinsics.checkNotNull((Object)matchGroup);
        String string2 = matchGroup.getValue().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String hexValue = string2;
        switch (hexValue.length()) {
            case 3: {
                string = this.expandToTwoDigitsPerComponent("f" + hexValue);
                break;
            }
            case 6: {
                string = hexValue;
                break;
            }
            default: {
                return null;
            }
        }
        String normalizedArgb = string;
        return normalizedArgb;
    }

    /*
     * WARNING - void declaration
     */
    private final Paint rgbFunction(String rgbValue) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String p0;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        MatchResult matchResult = PropertyRegex.RGBFunctional.INSTANCE.getRegex().matchEntire((CharSequence)rgbValue);
        if (matchResult == null) {
            return (Paint)Paint.None.INSTANCE;
        }
        MatchResult result = matchResult;
        double divisor = result.getGroups().get(1) == null ? 100.0 : 255.0;
        Iterable iterable = CollectionsKt.drop((Iterable)result.getGroupValues(), (int)1);
        boolean $i$f$filter = false;
        void var8_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            p0 = (String)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.isBlank((CharSequence)p0))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p0 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)((Object)RangesKt.coerceIn((Comparable)Double.valueOf(Double.parseDouble((String)it)), (ClosedFloatingPointRange)RangesKt.rangeTo((double)0.0, (double)divisor)))).doubleValue() / divisor);
        }
        List list = (List)destination$iv$iv;
        double r = ((Number)list.get(0)).doubleValue();
        double g = ((Number)list.get(1)).doubleValue();
        double b = ((Number)list.get(2)).doubleValue();
        return (Paint)new Paint.RGB(new ColorRGBa(r, g, b, 0.0, Linearity.SRGB, 8, null));
    }

    /*
     * WARNING - void declaration
     */
    private final String expandToTwoDigitsPerComponent(String hexValue) {
        Sequence $this$reduce$iv = SequencesKt.map((Sequence)StringsKt.asSequence((CharSequence)hexValue), (Function1)expandToTwoDigitsPerComponent.1.INSTANCE);
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty sequence can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void p1;
            Object e = iterator$iv.next();
            String p0 = (String)accumulator$iv;
            boolean bl = false;
            accumulator$iv = p0 + p1;
        }
        return (String)accumulator$iv;
    }

    private static final List<Double> transform$getTransformOperands(String token) {
        Pattern number = Pattern.compile("-?[0-9.eE\\-]+");
        Matcher nm = number.matcher(token);
        List operands = new ArrayList();
        while (nm.find()) {
            String string = nm.group();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            double n = Double.parseDouble(string);
            operands.add(n);
        }
        return operands;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Length.UnitIdentifier.values().length];
            try {
                nArray[Length.UnitIdentifier.IN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Length.UnitIdentifier.PC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Length.UnitIdentifier.PT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Length.UnitIdentifier.PX.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Length.UnitIdentifier.CM.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Length.UnitIdentifier.MM.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Length.UnitIdentifier.Q.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

