/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.svg;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Entities;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.math.Vector2;
import org.openrndr.shape.AttributeOrPropertyKey;
import org.openrndr.shape.AttributeOrPropertyValue;
import org.openrndr.shape.Composition;
import org.openrndr.shape.CompositionNode;
import org.openrndr.shape.GroupNode;
import org.openrndr.shape.ImageNode;
import org.openrndr.shape.Segment;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeNode;
import org.openrndr.shape.Styleable;
import org.openrndr.shape.TextNode;
import org.openrndr.svg.VisitStage;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a>\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2,\u0010\u0010\u001a(\u0012\u0004\u0012\u00020\b\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u000e0\u0011\u00a2\u0006\u0002\b\u0016H\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0001\u001a\u0012\u0010\u001b\u001a\u00020\u000e*\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u0018\u0010\u001e\u001a\u00020\u0001*\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u001fH\u0002\u001a\n\u0010!\u001a\u00020\u0001*\u00020\u0019\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\u0001*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0018\u0010\u000b\u001a\u00020\u0001*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\""}, d2={"svg", "", "Lorg/openrndr/shape/Shape;", "getSvg", "(Lorg/openrndr/shape/Shape;)Ljava/lang/String;", "Lorg/openrndr/shape/ShapeContour;", "(Lorg/openrndr/shape/ShapeContour;)Ljava/lang/String;", "svgAttributes", "Lorg/openrndr/shape/CompositionNode;", "getSvgAttributes", "(Lorg/openrndr/shape/CompositionNode;)Ljava/lang/String;", "svgId", "getSvgId", "process", "", "compositionNode", "visitor", "Lkotlin/Function2;", "Lorg/openrndr/svg/VisitStage;", "Lkotlin/ParameterName;", "name", "stage", "Lkotlin/ExtensionFunctionType;", "writeSVG", "composition", "Lorg/openrndr/shape/Composition;", "topLevelId", "saveToFile", "file", "Ljava/io/File;", "serialize", "Lorg/openrndr/shape/Styleable;", "parentStyleable", "toSVG", "openrndr-svg"})
@SourceDebugExtension(value={"SMAP\nSVGWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SVGWriter.kt\norg/openrndr/svg/SVGWriterKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n125#2:195\n152#2,3:196\n215#2,2:206\n215#2,2:208\n125#2:210\n152#2,3:211\n526#3:199\n511#3,6:200\n1855#4:214\n1864#4,3:215\n1856#4:218\n1864#4,3:219\n1855#4,2:222\n*S KotlinDebug\n*F\n+ 1 SVGWriter.kt\norg/openrndr/svg/SVGWriterKt\n*L\n29#1:195\n29#1:196,3\n46#1:206,2\n51#1:208,2\n74#1:210\n74#1:211,3\n41#1:199\n41#1:200,6\n142#1:214\n143#1:215,3\n142#1:218\n165#1:219,3\n191#1:222,2\n*E\n"})
public final class SVGWriterKt {
    public static final void saveToFile(@NotNull Composition $this$saveToFile, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$saveToFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"svg")) {
            throw new IllegalArgumentException("can only write svg files, the extension '" + FilesKt.getExtension((File)file) + "' is not supported");
        }
        String svg = SVGWriterKt.writeSVG$default($this$saveToFile, null, 2, null);
        FilesKt.writeText$default((File)file, (String)svg, null, (int)2, null);
    }

    @NotNull
    public static final String toSVG(@NotNull Composition $this$toSVG) {
        Intrinsics.checkNotNullParameter((Object)$this$toSVG, (String)"<this>");
        return SVGWriterKt.writeSVG$default($this$toSVG, null, 2, null);
    }

    private static final String getSvgId(CompositionNode $this$svgId) {
        String tempId = $this$svgId.getId();
        return Intrinsics.areEqual((Object)tempId, (Object)"") ? "" : (tempId == null ? "" : "id=\"" + tempId + "\"");
    }

    /*
     * WARNING - void declaration
     */
    private static final String getSvgAttributes(CompositionNode $this$svgAttributes) {
        void $this$mapTo$iv$iv;
        Map $this$map$iv = $this$svgAttributes.getAttributes();
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it.getValue() != null && !Intrinsics.areEqual(it.getValue(), (Object)"")) {
                Object k = it.getKey();
                String string = (String)it.getValue();
                if (string == null) {
                    string = "";
                }
                object = k + "=\"" + Entities.escape((String)string) + "\"";
            } else {
                object = (String)it.getKey();
            }
            collection.add(object);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final String serialize(Styleable $this$serialize, Styleable parentStyleable) {
        AttributeOrPropertyKey t;
        void $this$filterTo$iv$iv;
        StringBuilder sb = new StringBuilder();
        Map $this$filter$iv = $this$serialize.getProperties();
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Map.Entry entry = $this$filterTo$iv$iv.entrySet().iterator();
        while (entry.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = entry.next();
            boolean bl = false;
            if (!(it.getKey() != AttributeOrPropertyKey.SHADESTYLE)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map filtered = destination$iv$iv;
        if (parentStyleable == null) {
            Map $this$forEach$iv = filtered;
            boolean $i$f$forEach = false;
            for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
                entry = element$iv;
                boolean bl = false;
                t = (AttributeOrPropertyKey)entry.getKey();
                AttributeOrPropertyValue u = (AttributeOrPropertyValue)entry.getValue();
                if (!(((CharSequence)String.valueOf(u)).length() > 0)) continue;
                sb.append(t + "=\"" + u + "\" ");
            }
        } else {
            Map $this$forEach$iv = filtered;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                entry = element$iv = iterator.next();
                boolean bl = false;
                t = (AttributeOrPropertyKey)entry.getKey();
                AttributeOrPropertyValue u = (AttributeOrPropertyValue)entry.getValue();
                if (!(((CharSequence)String.valueOf(u)).length() > 0) || $this$serialize.isInherited(parentStyleable, t)) continue;
                sb.append(t + "=\"" + u + "\" ");
            }
        }
        return ((Object)StringsKt.trim((CharSequence)sb)).toString();
    }

    static /* synthetic */ String serialize$default(Styleable styleable, Styleable styleable2, int n, Object object) {
        if ((n & 1) != 0) {
            styleable2 = null;
        }
        return SVGWriterKt.serialize(styleable, styleable2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String writeSVG(@NotNull Composition composition, @NotNull String topLevelId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)composition, (String)"composition");
        Intrinsics.checkNotNullParameter((Object)topLevelId, (String)"topLevelId");
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"xmlns", (Object)"http://www.w3.org/2000/svg"), TuplesKt.to((Object)"xmlns:xlink", (Object)"http://www.w3.org/1999/xlink")};
        Map defaultNamespaces = MapsKt.mapOf((Pair[])pairArray);
        Map $this$map$iv = MapsKt.plus((Map)defaultNamespaces, (Map)composition.getNamespaces());
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            collection.add(k + "=\"" + v + "\"");
        }
        String namespaces = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        String styleSer = SVGWriterKt.serialize$default((Styleable)composition.getStyle(), null, 1, null);
        String docStyleSer = SVGWriterKt.serialize$default((Styleable)composition.getDocumentStyle(), null, 1, null);
        sb.append("<svg version=\"1.2\" baseProfile=\"tiny\" id=\"" + topLevelId + "\" " + namespaces + " " + styleSer + " " + docStyleSer + ">");
        Ref.IntRef textPathID = new Ref.IntRef();
        SVGWriterKt.process(composition.getRoot(), (Function2<? super CompositionNode, ? super VisitStage, Unit>)((Function2)new Function2<CompositionNode, VisitStage, Unit>(sb, textPathID){
            final /* synthetic */ StringBuilder $sb;
            final /* synthetic */ Ref.IntRef $textPathID;
            {
                this.$sb = $sb;
                this.$textPathID = $textPathID;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CompositionNode $this$process, @NotNull VisitStage stage) {
                Intrinsics.checkNotNullParameter((Object)$this$process, (String)"$this$process");
                Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
                if (stage == VisitStage.PRE) {
                    CompositionNode compositionNode = $this$process.getParent();
                    String styleSerialized = SVGWriterKt.access$serialize((Styleable)$this$process.getStyle(), (Styleable)(compositionNode != null ? compositionNode.getStyle() : null));
                    CompositionNode compositionNode2 = $this$process;
                    if (compositionNode2 instanceof GroupNode) {
                        void $this$filterTo$iv$iv;
                        void $this$filter$iv;
                        Object object = new String[]{SVGWriterKt.access$getSvgId($this$process), styleSerialized, SVGWriterKt.access$getSvgAttributes($this$process)};
                        object = CollectionsKt.listOf((Object[])object);
                        boolean $i$f$filter = false;
                        void var8_11 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            String p0 = (String)element$iv$iv;
                            boolean bl = false;
                            if (!(((CharSequence)p0).length() > 0)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        String attributes = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                        this.$sb.append("<g " + attributes + ">\n");
                    } else if (compositionNode2 instanceof ShapeNode) {
                        void $this$filterTo$iv$iv;
                        void $this$filter$iv;
                        String pathAttribute = "d=\"" + SVGWriterKt.access$getSvg(((ShapeNode)$this$process).getShape()) + "\"";
                        Object $i$f$filter = new String[]{SVGWriterKt.access$getSvgId($this$process), styleSerialized, SVGWriterKt.access$getSvgAttributes($this$process), pathAttribute};
                        $i$f$filter = CollectionsKt.listOf((Object[])$i$f$filter);
                        boolean $i$f$filter2 = false;
                        void destination$iv$iv = $this$filter$iv;
                        Collection destination$iv$iv2 = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            String p0 = (String)element$iv$iv;
                            boolean bl = false;
                            if (!(((CharSequence)p0).length() > 0)) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        String attributes = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                        this.$sb.append("<path " + attributes + "/>\n");
                    } else if (compositionNode2 instanceof TextNode) {
                        ShapeContour contour = ((TextNode)$this$process).getContour();
                        String escapedText = Entities.escape((String)((TextNode)$this$process).getText());
                        if (contour == null) {
                            this.$sb.append("<text " + SVGWriterKt.access$getSvgId($this$process) + " " + SVGWriterKt.access$getSvgAttributes($this$process) + ">" + escapedText + "</text>");
                        } else {
                            this.$sb.append("<defs>");
                            this.$sb.append("<path id=\"text" + this.$textPathID.element + "\" d=\"" + SVGWriterKt.access$getSvg(contour) + "\"/>");
                            this.$sb.append("</defs>");
                            this.$sb.append("<text " + styleSerialized + "><textPath href=\"#text" + this.$textPathID.element + "\">" + escapedText + "</textPath></text>");
                            int n = this.$textPathID.element;
                            this.$textPathID.element = n + 1;
                        }
                    } else if (compositionNode2 instanceof ImageNode) {
                        String dataUrl = ColorBuffer.toDataUrl$default((ColorBuffer)((ImageNode)$this$process).getImage(), null, (int)1, null);
                        this.$sb.append("<image xlink:href=\"" + dataUrl + "\" height=\"" + ((ImageNode)$this$process).getImage().getHeight() + "\" width=\"" + ((ImageNode)$this$process).getImage().getWidth() + "\"/>");
                    }
                } else if ($this$process instanceof GroupNode) {
                    this.$sb.append("</g>\n");
                }
            }
        }));
        sb.append("</svg>");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String writeSVG$default(Composition composition, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "openrndr-svg";
        }
        return SVGWriterKt.writeSVG(composition, string);
    }

    /*
     * WARNING - void declaration
     */
    private static final String getSvg(Shape $this$svg) {
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEach$iv = $this$svg.getContours();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShapeContour it = (ShapeContour)element$iv;
            boolean bl = false;
            Iterable $this$forEachIndexed$iv = it.getSegments();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                String string;
                void segment;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Segment segment2 = (Segment)item$iv;
                int index = n;
                boolean bl2 = false;
                if (index == 0) {
                    sb.append("M " + segment.getStart().getX() + " " + segment.getStart().getY());
                }
                switch (segment.getControl().size()) {
                    case 1: {
                        string = "Q" + ((Vector2)segment.getControl().get(0)).getX() + " " + ((Vector2)segment.getControl().get(0)).getY() + " " + segment.getEnd().getX() + " " + segment.getEnd().getY();
                        break;
                    }
                    case 2: {
                        string = "C" + ((Vector2)segment.getControl().get(0)).getX() + " " + ((Vector2)segment.getControl().get(0)).getY() + " " + ((Vector2)segment.getControl().get(1)).getX() + " " + ((Vector2)segment.getControl().get(1)).getY() + " " + segment.getEnd().getX() + " " + segment.getEnd().getY();
                        break;
                    }
                    default: {
                        string = "L" + segment.getEnd().getX() + " " + segment.getEnd().getY();
                    }
                }
                sb.append(string);
            }
            if (!it.getClosed()) continue;
            sb.append("z");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final String getSvg(ShapeContour $this$svg) {
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEachIndexed$iv = $this$svg.getSegments();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String string;
            void segment;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Segment segment2 = (Segment)item$iv;
            int index = n;
            boolean bl = false;
            if (index == 0) {
                sb.append("M " + segment.getStart().getX() + " " + segment.getStart().getY());
            }
            switch (segment.getControl().size()) {
                case 1: {
                    string = "C" + ((Vector2)segment.getControl().get(0)).getX() + ", " + ((Vector2)segment.getControl().get(0)).getY() + " " + segment.getEnd().getX() + " " + segment.getEnd().getY();
                    break;
                }
                case 2: {
                    string = "C" + ((Vector2)segment.getControl().get(0)).getX() + ", " + ((Vector2)segment.getControl().get(0)).getY() + " " + ((Vector2)segment.getControl().get(1)).getX() + " " + ((Vector2)segment.getControl().get(1)).getY() + " " + segment.getEnd().getX() + " " + segment.getEnd().getY();
                    break;
                }
                default: {
                    string = "L" + segment.getEnd().getX() + " " + segment.getEnd().getY();
                }
            }
            sb.append(string);
        }
        if ($this$svg.getClosed()) {
            sb.append("z");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void process(CompositionNode compositionNode, Function2<? super CompositionNode, ? super VisitStage, Unit> visitor) {
        visitor.invoke((Object)compositionNode, (Object)VisitStage.PRE);
        if (compositionNode instanceof GroupNode) {
            Iterable $this$forEach$iv = ((GroupNode)compositionNode).getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CompositionNode it = (CompositionNode)element$iv;
                boolean bl = false;
                SVGWriterKt.process(it, visitor);
            }
        }
        visitor.invoke((Object)compositionNode, (Object)VisitStage.POST);
    }

    public static final /* synthetic */ String access$serialize(Styleable $receiver, Styleable parentStyleable) {
        return SVGWriterKt.serialize($receiver, parentStyleable);
    }

    public static final /* synthetic */ String access$getSvgId(CompositionNode $receiver) {
        return SVGWriterKt.getSvgId($receiver);
    }

    public static final /* synthetic */ String access$getSvgAttributes(CompositionNode $receiver) {
        return SVGWriterKt.getSvgAttributes($receiver);
    }

    public static final /* synthetic */ String access$getSvg(Shape $receiver) {
        return SVGWriterKt.getSvg($receiver);
    }

    public static final /* synthetic */ String access$getSvg(ShapeContour $receiver) {
        return SVGWriterKt.getSvg($receiver);
    }
}

