/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.criteria.impl;

import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriteriaRegistry;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.credential.criteria.impl.EvaluableKeyNameCredentialCriterion;
import org.opensaml.security.criteria.KeyNameCriterion;
import org.opensaml.security.crypto.KeySupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EvaluableKeyNameCredentialCriterionTest {
    private BasicCredential credential;
    private String keyName = "someKeyName";
    private KeyNameCriterion criteria;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.credential = new BasicCredential(KeySupport.generateKey((String)"AES", (int)128, null));
        this.credential.getKeyNames().add(this.keyName);
        this.credential.getKeyNames().add("foo");
        this.credential.getKeyNames().add("bar");
        this.criteria = new KeyNameCriterion(this.keyName);
    }

    @Test
    public void testSatisfy() {
        EvaluableKeyNameCredentialCriterion evalCrit = new EvaluableKeyNameCredentialCriterion(this.criteria);
        Assert.assertTrue((boolean)evalCrit.apply((Credential)this.credential), (String)"Credential should have matched the evaluable criteria");
    }

    @Test
    public void testNotSatisfy() {
        this.criteria.setKeyName(this.keyName + "OTHER");
        EvaluableKeyNameCredentialCriterion evalCrit = new EvaluableKeyNameCredentialCriterion(this.criteria);
        Assert.assertFalse((boolean)evalCrit.apply((Credential)this.credential), (String)"Credential should NOT have matched the evaluable criteria");
    }

    @Test
    public void testCanNotEvaluate() {
        this.credential.getKeyNames().clear();
        EvaluableKeyNameCredentialCriterion evalCrit = new EvaluableKeyNameCredentialCriterion(this.criteria);
        Assert.assertEquals((boolean)evalCrit.apply((Credential)this.credential), (boolean)evalCrit.isUnevaluableSatisfies(), (String)"Credential should have been unevaluable against the criteria");
    }

    @Test
    public void testRegistry() throws Exception {
        EvaluableCredentialCriterion evalCrit = EvaluableCredentialCriteriaRegistry.getEvaluator((Criterion)this.criteria);
        Assert.assertNotNull((Object)evalCrit, (String)"Evaluable criteria was unavailable from the registry");
        Assert.assertTrue((boolean)evalCrit.apply((Object)this.credential), (String)"Credential should have matched the evaluable criteria");
    }
}

