/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.criteria.impl;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriteriaRegistry;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.credential.criteria.impl.EvaluablePublicKeyCredentialCriterion;
import org.opensaml.security.criteria.PublicKeyCriterion;
import org.opensaml.security.crypto.KeySupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EvaluablePublicKeyCredentialCriterionTest {
    private BasicCredential credential;
    private String keyAlgo = "RSA";
    PublicKey pubKey;
    private PublicKeyCriterion criteria;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.pubKey = KeySupport.generateKeyPair((String)this.keyAlgo, (int)1024, null).getPublic();
        this.credential = new BasicCredential(this.pubKey);
        this.criteria = new PublicKeyCriterion(this.pubKey);
    }

    @Test
    public void testSatisfy() {
        EvaluablePublicKeyCredentialCriterion evalCrit = new EvaluablePublicKeyCredentialCriterion(this.criteria);
        Assert.assertTrue((boolean)evalCrit.apply((Credential)this.credential), (String)"Credential should have matched the evaluable criteria");
    }

    @Test
    public void testNotSatisfyDifferentKey() throws NoSuchAlgorithmException, NoSuchProviderException {
        this.criteria.setPublicKey(KeySupport.generateKeyPair((String)this.keyAlgo, (int)1024, null).getPublic());
        EvaluablePublicKeyCredentialCriterion evalCrit = new EvaluablePublicKeyCredentialCriterion(this.criteria);
        Assert.assertFalse((boolean)evalCrit.apply((Credential)this.credential), (String)"Credential should NOT have matched the evaluable criteria");
    }

    @Test
    public void testCanNotEvaluate() {
        EvaluablePublicKeyCredentialCriterion evalCrit = new EvaluablePublicKeyCredentialCriterion(this.criteria);
        Assert.assertEquals((boolean)evalCrit.apply(null), (boolean)evalCrit.isUnevaluableSatisfies(), (String)"Credential should have been unevaluable against the criteria");
    }

    @Test
    public void testRegistry() throws Exception {
        EvaluableCredentialCriterion evalCrit = EvaluableCredentialCriteriaRegistry.getEvaluator((Criterion)this.criteria);
        Assert.assertNotNull((Object)evalCrit, (String)"Evaluable criteria was unavailable from the registry");
        Assert.assertTrue((boolean)evalCrit.apply((Object)this.credential), (String)"Credential should have matched the evaluable criteria");
    }
}

