/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.security.x509.TrustedNamesCriterion;
import org.opensaml.security.x509.impl.BasicPKIXValidationInformation;
import org.opensaml.security.x509.impl.StaticPKIXValidationInformationResolver;
import org.testng.Assert;
import org.testng.annotations.Test;

public class StaticPKIXValidationInformationResolverTest {
    @Test
    public void testDynamicNamesDisabled() throws ResolverException {
        HashSet<String> staticTrustedNames = new HashSet<String>(Arrays.asList("foo", "bar"));
        ArrayList<BasicPKIXValidationInformation> staticPKIXInfo = new ArrayList<BasicPKIXValidationInformation>();
        staticPKIXInfo.add(new BasicPKIXValidationInformation(null, null, Integer.valueOf(1)));
        StaticPKIXValidationInformationResolver resolver = new StaticPKIXValidationInformationResolver(staticPKIXInfo, staticTrustedNames);
        Assert.assertTrue((boolean)resolver.resolve(null).iterator().hasNext());
        Assert.assertTrue((boolean)resolver.resolve(new CriteriaSet()).iterator().hasNext());
        Assert.assertTrue((boolean)resolver.supportsTrustedNameResolution());
        Set trustedNamesResult = null;
        trustedNamesResult = resolver.resolveTrustedNames(null);
        Assert.assertNotNull((Object)trustedNamesResult);
        Assert.assertEquals((int)trustedNamesResult.size(), (int)staticTrustedNames.size());
        Assert.assertTrue((boolean)trustedNamesResult.containsAll(staticTrustedNames));
        trustedNamesResult = resolver.resolveTrustedNames(new CriteriaSet());
        Assert.assertNotNull((Object)trustedNamesResult);
        Assert.assertEquals((int)trustedNamesResult.size(), (int)staticTrustedNames.size());
        Assert.assertTrue((boolean)trustedNamesResult.containsAll(staticTrustedNames));
        HashSet<String> dynamicTrustedNames = new HashSet<String>(Arrays.asList("abc", "xyz"));
        trustedNamesResult = resolver.resolveTrustedNames(new CriteriaSet(new Criterion[]{new TrustedNamesCriterion(dynamicTrustedNames)}));
        Assert.assertNotNull((Object)trustedNamesResult);
        Assert.assertEquals((int)trustedNamesResult.size(), (int)staticTrustedNames.size());
        Assert.assertTrue((boolean)trustedNamesResult.containsAll(staticTrustedNames));
    }

    @Test
    public void testDynamicNamesEnabled() throws ResolverException {
        HashSet<String> staticTrustedNames = new HashSet<String>(Arrays.asList("foo", "bar"));
        ArrayList<BasicPKIXValidationInformation> staticPKIXInfo = new ArrayList<BasicPKIXValidationInformation>();
        staticPKIXInfo.add(new BasicPKIXValidationInformation(null, null, Integer.valueOf(1)));
        StaticPKIXValidationInformationResolver resolver = new StaticPKIXValidationInformationResolver(staticPKIXInfo, staticTrustedNames, true);
        Assert.assertTrue((boolean)resolver.resolve(null).iterator().hasNext());
        Assert.assertTrue((boolean)resolver.resolve(new CriteriaSet()).iterator().hasNext());
        Assert.assertTrue((boolean)resolver.supportsTrustedNameResolution());
        Set trustedNamesResult = null;
        trustedNamesResult = resolver.resolveTrustedNames(null);
        Assert.assertNotNull((Object)trustedNamesResult);
        Assert.assertEquals((int)trustedNamesResult.size(), (int)staticTrustedNames.size());
        Assert.assertTrue((boolean)trustedNamesResult.containsAll(staticTrustedNames));
        trustedNamesResult = resolver.resolveTrustedNames(new CriteriaSet());
        Assert.assertNotNull((Object)trustedNamesResult);
        Assert.assertEquals((int)trustedNamesResult.size(), (int)staticTrustedNames.size());
        Assert.assertTrue((boolean)trustedNamesResult.containsAll(staticTrustedNames));
        HashSet<String> dynamicTrustedNames = new HashSet<String>(Arrays.asList("abc", "xyz"));
        trustedNamesResult = resolver.resolveTrustedNames(new CriteriaSet(new Criterion[]{new TrustedNamesCriterion(dynamicTrustedNames)}));
        Assert.assertNotNull((Object)trustedNamesResult);
        Assert.assertEquals((int)trustedNamesResult.size(), (int)(staticTrustedNames.size() + dynamicTrustedNames.size()));
        Assert.assertTrue((boolean)trustedNamesResult.containsAll(staticTrustedNames));
        Assert.assertTrue((boolean)trustedNamesResult.containsAll(dynamicTrustedNames));
    }

    @Test
    public void testEntityIdIncluded() throws ResolverException {
        HashSet<String> staticTrustedNames = new HashSet<String>(Arrays.asList("foo", "bar"));
        ArrayList<BasicPKIXValidationInformation> staticPKIXInfo = new ArrayList<BasicPKIXValidationInformation>();
        staticPKIXInfo.add(new BasicPKIXValidationInformation(null, null, Integer.valueOf(1)));
        StaticPKIXValidationInformationResolver resolver = new StaticPKIXValidationInformationResolver(staticPKIXInfo, staticTrustedNames, true);
        Set trustedNamesResult = null;
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion("myEntity")});
        trustedNamesResult = resolver.resolveTrustedNames(criteriaSet);
        Assert.assertEquals((int)trustedNamesResult.size(), (int)(staticTrustedNames.size() + 1));
        Assert.assertTrue((boolean)trustedNamesResult.containsAll(staticTrustedNames));
        Assert.assertTrue((boolean)trustedNamesResult.contains("myEntity"));
        HashSet<String> dynamicTrustedNames = new HashSet<String>(Arrays.asList("abc", "xyz"));
        criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion("myEntity"), new TrustedNamesCriterion(dynamicTrustedNames)});
        trustedNamesResult = resolver.resolveTrustedNames(criteriaSet);
        Assert.assertEquals((int)trustedNamesResult.size(), (int)(staticTrustedNames.size() + dynamicTrustedNames.size() + 1));
        Assert.assertTrue((boolean)trustedNamesResult.containsAll(staticTrustedNames));
        Assert.assertTrue((boolean)trustedNamesResult.containsAll(dynamicTrustedNames));
        Assert.assertTrue((boolean)trustedNamesResult.contains("myEntity"));
    }
}

