/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.httpclient.impl;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.URISyntaxException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.httpclient.impl.BasicHttpClientSecurityConfiguration;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.X509Support;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BasicHttpClientSecurityConfigurationTest {
    private X509Credential x509Credential;

    @BeforeMethod
    protected void setUp() throws CertificateException, URISyntaxException {
        this.x509Credential = CredentialSupport.getSimpleCredential((X509Certificate)X509Support.decodeCertificate((File)new File(this.getClass().getResource("/data/certificate.pem").toURI())), null);
    }

    @Test
    public void testBasic() {
        BasicHttpClientSecurityConfiguration config = new BasicHttpClientSecurityConfiguration();
        config.setClientTLSCredential(this.x509Credential);
        config.setCredentialsProvider((CredentialsProvider)new BasicCredentialsProvider());
        config.setHostnameVerifier((X509HostnameVerifier)new StrictHostnameVerifier());
        config.setTLSCipherSuites((Collection)Lists.newArrayList((Object[])new String[]{"test"}));
        config.setTLSProtocols((Collection)Lists.newArrayList((Object[])new String[]{"test"}));
        config.setTLSTrustEngine((TrustEngine)new MockTrustEngine());
        Assert.assertNotNull((Object)config.getClientTLSCredential());
        Assert.assertNotNull((Object)config.getCredentialsProvider());
        Assert.assertNotNull((Object)config.getHostnameVerifier());
        Assert.assertNotNull((Object)config.getTLSCipherSuites());
        Assert.assertNotNull((Object)config.getTLSProtocols());
        Assert.assertNotNull((Object)config.getTLSTrustEngine());
    }

    @Test
    public void testEmptyLists() {
        BasicHttpClientSecurityConfiguration config = new BasicHttpClientSecurityConfiguration();
        config.setTLSCipherSuites((Collection)Lists.newArrayList());
        config.setTLSProtocols((Collection)Lists.newArrayList());
        Assert.assertNull((Object)config.getTLSCipherSuites());
        Assert.assertNull((Object)config.getTLSProtocols());
    }

    @Test
    public void testCredentialsProvider() {
        BasicHttpClientSecurityConfiguration config = new BasicHttpClientSecurityConfiguration();
        config.setBasicCredentials(new UsernamePasswordCredentials("test", "test"));
        Assert.assertNotNull((Object)config.getCredentialsProvider());
    }

    public static class MockTrustEngine
    implements TrustEngine<X509Credential> {
        public boolean validate(X509Credential token, CriteriaSet trustBasisCriteria) throws SecurityException {
            return false;
        }
    }
}

