/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.httpclient.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.HttpHost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.protocol.HttpContext;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.security.httpclient.impl.MockTLSSocketFactory;
import org.opensaml.security.httpclient.impl.TrustEngineTLSSocketFactory;
import org.opensaml.security.trust.impl.ExplicitKeyTrustEngine;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Support;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TrustEngineTLSSocketFactoryTest {
    private static final String DATA_PATH = "/org/opensaml/security/x509/impl/";
    private TrustEngineTLSSocketFactory trustEngineFactory;
    private HttpContext httpContext;
    private String hostname = "foo.example.org";

    @BeforeMethod
    public void buildHttpContext() {
        this.httpContext = new HttpClientContext();
    }

    @Test
    public void testNonSSL() throws IOException {
        this.trustEngineFactory = new TrustEngineTLSSocketFactory(this.buildInnerSSLFactory(null, this.hostname), null);
        Socket socket = this.trustEngineFactory.createSocket(this.httpContext);
        this.trustEngineFactory.connectSocket(0, socket, new HttpHost(this.hostname, 80, "http"), null, null, this.httpContext);
        Assert.assertNull((Object)this.httpContext.getAttribute("opensaml.ServerTLSCredentialTrusted"));
    }

    @Test
    public void testSuccessNoTrustEngine() throws IOException {
        BasicX509Credential cred = this.getCredential("foo-1A1-good.crt", new String[0]);
        this.trustEngineFactory = new TrustEngineTLSSocketFactory(this.buildInnerSSLFactory(Collections.singletonList(cred.getEntityCertificate()), this.hostname), null);
        Socket socket = this.trustEngineFactory.createSocket(this.httpContext);
        this.trustEngineFactory.connectSocket(0, socket, new HttpHost(this.hostname, 443, "https"), null, null, this.httpContext);
        Assert.assertNull((Object)this.httpContext.getAttribute("opensaml.ServerTLSCredentialTrusted"));
    }

    @Test
    public void testSuccessWithEngine() throws IOException {
        BasicX509Credential cred = this.getCredential("foo-1A1-good.crt", new String[0]);
        ExplicitKeyTrustEngine trustEngine = new ExplicitKeyTrustEngine((CredentialResolver)new StaticCredentialResolver((Credential)cred));
        this.httpContext.setAttribute("opensaml.TrustEngine", (Object)trustEngine);
        this.trustEngineFactory = new TrustEngineTLSSocketFactory(this.buildInnerSSLFactory(Collections.singletonList(cred.getEntityCertificate()), this.hostname), null);
        Socket socket = this.trustEngineFactory.createSocket(this.httpContext);
        this.trustEngineFactory.connectSocket(0, socket, new HttpHost(this.hostname, 443, "https"), null, null, this.httpContext);
        Assert.assertEquals((Object)this.httpContext.getAttribute("opensaml.ServerTLSCredentialTrusted"), (Object)Boolean.TRUE);
    }

    @Test
    public void testSuccessWithEngineAndVerifier() throws IOException {
        BasicX509Credential cred = this.getCredential("foo-1A1-good.crt", new String[0]);
        ExplicitKeyTrustEngine trustEngine = new ExplicitKeyTrustEngine((CredentialResolver)new StaticCredentialResolver((Credential)cred));
        this.httpContext.setAttribute("opensaml.TrustEngine", (Object)trustEngine);
        this.trustEngineFactory = new TrustEngineTLSSocketFactory(this.buildInnerSSLFactory(Collections.singletonList(cred.getEntityCertificate()), this.hostname), (X509HostnameVerifier)new StrictHostnameVerifier());
        Socket socket = this.trustEngineFactory.createSocket(this.httpContext);
        this.trustEngineFactory.connectSocket(0, socket, new HttpHost(this.hostname, 443, "https"), null, null, this.httpContext);
        Assert.assertEquals((Object)this.httpContext.getAttribute("opensaml.ServerTLSCredentialTrusted"), (Object)Boolean.TRUE);
    }

    @Test(expectedExceptions={SSLPeerUnverifiedException.class})
    public void testFailUntrustedCert() throws IOException {
        BasicX509Credential cred = this.getCredential("foo-1A1-good.crt", new String[0]);
        ArrayList emptyCreds = new ArrayList();
        ExplicitKeyTrustEngine trustEngine = new ExplicitKeyTrustEngine((CredentialResolver)new StaticCredentialResolver(emptyCreds));
        this.httpContext.setAttribute("opensaml.TrustEngine", (Object)trustEngine);
        this.trustEngineFactory = new TrustEngineTLSSocketFactory(this.buildInnerSSLFactory(Collections.singletonList(cred.getEntityCertificate()), this.hostname), (X509HostnameVerifier)new StrictHostnameVerifier());
        Socket socket = this.trustEngineFactory.createSocket(this.httpContext);
        try {
            this.trustEngineFactory.connectSocket(0, socket, new HttpHost(this.hostname, 443, "https"), null, null, this.httpContext);
        }
        catch (Exception e) {
            Assert.assertEquals((Object)this.httpContext.getAttribute("opensaml.ServerTLSCredentialTrusted"), (Object)Boolean.FALSE);
            throw e;
        }
    }

    @Test(expectedExceptions={SSLException.class})
    public void testFailBadHostname() throws IOException {
        BasicX509Credential cred = this.getCredential("foo-1A1-good.crt", new String[0]);
        ExplicitKeyTrustEngine trustEngine = new ExplicitKeyTrustEngine((CredentialResolver)new StaticCredentialResolver((Credential)cred));
        this.httpContext.setAttribute("opensaml.TrustEngine", (Object)trustEngine);
        this.trustEngineFactory = new TrustEngineTLSSocketFactory(this.buildInnerSSLFactory(Collections.singletonList(cred.getEntityCertificate()), "bogus.example.com"), (X509HostnameVerifier)new StrictHostnameVerifier());
        Socket socket = this.trustEngineFactory.createSocket(this.httpContext);
        try {
            this.trustEngineFactory.connectSocket(0, socket, new HttpHost("bogus.example.com", 443, "https"), null, null, this.httpContext);
        }
        catch (Exception e) {
            Assert.assertEquals((Object)this.httpContext.getAttribute("opensaml.ServerTLSCredentialTrusted"), (Object)Boolean.TRUE);
            throw e;
        }
    }

    @Test(expectedExceptions={SSLPeerUnverifiedException.class})
    public void testFailNoCertsInSession() throws IOException {
        BasicX509Credential cred = this.getCredential("foo-1A1-good.crt", new String[0]);
        ExplicitKeyTrustEngine trustEngine = new ExplicitKeyTrustEngine((CredentialResolver)new StaticCredentialResolver((Credential)cred));
        this.httpContext.setAttribute("opensaml.TrustEngine", (Object)trustEngine);
        this.trustEngineFactory = new TrustEngineTLSSocketFactory(this.buildInnerSSLFactory(new ArrayList<Certificate>(), this.hostname), (X509HostnameVerifier)new StrictHostnameVerifier());
        Socket socket = this.trustEngineFactory.createSocket(this.httpContext);
        this.trustEngineFactory.connectSocket(0, socket, new HttpHost(this.hostname, 443, "https"), null, null, this.httpContext);
    }

    private LayeredConnectionSocketFactory buildInnerSSLFactory(List<Certificate> certs, String host) {
        if (certs == null) {
            return new MockTLSSocketFactory();
        }
        return new MockTLSSocketFactory(certs, host);
    }

    private BasicX509Credential getCredential(String entityCertFileName, String ... chainMembers) {
        X509Certificate entityCert = this.getCertificate(entityCertFileName);
        BasicX509Credential cred = new BasicX509Credential(entityCert);
        HashSet<X509Certificate> certChain = new HashSet<X509Certificate>();
        certChain.add(entityCert);
        for (String member : chainMembers) {
            certChain.add(this.getCertificate(member));
        }
        cred.setEntityCertificateChain(certChain);
        return cred;
    }

    private X509Certificate getCertificate(String fileName) {
        try {
            InputStream ins = this.getInputStream(fileName);
            byte[] encoded = new byte[ins.available()];
            ins.read(encoded);
            return (X509Certificate)X509Support.decodeCertificates((byte[])encoded).iterator().next();
        }
        catch (Exception e) {
            Assert.fail((String)("Could not create certificate from file: " + fileName + ": " + e.getMessage()));
            return null;
        }
    }

    private InputStream getInputStream(String fileName) {
        return this.getClass().getResourceAsStream(DATA_PATH + fileName);
    }
}

