/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.trust.impl;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.List;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.trust.impl.ExplicitKeyTrustEngine;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Support;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ExplicitKeyTrustEngineTest {
    private RSAPublicKey entityPubKey;
    private final String rsaBase64 = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzVp5BZoctb2GuoDf8QUSpGcRct7FKtldC7GG+kN6XvUJW+vgc2jOQ6zfLiKqq6ARN1qdC7a4CrkE6Q6TRQXUtqeWn4lLTmC1gQ7Ys0zs7N2d+jBjIyD1GEOLNNyD98j4drnehCqQz4mKszW5EWoiMJmEorea/kTGL3en7ir0zp+oez2SOQA+0XWu1VoeTlUqGV5Ucd6sRYaPpmYVtKuH1H04uZVsH+BIZHwZc4MP5OYH+HDouq6xqUUtc8Zm7V9UQIPiNtM+ndOINDdlrCubLbM4GCqCETiQol8I62mvP0qBXCC6JVkKbbVRwSFGJcg5ZvJiBZXmX+EXhaX5vp1GMQIDAQAB";
    private X509Certificate entityCert;
    private String entityCertBase64 = "MIIDjDCCAnSgAwIBAgIBKjANBgkqhkiG9w0BAQUFADAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnMB4XDTA3MDQwOTA2MTIwOVoXDTE3MDQwNjA2MTIwOVowMTESMBAGA1UEChMJSW50ZXJuZXQyMRswGQYDVQQDExJmb29iYXIuZXhhbXBsZS5vcmcwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDNWnkFmhy1vYa6gN/xBRKkZxFy3sUq2V0LsYb6Q3pe9Qlb6+BzaM5DrN8uIqqroBE3Wp0LtrgKuQTpDpNFBdS2p5afiUtOYLWBDtizTOzs3Z36MGMjIPUYQ4s03IP3yPh2ud6EKpDPiYqzNbkRaiIwmYSit5r+RMYvd6fuKvTOn6h7PZI5AD7Rda7VWh5OVSoZXlRx3qxFho+mZhW0q4fUfTi5lWwf4EhkfBlzgw/k5gf4cOi6rrGpRS1zxmbtX1RAg+I20z6d04g0N2WsK5stszgYKoIROJCiXwjraa8/SoFcILolWQpttVHBIUYlyDlm8mIFleZf4ReFpfm+nUYxAgMBAAGjgbIwga8wCQYDVR0TBAIwADAsBglghkgBhvhCAQ0EHxYdT3BlblNTTCBHZW5lcmF0ZWQgQ2VydGlmaWNhdGUwHQYDVR0OBBYEFDgRgTkjaKoK6DoZfUZ4g9LDJUWuMFUGA1UdIwROMEyAFNXuZVPeUdqHrULqQW7yr9buRpQLoTGkLzAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnggEBMA0GCSqGSIb3DQEBBQUAA4IBAQCPj3Si4Eiw9abNgPBUhBXWd6eRYlIHaHcnez6j6g7foAOyuVIUso9Q5c6pvL87lmasK55l09YPXw1qmiH+bHMcrwEPODpLx7xd3snlOCi7FyxahxwSs8yfTu8Pq95rWt0LNcfHxQK938Cpnav6jgDo2uH/ywAOFFSnoBzGHAfScHMfj8asZ6THosYsklII7FSU8j49GV2utkvGB3mcu4STuLdeRCZmi93vq1D4JVGsXC4UaHjg114+a+9q0XZdz6a1UW4pt1ryXIPotCS62M71pkJf5neHUinKAqgoRfPXowudZg1Zl8DjzoOBn+MNHRrR5KYbVGvdHcxoJLCwVB/v";
    private X509Certificate otherCert1;
    private String otherCert1Base64 = "MIIECTCCAvGgAwIBAgIBMzANBgkqhkiG9w0BAQUFADAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnMB4XDTA3MDUyNTIwMTYxMVoXDTE3MDUyMjIwMTYxMVowGjEYMBYGA1UEAxMPaWRwLmV4YW1wbGUub3JnMIIBtjCCASsGByqGSM44BAEwggEeAoGBAI+ktw7R9m7TxjaCrT2MHwWNQUAyXPrqbFCcu+DCirr861U6R6W/GyqWdcy8/D1Hh/I1U94POQn5yfqVPpVH2ZRS4OMFndHWaoo9V5LJoXTXHiDYB3W4t9tn0fm7It0n7VoUI5C4y9LG32Hq+UIGF/ktNTmo//mEqLS6aJNdbMFpAhUArmKGh0hcpmjukYArWcMRvipB4CMCgYBuCiCrUaHBRRtqrk0P/Luq0l2M2718GwSGeLPZip06gACDG7IctMrgH1J+ZIjsx6vffi977wnMDiktqacmaobV+SCRW9ijJRdkYpUHmlLvuJGnDPjkvewpbGWJsCabpWEvWdYw3ma8RuHOPj4Jkrdd4VcRaFwox/fPJ7cG6kBydgOBhAACgYBxQIPv9DCsmiMHG1FAxSARX0GcRiELJPJ+MtaStdTrVobNa2jebwc3npLiTvUR4U/CDo1mSZb+Sp/wian8kNZHmGcR6KbtJs9UDsa3V0pbbgpUar4HcxV+NQJBbhn9RGu85g3PDILUrINiUAf26mhPN5Y0paM+HbM68nUf1OLv16OBsjCBrzAJBgNVHRMEAjAAMCwGCWCGSAGG+EIBDQQfFh1PcGVuU1NMIEdlbmVyYXRlZCBDZXJ0aWZpY2F0ZTAdBgNVHQ4EFgQUIHFAEB/3jIIZzJEJ/qdsuI8vN3kwVQYDVR0jBE4wTIAU1e5lU95R2oetQupBbvKv1u5GlAuhMaQvMC0xEjAQBgNVBAoTCUludGVybmV0MjEXMBUGA1UEAxMOY2EuZXhhbXBsZS5vcmeCAQEwDQYJKoZIhvcNAQEFBQADggEBAJt4Q34+pqjW5tHHhkdzTITSBjOOf8EvYMgxTMRzhagLSHTt9RgO5i/G7ELvnwe1j6187m1XD9iEAWKeKbB//ljeOpgnwzkLR9Er5tr1RI3cbil0AX+oX0c1jfRaQnR50Rfb5YoNX6G963iphlxp9C8VLB6eOk/S270XoWoQIkO1ioQ8JY4HE6AyDsOpJaOmHpBaxjgsiko52ZWZeZyaCyL98BXwVxeml7pYnHlXWWidB0N/Zy+LbvWg3urUkiDjMcB6nGImmEfDSxRdybitcMwbwL26z2WOpwL3llm3mcCydKXgXt8IQhfDhOZOHWckeD2tStnJRP/cqBgO62/qirw=";
    private X509Certificate otherCert2;
    private String otherCert2Base64 = "MIIC8DCCAdigAwIBAgIBNDANBgkqhkiG9w0BAQUFADAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnMB4XDTA3MDUyNTIwMzEwOFoXDTE3MDUyMjIwMzEwOFowGTEXMBUGA1UEAxMOc3AuZXhhbXBsZS5vcmcwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAKk7xVQ23rc51qieDAcj3CCsumTTpTiFCxGiqDA8lStdcBmoNX3v+lBFKkXtQKwebcwOF3YyHFyZ2kXFREfZrG76h/5QBFNQZa6y/rJskCl9bnz70HVDzBGizRc3qWVDKP1EQ6rRY2qkeGd33NKHkVUepGMPhHsv3kK+zVUR6/v/AgMBAAGjgbIwga8wCQYDVR0TBAIwADAsBglghkgBhvhCAQ0EHxYdT3BlblNTTCBHZW5lcmF0ZWQgQ2VydGlmaWNhdGUwHQYDVR0OBBYEFOhBatBFJQgNeKiG1/Ro9W9zmO92MFUGA1UdIwROMEyAFNXuZVPeUdqHrULqQW7yr9buRpQLoTGkLzAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnggEBMA0GCSqGSIb3DQEBBQUAA4IBAQAhpFQ4+OOrtETiuSagUe9dSqm1hahcQuv3iWRfL7Pp6i2x1rR6hlk9zXUC58Oou/UOUOpPWZG/8cr3B50ViuT3zVisIYdaCGeUZ3efEeeeaI77m73xpn/qNI4aIlr6Wmj9C0biJsF3hJvtK2VJu74GCUtxsXkEKyQ0fNx6bTd50RxUhM4uto7YqvMfKH6GDJPRcFmsR5YEajxOVihfRtOjvd1rTnOQLWYQRy1OZQek1Z6M7aJmYanYEAjQhyzbKM+R2sqzMlgHbGnbeAADEBnQi8GSkTpgyieT6NC86SvWhq47gNpBYySYhb9zKx/OcZMK4UBD48HhAatEgovrKCHH";
    private BasicCredential entityRSACred;
    private BasicX509Credential entityX509Cred;
    private List<Credential> credentials;
    private CriteriaSet criteriaSet;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.entityPubKey = KeySupport.buildJavaRSAPublicKey((String)"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzVp5BZoctb2GuoDf8QUSpGcRct7FKtldC7GG+kN6XvUJW+vgc2jOQ6zfLiKqq6ARN1qdC7a4CrkE6Q6TRQXUtqeWn4lLTmC1gQ7Ys0zs7N2d+jBjIyD1GEOLNNyD98j4drnehCqQz4mKszW5EWoiMJmEorea/kTGL3en7ir0zp+oez2SOQA+0XWu1VoeTlUqGV5Ucd6sRYaPpmYVtKuH1H04uZVsH+BIZHwZc4MP5OYH+HDouq6xqUUtc8Zm7V9UQIPiNtM+ndOINDdlrCubLbM4GCqCETiQol8I62mvP0qBXCC6JVkKbbVRwSFGJcg5ZvJiBZXmX+EXhaX5vp1GMQIDAQAB");
        this.entityCert = X509Support.decodeCertificate((String)this.entityCertBase64);
        this.otherCert1 = X509Support.decodeCertificate((String)this.otherCert1Base64);
        this.otherCert2 = X509Support.decodeCertificate((String)this.otherCert2Base64);
        this.entityRSACred = CredentialSupport.getSimpleCredential((PublicKey)this.entityPubKey, null);
        this.entityRSACred.setEntityId("entity-RSA");
        this.entityX509Cred = new BasicX509Credential(this.entityCert);
        this.entityX509Cred.setEntityId("entity-X509");
        BasicX509Credential otherCred1 = new BasicX509Credential(this.otherCert1);
        otherCred1.setEntityId("other-1");
        BasicX509Credential otherCred2 = new BasicX509Credential(this.otherCert2);
        otherCred2.setEntityId("other-2");
        this.credentials = new ArrayList<Credential>();
        this.credentials.add((Credential)otherCred1);
        this.credentials.add((Credential)otherCred2);
        this.criteriaSet = new CriteriaSet();
        this.criteriaSet.add((Object)new EntityIdCriterion("dummyEntityID"));
    }

    @Test
    public void testKeyTrusted() throws SecurityException {
        this.credentials.add((Credential)this.entityRSACred);
        StaticCredentialResolver resolver = new StaticCredentialResolver(this.credentials);
        ExplicitKeyTrustEngine engine = new ExplicitKeyTrustEngine((CredentialResolver)resolver);
        Assert.assertTrue((boolean)engine.validate((Credential)this.entityRSACred, this.criteriaSet), (String)"Entity RSA public key credential was not trusted");
        Assert.assertTrue((boolean)engine.validate((Credential)this.entityX509Cred, this.criteriaSet), (String)"Entity X509 credential was not trusted");
    }

    @Test
    public void testCertTrusted() throws SecurityException {
        this.credentials.add((Credential)this.entityX509Cred);
        StaticCredentialResolver resolver = new StaticCredentialResolver(this.credentials);
        ExplicitKeyTrustEngine engine = new ExplicitKeyTrustEngine((CredentialResolver)resolver);
        Assert.assertTrue((boolean)engine.validate((Credential)this.entityRSACred, this.criteriaSet), (String)"Entity RSA public key credential was not trusted");
        Assert.assertTrue((boolean)engine.validate((Credential)this.entityX509Cred, this.criteriaSet), (String)"Entity X509 credential was not trusted");
    }

    @Test
    public void testUntrusted() throws SecurityException {
        StaticCredentialResolver resolver = new StaticCredentialResolver(this.credentials);
        ExplicitKeyTrustEngine engine = new ExplicitKeyTrustEngine((CredentialResolver)resolver);
        Assert.assertFalse((boolean)engine.validate((Credential)this.entityRSACred, this.criteriaSet), (String)"Entity RSA public key credential was trusted");
        Assert.assertFalse((boolean)engine.validate((Credential)this.entityX509Cred, this.criteriaSet), (String)"Entity X509 credential was trusted");
    }
}

