/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.criteria.impl;

import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriteriaRegistry;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.credential.criteria.impl.EvaluableEntityIDCredentialCriterion;
import org.opensaml.security.crypto.KeySupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EvaluableEntityIDCredentialCriterionTest {
    private BasicCredential credential;
    private String entityID = "someEntityID";
    private EntityIdCriterion criteria;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.credential = new BasicCredential(KeySupport.generateKey((String)"AES", (int)128, null));
        this.credential.setEntityId(this.entityID);
        this.criteria = new EntityIdCriterion(this.entityID);
    }

    @Test
    public void testSatisfy() {
        EvaluableEntityIDCredentialCriterion evalCrit = new EvaluableEntityIDCredentialCriterion(this.criteria);
        Assert.assertTrue((boolean)evalCrit.apply((Credential)this.credential), (String)"Credential should have matched the evaluable criteria");
    }

    @Test
    public void testNotSatisfy() {
        this.criteria = new EntityIdCriterion("OTHER");
        EvaluableEntityIDCredentialCriterion evalCrit = new EvaluableEntityIDCredentialCriterion(this.criteria);
        Assert.assertFalse((boolean)evalCrit.apply((Credential)this.credential), (String)"Credential should NOT have matched the evaluable criteria");
    }

    @Test
    public void testCanNotEvaluate() {
        this.credential.setEntityId(null);
        EvaluableEntityIDCredentialCriterion evalCrit = new EvaluableEntityIDCredentialCriterion(this.criteria);
        Assert.assertEquals((boolean)evalCrit.apply((Credential)this.credential), (boolean)evalCrit.isUnevaluableSatisfies(), (String)"Credential should have been unevaluable against the criteria");
    }

    @Test
    public void testRegistry() throws Exception {
        EvaluableCredentialCriterion evalCrit = EvaluableCredentialCriteriaRegistry.getEvaluator((Criterion)this.criteria);
        Assert.assertNotNull((Object)evalCrit, (String)"Evaluable criteria was unavailable from the registry");
        Assert.assertTrue((boolean)evalCrit.apply((Object)this.credential), (String)"Credential should have matched the evaluable criteria");
    }
}

