/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.criteria.impl;

import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriteriaRegistry;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.credential.criteria.impl.EvaluableKeyAlgorithmCredentialCriterion;
import org.opensaml.security.criteria.KeyAlgorithmCriterion;
import org.opensaml.security.crypto.KeySupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EvaluableKeyAlgorithmCredentialCriterionTest {
    private BasicCredential credential;
    private String keyAlgo = "RSA";
    private KeyAlgorithmCriterion criteria;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.credential = new BasicCredential(KeySupport.generateKeyPair((String)this.keyAlgo, (int)1024, null).getPublic());
        this.criteria = new KeyAlgorithmCriterion(this.keyAlgo);
    }

    @Test
    public void testSatisfy() {
        EvaluableKeyAlgorithmCredentialCriterion evalCrit = new EvaluableKeyAlgorithmCredentialCriterion(this.criteria);
        Assert.assertTrue((boolean)evalCrit.apply((Credential)this.credential), (String)"Credential should have matched the evaluable criteria");
    }

    @Test
    public void testNotSatisfy() {
        this.criteria.setKeyAlgorithm("SomeOtherKeyAlgo");
        EvaluableKeyAlgorithmCredentialCriterion evalCrit = new EvaluableKeyAlgorithmCredentialCriterion(this.criteria);
        Assert.assertFalse((boolean)evalCrit.apply((Credential)this.credential), (String)"Credential should NOT have matched the evaluable criteria");
    }

    @Test
    public void testRegistry() throws Exception {
        EvaluableCredentialCriterion evalCrit = EvaluableCredentialCriteriaRegistry.getEvaluator((Criterion)this.criteria);
        Assert.assertNotNull((Object)evalCrit, (String)"Evaluable criteria was unavailable from the registry");
        Assert.assertTrue((boolean)evalCrit.apply((Object)this.credential), (String)"Credential should have matched the evaluable criteria");
    }
}

