/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.messaging.impl;

import com.google.common.base.Predicates;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import javax.crypto.SecretKey;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialContextSet;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.httpclient.HttpClientSecurityConfigurationCriterion;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecurityParametersResolver;
import org.opensaml.security.messaging.HttpClientSecurityContext;
import org.opensaml.security.messaging.impl.PopulateHttpClientSecurityParametersHandler;
import org.opensaml.security.x509.X509Credential;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PopulateHttpClientSecurityParametersHandlerTest
extends OpenSAMLInitBaseTestCase {
    private MessageContext messageContext;
    private PopulateHttpClientSecurityParametersHandler handler;

    @BeforeMethod
    public void setUp() {
        this.messageContext = new MessageContext();
        this.handler = new PopulateHttpClientSecurityParametersHandler();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testConfig() throws ComponentInitializationException {
        this.handler.initialize();
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNoContext() throws Exception {
        this.handler.setHttpClientSecurityParametersResolver((HttpClientSecurityParametersResolver)new MockResolver(false));
        this.handler.initialize();
        this.handler.invoke(null);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testResolverError() throws Exception {
        this.handler.setHttpClientSecurityParametersResolver((HttpClientSecurityParametersResolver)new MockResolver(true));
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
    }

    @Test
    public void testSuccess() throws Exception {
        this.handler.setHttpClientSecurityParametersResolver((HttpClientSecurityParametersResolver)new MockResolver(false));
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        Assert.assertNotNull((Object)((HttpClientSecurityContext)this.messageContext.getSubcontext(HttpClientSecurityContext.class)).getSecurityParameters());
        Assert.assertNotNull((Object)((HttpClientSecurityContext)this.messageContext.getSubcontext(HttpClientSecurityContext.class)).getSecurityParameters().getClientTLSCredential());
    }

    @Test
    public void testSuccessIncludeClientTLS() throws Exception {
        this.handler.setHttpClientSecurityParametersResolver((HttpClientSecurityParametersResolver)new MockResolver(false));
        this.handler.setClientTLSPredicate(Predicates.alwaysTrue());
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        Assert.assertNotNull((Object)((HttpClientSecurityContext)this.messageContext.getSubcontext(HttpClientSecurityContext.class)).getSecurityParameters());
        Assert.assertNotNull((Object)((HttpClientSecurityContext)this.messageContext.getSubcontext(HttpClientSecurityContext.class)).getSecurityParameters().getClientTLSCredential());
    }

    @Test
    public void testSuccessExcludeClientTLS() throws Exception {
        this.handler.setHttpClientSecurityParametersResolver((HttpClientSecurityParametersResolver)new MockResolver(false));
        this.handler.setClientTLSPredicate(Predicates.alwaysFalse());
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        Assert.assertNotNull((Object)((HttpClientSecurityContext)this.messageContext.getSubcontext(HttpClientSecurityContext.class)).getSecurityParameters());
        Assert.assertNull((Object)((HttpClientSecurityContext)this.messageContext.getSubcontext(HttpClientSecurityContext.class)).getSecurityParameters().getClientTLSCredential());
    }

    private class MockX509Credential
    implements X509Credential {
        private MockX509Credential() {
        }

        public String getEntityId() {
            return null;
        }

        public UsageType getUsageType() {
            return null;
        }

        public Collection<String> getKeyNames() {
            return null;
        }

        public PublicKey getPublicKey() {
            return null;
        }

        public PrivateKey getPrivateKey() {
            return null;
        }

        public SecretKey getSecretKey() {
            return null;
        }

        public CredentialContextSet getCredentialContextSet() {
            return null;
        }

        public Class<? extends Credential> getCredentialType() {
            return null;
        }

        public X509Certificate getEntityCertificate() {
            return null;
        }

        public Collection<X509Certificate> getEntityCertificateChain() {
            return null;
        }

        public Collection<X509CRL> getCRLs() {
            return null;
        }
    }

    private class MockResolver
    implements HttpClientSecurityParametersResolver {
        private boolean throwException;

        public MockResolver(boolean shouldThrow) {
            this.throwException = shouldThrow;
        }

        public Iterable<HttpClientSecurityParameters> resolve(CriteriaSet criteria) throws ResolverException {
            return Collections.singletonList(this.resolveSingle(criteria));
        }

        public HttpClientSecurityParameters resolveSingle(CriteriaSet criteria) throws ResolverException {
            if (this.throwException) {
                throw new ResolverException();
            }
            Constraint.isNotNull((Object)criteria.get(HttpClientSecurityConfigurationCriterion.class), (String)"Criterion was null");
            HttpClientSecurityParameters params = new HttpClientSecurityParameters();
            params.setClientTLSCredential((X509Credential)new MockX509Credential());
            return params;
        }
    }
}

