/*
 * Decompiled with CFR 0.152.
 */
package org.openscoring.server;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.net.InetSocketAddress;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.openscoring.client.DirectoryDeployer;
import org.openscoring.service.Openscoring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    @Parameter(names={"--console-war"}, description="Console web application (WAR) file or directory", hidden=true)
    private File consoleWar = null;
    @Parameter(names={"--context-path"}, description="Context path")
    private String contextPath = "/openscoring";
    @Parameter(names={"--help"}, description="Show the list of configuration options and exit", help=true)
    private boolean help = false;
    @Parameter(names={"--host"}, description="Server host name or ip address")
    private String host = null;
    @Parameter(names={"--model-dir"}, description="PMML model auto-deployment directory", hidden=true)
    private File modelDir = null;
    @Parameter(names={"--port"}, description="Server port")
    private int port = 8080;
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) throws Exception {
        Main.execute(Main.class, args);
    }

    public static void execute(Class<? extends Main> clazz, String ... args) throws Exception {
        Main main = clazz.newInstance();
        JCommander commander = new JCommander((Object)main);
        commander.setProgramName(clazz.getName());
        try {
            commander.parse(args);
        }
        catch (ParameterException pe) {
            commander.usage();
            System.exit(-1);
        }
        if (main.help) {
            commander.usage();
            System.exit(0);
        }
        main.run();
    }

    public void run() throws Exception {
        InetSocketAddress address = this.host != null ? new InetSocketAddress(this.host, this.port) : new InetSocketAddress(this.port);
        Server server = this.createServer(address);
        server.start();
        if (this.modelDir != null) {
            final DirectoryDeployer deployer = new DirectoryDeployer();
            deployer.setDir(this.modelDir);
            deployer.setModelCollection("http://" + address.getHostString() + ":" + String.valueOf(address.getPort()) + this.contextPath + "/model");
            Thread deployerThread = new Thread(){

                @Override
                public void run() {
                    try {
                        deployer.run();
                    }
                    catch (Exception e) {
                        logger.error("Model auto-deployment interrupted", (Throwable)e);
                    }
                }
            };
            deployerThread.start();
        }
        server.join();
    }

    private Server createServer(InetSocketAddress address) {
        Server server = new Server(address);
        Openscoring application = new Openscoring();
        ServletContainer jerseyServlet = new ServletContainer((ResourceConfig)application);
        ServletContextHandler servletHandler = new ServletContextHandler();
        servletHandler.setContextPath(this.contextPath);
        servletHandler.addServlet(new ServletHolder((Servlet)jerseyServlet), "/*");
        ContextHandlerCollection handlerCollection = new ContextHandlerCollection();
        handlerCollection.addHandler((Handler)servletHandler);
        if (this.consoleWar != null) {
            WebAppContext consoleHandler = new WebAppContext();
            consoleHandler.setContextPath(this.contextPath + "/console");
            consoleHandler.setWar(this.consoleWar.getAbsolutePath());
            handlerCollection.addHandler((Handler)consoleHandler);
        }
        server.setHandler((Handler)handlerCollection);
        return server;
    }
}

