/*
 * Decompiled with CFR 0.152.
 */
package org.openscoring.server;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openscoring.common.EvaluationRequest;
import org.openscoring.common.EvaluationResponse;
import org.supercsv.io.CsvListReader;
import org.supercsv.io.CsvMapReader;
import org.supercsv.io.CsvMapWriter;
import org.supercsv.prefs.CsvPreference;

/*
 * Exception performing whole class analysis ignored.
 */
public class CsvUtil {
    private CsvUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CsvPreference getFormat(BufferedReader reader) throws IOException {
        CsvPreference[] formats;
        reader.mark(10240);
        for (CsvPreference format : formats = new CsvPreference[]{CsvPreference.EXCEL_PREFERENCE, CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE, CsvPreference.TAB_PREFERENCE}) {
            try {
                if (!CsvUtil.checkFormat((BufferedReader)reader, (CsvPreference)format)) continue;
                CsvPreference csvPreference = format;
                return csvPreference;
            }
            finally {
                reader.reset();
            }
        }
        throw new IOException("Unrecognized CSV format");
    }

    private static boolean checkFormat(BufferedReader reader, CsvPreference format) throws IOException {
        List row;
        CsvListReader parser = new CsvListReader((Reader)reader, format);
        int columns = 0;
        for (int line = 0; line < 11 && (row = parser.read()) != null; ++line) {
            if (columns != 0 && columns != row.size()) {
                columns = -1;
                break;
            }
            columns = row.size();
        }
        return columns > 2;
    }

    public static List<EvaluationRequest> readTable(BufferedReader reader, CsvPreference format) throws IOException {
        Map arguments;
        ArrayList requests = Lists.newArrayList();
        CsvMapReader parser = new CsvMapReader((Reader)reader, format);
        String[] header = parser.getHeader(true);
        while ((arguments = parser.read(header)) != null) {
            EvaluationRequest request = new EvaluationRequest();
            request.setArguments(arguments);
            requests.add(request);
        }
        parser.close();
        return requests;
    }

    public static void writeTable(BufferedWriter writer, CsvPreference format, List<EvaluationResponse> responses) throws IOException {
        CsvMapWriter formatter = new CsvMapWriter((Writer)writer, format);
        String[] header = null;
        for (EvaluationResponse response : responses) {
            Map result = response.getResult();
            if (header == null) {
                Set keys = result.keySet();
                header = keys.toArray(new String[keys.size()]);
                formatter.writeHeader(header);
            }
            formatter.write(result, header);
        }
        formatter.flush();
        formatter.close();
    }
}

