/*
 * Decompiled with CFR 0.152.
 */
package org.openscoring.server;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sun.jersey.api.NotFoundException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.IOUtil;
import org.dmg.pmml.PMML;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.manager.ModelManagerFactory;
import org.jpmml.manager.PMMLManager;
import org.openscoring.common.EvaluationRequest;
import org.openscoring.common.EvaluationResponse;
import org.openscoring.common.SummaryResponse;
import org.openscoring.server.CsvUtil;
import org.supercsv.prefs.CsvPreference;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="model")
public class ModelService {
    private static final Map<String, PMML> cache = Maps.newLinkedHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/xml", "text/xml"})
    @Produces(value={"text/plain"})
    public String deploy(@PathParam(value="id") String id, @Context HttpServletRequest request) {
        PMML pmml;
        try {
            ServletInputStream is = request.getInputStream();
            try {
                pmml = IOUtil.unmarshal((InputStream)is);
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        cache.put(id, pmml);
        return "Model " + id + " deployed successfully";
    }

    @GET
    @Produces(value={"application/json"})
    public List<String> getDeployedIds() {
        ArrayList<String> result = new ArrayList<String>(cache.keySet());
        return result;
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public SummaryResponse getSummary(@PathParam(value="id") String id) {
        PMML pmml = (PMML)cache.get(id);
        if (pmml == null) {
            throw new NotFoundException();
        }
        SummaryResponse response = new SummaryResponse();
        try {
            PMMLManager pmmlManager = new PMMLManager(pmml);
            Evaluator evaluator = (Evaluator)pmmlManager.getModelManager(null, (ModelManagerFactory)ModelEvaluatorFactory.getInstance());
            response.setActiveFields(ModelService.toValueList((List)evaluator.getActiveFields()));
            response.setGroupFields(ModelService.toValueList((List)evaluator.getGroupFields()));
            response.setPredictedFields(ModelService.toValueList((List)evaluator.getPredictedFields()));
            response.setOutputFields(ModelService.toValueList((List)evaluator.getOutputFields()));
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return response;
    }

    @POST
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public EvaluationResponse evaluate(@PathParam(value="id") String id, EvaluationRequest request) {
        List<EvaluationRequest> requests = Collections.singletonList(request);
        List responses = this.evaluateBatch(id, requests);
        return (EvaluationResponse)responses.get(0);
    }

    @POST
    @Path(value="{id}/batch")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<EvaluationResponse> evaluateBatch(@PathParam(value="id") String id, List<EvaluationRequest> requests) {
        PMML pmml = (PMML)cache.get(id);
        if (pmml == null) {
            throw new NotFoundException();
        }
        ArrayList<EvaluationResponse> responses = new ArrayList<EvaluationResponse>();
        try {
            PMMLManager pmmlManager = new PMMLManager(pmml);
            Evaluator evaluator = (Evaluator)pmmlManager.getModelManager(null, (ModelManagerFactory)ModelEvaluatorFactory.getInstance());
            List groupFields = evaluator.getGroupFields();
            if (groupFields.size() == 1) {
                FieldName groupField = (FieldName)groupFields.get(0);
                requests = ModelService.aggregateRequests((String)groupField.getValue(), requests);
            } else if (groupFields.size() > 1) {
                throw new EvaluationException();
            }
            for (EvaluationRequest request : requests) {
                EvaluationResponse response = ModelService.evaluate((Evaluator)evaluator, (EvaluationRequest)request);
                responses.add(response);
            }
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return responses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{id}/csv")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public void evaluateCsv(@PathParam(value="id") String id, @Context HttpServletRequest request, @Context HttpServletResponse response) {
        List requests;
        CsvPreference format;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), "UTF-8"));
            try {
                format = CsvUtil.getFormat((BufferedReader)reader);
                requests = CsvUtil.readTable((BufferedReader)reader, (CsvPreference)format);
            }
            finally {
                reader.close();
            }
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        List responses = this.evaluateBatch(id, requests);
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
            try {
                CsvUtil.writeTable((BufferedWriter)writer, (CsvPreference)format, (List)responses);
            }
            finally {
                writer.close();
            }
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"text/plain"})
    public String undeploy(@PathParam(value="id") String id) {
        PMML pmml = (PMML)cache.remove(id);
        if (pmml == null) {
            throw new NotFoundException();
        }
        return "Model " + id + " undeployed successfully";
    }

    private static EvaluationResponse evaluate(Evaluator evaluator, EvaluationRequest request) {
        EvaluationResponse response = new EvaluationResponse();
        LinkedHashMap arguments = Maps.newLinkedHashMap();
        List activeFields = evaluator.getActiveFields();
        for (FieldName activeField : activeFields) {
            Object value = request.getArgument(activeField.getValue());
            arguments.put(activeField, EvaluatorUtil.prepare((Evaluator)evaluator, (FieldName)activeField, (Object)value));
        }
        Map result = evaluator.evaluate((Map)arguments);
        response.setResult(EvaluatorUtil.decode((Map)result));
        return response;
    }

    private static List<String> toValueList(List<FieldName> names) {
        ArrayList result = Lists.newArrayListWithCapacity((int)names.size());
        for (FieldName name : names) {
            result.add(name.getValue());
        }
        return result;
    }

    private static List<EvaluationRequest> aggregateRequests(String groupKey, List<EvaluationRequest> requests) {
        LinkedHashMap groupedArguments = Maps.newLinkedHashMap();
        for (EvaluationRequest request : requests) {
            Map arguments = request.getArguments();
            Object v = arguments.get(groupKey);
            ListMultimap groupedArgumentMap = (ListMultimap)groupedArguments.get(v);
            if (groupedArgumentMap == null) {
                groupedArgumentMap = ArrayListMultimap.create();
                groupedArguments.put(v, groupedArgumentMap);
            }
            Set entries = arguments.entrySet();
            for (Map.Entry entry : entries) {
                groupedArgumentMap.put(entry.getKey(), entry.getValue());
            }
        }
        if (groupedArguments.size() == requests.size()) {
            return requests;
        }
        ArrayList resultRequests = Lists.newArrayList();
        Set entries = groupedArguments.entrySet();
        for (Map.Entry entry : entries) {
            LinkedHashMap arguments = Maps.newLinkedHashMap();
            arguments.putAll(((ListMultimap)entry.getValue()).asMap());
            arguments.put(groupKey, entry.getKey());
            EvaluationRequest resultRequest = new EvaluationRequest();
            resultRequest.setArguments((Map)arguments);
            resultRequests.add(resultRequest);
        }
        return resultRequests;
    }
}

