/*
 * Decompiled with CFR 0.152.
 */
package org.openscoring.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openscoring.common.EvaluationRequest;
import org.openscoring.common.EvaluationResponse;
import org.supercsv.encoder.CsvEncoder;
import org.supercsv.encoder.DefaultCsvEncoder;
import org.supercsv.io.CsvListReader;
import org.supercsv.io.CsvMapReader;
import org.supercsv.io.CsvMapWriter;
import org.supercsv.prefs.CsvPreference;

public class CsvUtil {
    private CsvUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CsvPreference getFormat(BufferedReader reader) throws IOException {
        CsvPreference[] templates;
        reader.mark(10240);
        for (CsvPreference template : templates = new CsvPreference[]{CsvPreference.EXCEL_PREFERENCE, CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE, CsvPreference.TAB_PREFERENCE}) {
            CsvPreference format = CsvUtil.createFormat(template);
            try {
                if (!CsvUtil.checkFormat(reader, format)) continue;
                CsvPreference csvPreference = format;
                return csvPreference;
            }
            finally {
                reader.reset();
            }
        }
        throw new IOException("Unrecognized CSV format");
    }

    private static CsvPreference createFormat(CsvPreference template) {
        CsvPreference.Builder builder = new CsvPreference.Builder(template);
        builder.useEncoder((CsvEncoder)new DefaultCsvEncoder());
        return builder.build();
    }

    private static boolean checkFormat(BufferedReader reader, CsvPreference format) throws IOException {
        List row;
        CsvListReader parser = new CsvListReader((Reader)reader, format);
        int columns = 0;
        for (int line = 0; line < 11 && (row = parser.read()) != null; ++line) {
            if (columns != 0 && columns != row.size()) {
                return false;
            }
            columns = row.size();
        }
        return columns > 1;
    }

    public static List<EvaluationRequest> readTable(BufferedReader reader, CsvPreference format, String idColumn) throws IOException {
        Map arguments;
        ArrayList requests = Lists.newArrayList();
        CsvMapReader parser = new CsvMapReader((Reader)reader, format);
        String[] header = parser.getHeader(true);
        while ((arguments = parser.read(header)) != null) {
            String id = (String)arguments.remove(idColumn);
            EvaluationRequest request = new EvaluationRequest(id);
            request.setArguments(arguments);
            requests.add(request);
        }
        parser.close();
        return requests;
    }

    public static void writeTable(BufferedWriter writer, CsvPreference format, String idColumn, List<EvaluationResponse> responses) throws IOException {
        CsvMapWriter formatter = new CsvMapWriter((Writer)writer, format);
        String[] header = null;
        for (EvaluationResponse response : responses) {
            Map<String, ?> result = response.getResult();
            if (idColumn != null) {
                result = CsvUtil.join(Collections.singletonMap(idColumn, response.getId()), result);
            }
            if (header == null) {
                Set keys = result.keySet();
                header = keys.toArray(new String[keys.size()]);
                formatter.writeHeader(header);
            }
            formatter.write((Map)result, header);
        }
        formatter.flush();
        formatter.close();
    }

    private static Map<String, ?> join(Map<String, ?> left, Map<String, ?> right) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        result.putAll(left);
        result.putAll(right);
        return result;
    }
}

